/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JOptionPane;
import pencilbox.common.gui.FileChooser;
import pencilbox.common.gui.PanelBase;

public class PanelImageWriter {
    private static final String formatName = "png";
    private BufferedImage image;
    private PanelBase panel;

    public void run(PanelBase panel) {
        this.panel = panel;
        this.makePanelImage();
        this.saveFile();
    }

    private void makePanelImage() {
        this.image = new BufferedImage(this.panel.getBoardRegionSize().width, this.panel.getBoardRegionSize().height, 2);
        Graphics2D g2 = this.image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.panel.drawPanel(g2);
    }

    private void saveFile() {
        if (this.image == null) {
            return;
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        ImageWriter writer = iter.next();
        FileChooser chooser = FileChooser.getImageFileChooser();
        int r = chooser.showSaveDialog(null);
        if (r != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        try {
            ImageOutputStream imageOut = ImageIO.createImageOutputStream(f);
            writer.setOutput(imageOut);
            writer.write(new IIOImage(this.image, null, null));
            imageOut.close();
        }
        catch (IOException exception) {
            JOptionPane.showMessageDialog(null, exception);
        }
    }
}

