/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import pencilbox.common.gui.ImageSelection;
import pencilbox.common.gui.PanelBase;

public class PanelImageTransfer {
    private BufferedImage image;
    private PanelBase panel;

    public void run(PanelBase panel) {
        this.panel = panel;
        this.makePanelImage();
        this.copy();
    }

    private void makePanelImage() {
        this.image = new BufferedImage(this.panel.getBoardRegionSize().width, this.panel.getBoardRegionSize().height, 2);
        Graphics2D g2 = this.image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.panel.getWidth(), this.panel.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.panel.drawPanel(g2);
    }

    private void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ImageSelection selection = new ImageSelection(this.image);
        clipboard.setContents(selection, null);
    }
}

