/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Size;
import pencilbox.common.gui.CellCursor;

public class PanelBase
extends JPanel
implements Printable {
    private Size size;
    protected BufferedImage backgroundImage;
    protected BufferedImage originalImage;
    protected AffineTransform backgroundImageTransform = AffineTransform.getRotateInstance(Math.toRadians(0.0));
    protected boolean useBackgroundImage = false;
    private int cellSize = 26;
    private int halfCellSize = this.cellSize / 2;
    private int circleSize = 18;
    private int crossSize = 8;
    private int smallCrossSize = 3;
    private int offsetx = 26;
    private int offsety = 26;
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private Color gridColor = Color.BLACK;
    private Color numberColor = Color.BLACK;
    private Color cursorColor = new Color(0xFF0000);
    private Color answerCursorColor = new Color(255);
    private Font indexFont = new Font("SansSerif", 2, 13);
    private Font numberFont = new Font("SansSerif", 0, 20);
    private int displayStyle = 0;
    private boolean showIndexMode = true;
    private boolean cursorOn = false;
    private CellCursor cellCursor;
    private boolean problemEditMode = false;

    public PanelBase() {
        this.setFocusable(true);
    }

    public void setup(BoardBase board) {
        this.size = board.getSize();
        this.updatePreferredSize();
        this.setBoard(board);
        this.cellCursor = this.createCursor();
    }

    public CellCursor createCursor() {
        return new CellCursor();
    }

    protected void setBoard(BoardBase board) {
    }

    public void setImage(BufferedImage image) {
        this.backgroundImage = image;
        this.originalImage = image;
        this.repaint();
    }

    protected void setDisplaySize(int cellSize) {
        this.cellSize = cellSize;
        if (this.showIndexMode) {
            this.offsetx = cellSize;
            this.offsety = cellSize;
        }
        this.setHalfCellSize(cellSize / 2);
        this.circleSize = (int)((double)cellSize * 0.7);
        this.crossSize = (int)((double)cellSize * 0.3);
        this.smallCrossSize = (int)((double)cellSize * 0.15);
        this.numberFont = new Font("SansSerif", 0, cellSize * 4 / 5);
        this.indexFont = new Font("SansSerif", 2, cellSize / 2);
        this.updatePreferredSize();
        this.repaint();
    }

    protected int getDisplayStyle() {
        return this.displayStyle;
    }

    protected void setDisplayStyle(int i) {
        this.displayStyle = i;
    }

    protected void updatePreferredSize() {
        this.setPreferredSize(this.getBoardRegionSize());
        this.revalidate();
    }

    public Dimension getBoardRegionSize() {
        return new Dimension(this.offsetx * 2 + this.cellSize * this.cols() + 1, this.offsety * 2 + this.cellSize * this.rows() + 1);
    }

    public void setProblemEditMode(boolean problemEditMode) {
        this.problemEditMode = problemEditMode;
    }

    public boolean isProblemEditMode() {
        return this.problemEditMode;
    }

    public int rows() {
        return this.size.getRows();
    }

    public int cols() {
        return this.size.getCols();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawPanel(g2);
    }

    public void drawPanel(Graphics2D g) {
    }

    protected void drawBoard(Graphics2D g) {
    }

    public final int toX(int c) {
        return this.offsetx + this.cellSize * c;
    }

    public final int toY(int r) {
        return this.offsety + this.cellSize * r;
    }

    public void paintBackground(Graphics2D g) {
        if (this.useBackgroundImage && this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, this.backgroundImageTransform, null);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(this.offsetx, this.offsety, this.cellSize * this.cols(), this.cellSize * this.rows());
        }
    }

    public void drawBorder(Graphics2D g) {
        g.setColor(this.borderColor);
        g.drawRect(this.offsetx - 1, this.offsety - 1, this.cellSize * this.cols() + 2, this.cellSize * this.rows() + 2);
        g.drawRect(this.offsetx, this.offsety, this.cellSize * this.cols(), this.cellSize * this.rows());
    }

    public void drawGrid(Graphics2D g) {
        g.setColor(this.gridColor);
        int r = 1;
        while (r < this.rows()) {
            g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
            ++r;
        }
        int c = 1;
        while (c < this.cols()) {
            g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
            ++c;
        }
    }

    public void drawIndex(Graphics2D g) {
        int firstIndex = 1;
        g.setFont(this.indexFont);
        g.setColor(this.numberColor);
        if (!this.showIndexMode) {
            return;
        }
        int r = 0;
        while (r < this.rows()) {
            this.placeIndexNumber(g, r, -1, r + firstIndex);
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            this.placeIndexNumber(g, -1, c, c + firstIndex);
            ++c;
        }
    }

    public void drawCursor(Graphics2D g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.cursorColor);
        } else if (this.cursorOn) {
            g.setColor(this.answerCursorColor);
        } else {
            return;
        }
        g.drawRect(this.toX(this.cellCursor.c()), this.toY(this.cellCursor.r()), this.cellSize, this.cellSize);
        g.drawRect(this.toX(this.cellCursor.c()) + 1, this.toY(this.cellCursor.r()) + 1, this.cellSize - 2, this.cellSize - 2);
        g.drawRect(this.toX(this.cellCursor.c()) + 2, this.toY(this.cellCursor.r()) + 2, this.cellSize - 4, this.cellSize - 4);
    }

    public void drawLineSegment(Graphics g, int x, int y, int direction) {
        if (direction == 1) {
            g.fillRect(x, y - 1, this.cellSize + 1, 3);
        } else if (direction == 0) {
            g.fillRect(x - 1, y, 3, this.cellSize + 1);
        }
    }

    public void drawCross(Graphics g, int x, int y, int halfSize) {
        g.drawLine(x - halfSize, y - halfSize, x + halfSize, y + halfSize);
        g.drawLine(x - halfSize, y + halfSize, x + halfSize, y - halfSize);
    }

    public void drawMidline(Graphics g, int x, int y, int direction) {
        int length = this.getHalfCellSize();
        if (direction == 1) {
            g.drawLine(x - length, y, x + length, y);
        } else if (direction == 0) {
            g.drawLine(x, y - length, x, y + length);
        }
    }

    public void drawMidline3(Graphics g, int x, int y, int direction) {
        int length = this.getHalfCellSize();
        if (direction == 1) {
            g.drawLine(x - length, y - 1, x + length, y - 1);
            g.drawLine(x - length, y, x + length, y);
            g.drawLine(x - length, y + 1, x + length, y + 1);
        } else if (direction == 0) {
            g.drawLine(x - 1, y - length, x - 1, y + length);
            g.drawLine(x, y - length, x, y + length);
            g.drawLine(x + 1, y - length, x + 1, y + length);
        }
    }

    public void placeLetter(Graphics2D g, int r, int c, char letter) {
        FontMetrics metrics = g.getFontMetrics();
        try {
            String string = Character.toString(letter);
            g.drawString(string, this.toX(c) + (this.cellSize - 1 - metrics.stringWidth(string)) / 2 + 1, this.toY(r) + (this.cellSize - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void placeNumber(Graphics2D g, int r, int c, int number) {
        FontMetrics metrics = g.getFontMetrics();
        try {
            String numS = Integer.toString(number);
            g.drawString(numS, this.toX(c) + (this.cellSize - 1 - metrics.stringWidth(numS)) / 2 + 1, this.toY(r) + (this.cellSize - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void placeIndexNumber(Graphics2D g, int r, int c, int number) {
        FontMetrics metrics = g.getFontMetrics();
        try {
            String numS = Integer.toString(number);
            g.drawString(numS, this.toX(c) + (this.cellSize - 1 - metrics.stringWidth(numS)) / 2 + 1, this.toY(r) + (this.cellSize - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void paintCell(Graphics2D g, int r, int c) {
        g.fillRect(this.toX(c) + 1, this.toY(r) + 1, this.cellSize - 1, this.cellSize - 1);
    }

    public void placeCircle(Graphics2D g, int r, int c) {
        g.drawOval(this.toX(c) + (this.cellSize - this.circleSize) / 2, this.toY(r) + (this.cellSize - this.circleSize) / 2, this.circleSize, this.circleSize);
    }

    public void placeCircle(Graphics2D g, int r, int c, int circleSize) {
        g.drawOval(this.toX(c) + (this.cellSize - circleSize) / 2, this.toY(r) + (this.cellSize - circleSize) / 2, circleSize, circleSize);
    }

    public void placeLargeCircle(Graphics2D g, int r, int c) {
        this.placeCircle(g, r, c, this.cellSize - 2);
    }

    public void placeBoldCircle(Graphics2D g, int r, int c) {
        int x = this.toX(c) + (this.cellSize - this.circleSize) / 2;
        int y = this.toY(r) + (this.cellSize - this.circleSize) / 2;
        g.drawOval(x, y, this.circleSize, this.circleSize);
        g.drawOval(x + 1, y + 1, this.circleSize - 2, this.circleSize - 2);
    }

    public void placeBoldCircle(Graphics2D g, int r, int c, int circleSize) {
        int x = this.toX(c) + (this.cellSize - circleSize) / 2;
        int y = this.toY(r) + (this.cellSize - circleSize) / 2;
        g.drawOval(x, y, circleSize, circleSize);
        g.drawOval(x + 1, y + 1, circleSize - 2, circleSize - 2);
    }

    public void placeFilledCircle(Graphics2D g, int r, int c) {
        g.fillOval(this.toX(c) + (this.cellSize - this.circleSize) / 2, this.toY(r) + (this.cellSize - this.circleSize) / 2, this.circleSize + 1, this.circleSize + 1);
    }

    public void placeLargeFilledCircle(Graphics2D g, int r, int c) {
        this.placeFilledCircle(g, r, c, this.cellSize - 2);
    }

    public void placeFilledCircle(Graphics2D g, int r, int c, int circleSize) {
        g.fillOval(this.toX(c) + (this.cellSize - circleSize) / 2, this.toY(r) + (this.cellSize - circleSize) / 2, circleSize + 1, circleSize + 1);
    }

    public void placeCross(Graphics2D g, int r, int c) {
        this.drawCross(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), this.crossSize);
    }

    public void placeSideLine(Graphics2D g, int d, int r, int c) {
        this.drawLineSegment(g, this.toX(c + (d ^ 1)), this.toY(r + d), d);
    }

    public void placeTraversalLine(Graphics2D g, int d, int r, int c) {
        this.drawLineSegment(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), d ^ 1);
    }

    public void placeSideCross(Graphics2D g, int d, int r, int c) {
        if (d == 0) {
            this.drawCross(g, this.toX(c + 1), this.toY(r) + this.getHalfCellSize(), this.smallCrossSize);
        } else if (d == 1) {
            this.drawCross(g, this.toX(c) + this.getHalfCellSize(), this.toY(r + 1), this.smallCrossSize);
        }
    }

    public void placeMidline(Graphics2D g, int r, int c, int dir) {
        this.drawMidline(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), dir);
    }

    public void placeSquare(Graphics2D g, int r0, int c0, int r1, int c1) {
        g.drawRect(this.toX(c0 < c1 ? c0 : c1) + 1, this.toY(r0 < r1 ? r0 : r1) + 1, this.cellSize * ((c0 < c1 ? c1 - c0 : c0 - c1) + 1) - 2, this.cellSize * ((r0 < r1 ? r1 - r0 : r0 - r1) + 1) - 2);
    }

    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.scale(0.7, 0.7);
        this.drawPanel(g2);
        return 0;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setHalfCellSize(int halfCellSize) {
        this.halfCellSize = halfCellSize;
    }

    public int getHalfCellSize() {
        return this.halfCellSize;
    }

    public void setCircleSize(int circleSize) {
        this.circleSize = circleSize;
    }

    public int getCircleSize() {
        return this.circleSize;
    }

    public void setCrossSize(int crossSize) {
        this.crossSize = crossSize;
    }

    public int getCrossSize() {
        return this.crossSize;
    }

    public void setSmallCrossSize(int smallCrossSize) {
        this.smallCrossSize = smallCrossSize;
    }

    public int getSmallCrossSize() {
        return this.smallCrossSize;
    }

    public void setOffsetx(int offsetx) {
        this.offsetx = offsetx;
    }

    public int getOffsetx() {
        return this.offsetx;
    }

    public void setOffsety(int offsety) {
        this.offsety = offsety;
    }

    public int getOffsety() {
        return this.offsety;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setNumberColor(Color numberColor) {
        this.numberColor = numberColor;
    }

    public Color getNumberColor() {
        return this.numberColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorOn(boolean cursorOn) {
        this.cursorOn = cursorOn;
    }

    public boolean isCursorOn() {
        return this.cursorOn;
    }

    protected void setNumberFont(Font numberFont) {
        this.numberFont = numberFont;
    }

    protected Font getNumberFont() {
        return this.numberFont;
    }

    protected void setCellCursor(CellCursor cellCursor) {
        this.cellCursor = cellCursor;
    }

    protected CellCursor getCellCursor() {
        return this.cellCursor;
    }

    public boolean isShowIndexMode() {
        return this.showIndexMode;
    }

    public void setShowIndexMode(boolean showIndex) {
        this.showIndexMode = showIndex;
    }

    public void changeShowIndexMode(boolean b) {
        this.showIndexMode = b;
        if (b) {
            this.setOffsetx(this.getCellSize());
            this.setOffsety(this.getCellSize());
        } else {
            this.setOffsetx(5);
            this.setOffsety(5);
        }
        this.updatePreferredSize();
    }
}

