/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PanelEventHandlerBase;

public class MenuBase {
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenu viewMenu;
    private JMenu helpMenu;
    private JMenuItem newBoardItem;
    private JMenuItem openItem;
    private JMenuItem coloseAndOpenItem;
    private JMenuItem saveItem;
    private JMenuItem duplicateItem;
    private JMenuItem exportProblemDataStringItem;
    private JMenuItem saveImageItem;
    private JMenuItem copyImageItem;
    private JMenuItem printItem;
    private JMenuItem propertyItem;
    private JMenuItem closeItem;
    private JMenuItem quiteItem;
    private JMenuItem aboutItem;
    private JMenuItem clearItem;
    private JMenuItem trimAnswerItem;
    private JMenuItem symmetricPlacementItem;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private JMenuItem palybackItem;
    private JMenuItem checkAnswerItem;
    private JMenuItem renewColorItem;
    private JMenuItem cursorItem;
    private ButtonGroup modeGroup;
    private JMenuItem problemEditModeItem;
    private JMenuItem answerModeItem;
    private JMenu colorMenu;
    private JMenu rotationMenu;
    private JMenu displaySizeMenu;
    private ButtonGroup displaySizeGroup;
    private JMenu gridStyleMenu;
    private ButtonGroup gridStyleGroup;
    private JMenuItem showIndexModeItem;
    private Frame frame;
    private MenuCommand command;
    private PanelBase panel;
    private ActionListener rotationCommandAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            JMenuItem target = (JMenuItem)e.getSource();
            MenuBase.this.command.rotateBoard(Integer.parseInt(target.getActionCommand()));
            MenuBase.this.panel.repaint();
        }
    };
    private ActionListener changeColorAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Color color = JColorChooser.showDialog(MenuBase.this.panel, e.getActionCommand(), MenuBase.this.getColor((JMenuItem)e.getSource()));
            if (color != null) {
                MenuBase.this.setColor((JMenuItem)e.getSource(), color);
            }
            MenuBase.this.panel.repaint();
        }
    };
    private ActionListener commandAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MenuBase.this.executeCommand((JMenuItem)e.getSource());
        }
    };

    public void setup(MenuCommand command, Frame frame, PanelBase panel) {
        this.frame = frame;
        this.command = command;
        this.panel = panel;
        this.buildCommonMenu();
        this.buildIndividualMenu();
        this.setAccelerators();
    }

    protected PanelBase getPanelBase() {
        return this.panel;
    }

    protected PanelEventHandlerBase getPanelEventHandlerBase() {
        return this.command.getPanelEventHandlerBase();
    }

    protected void buildCommonMenu() {
        this.buildFileMenu();
        this.buiildEditMenu();
        this.buildViewMenu();
        this.buildHelpMenu();
        JMenuBar jMenuBar = this.frame.getJMenuBar();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.editMenu);
        jMenuBar.add(this.viewMenu);
        jMenuBar.add(this.helpMenu);
    }

    protected void buildIndividualMenu() {
    }

    protected void buildFileMenu() {
        this.fileMenu = this.makeJMenu("\u30d5\u30a1\u30a4\u30eb(F)", 'F');
        this.newBoardItem = this.makeCommandMenuItem("\u65b0\u898f\u4f5c\u6210(N)...", 'N');
        this.fileMenu.add(this.newBoardItem);
        this.openItem = this.makeCommandMenuItem("\u958b\u304f(O)...", 'O');
        this.fileMenu.add(this.openItem);
        this.coloseAndOpenItem = this.makeCommandMenuItem("\u9589\u3058\u3066\u958b\u304f(L)...", 'L');
        this.fileMenu.add(this.coloseAndOpenItem);
        this.saveItem = this.makeCommandMenuItem("\u4fdd\u5b58(S)...", 'S');
        this.fileMenu.add(this.saveItem);
        this.duplicateItem = this.makeCommandMenuItem("\u8907\u88fd(D)", 'D');
        this.fileMenu.add(this.duplicateItem);
        this.rotationMenu = this.makeJMenu("\u56de\u8ee2\u30fb\u53cd\u8ee2(R)", 'R');
        this.fileMenu.add(this.rotationMenu);
        this.buildRotationMenu();
        this.fileMenu.addSeparator();
        this.exportProblemDataStringItem = this.makeCommandMenuItem("\u554f\u984c\u30c7\u30fc\u30bf\u6587\u5b57\u5217\u51fa\u529b(E)...", 'E');
        this.fileMenu.add(this.exportProblemDataStringItem);
        this.saveImageItem = this.makeCommandMenuItem("\u753b\u50cf\u4fdd\u5b58(I)...", 'I');
        this.fileMenu.add(this.saveImageItem);
        this.copyImageItem = this.makeCommandMenuItem("\u753b\u50cf\u30b3\u30d4\u30fc(M)", 'M');
        this.fileMenu.add(this.copyImageItem);
        this.printItem = this.makeCommandMenuItem("\u5370\u5237(P)...", 'P');
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.propertyItem = this.makeCommandMenuItem("\u30d7\u30ed\u30d1\u30c6\u30a3(T)", 'T');
        this.fileMenu.add(this.propertyItem);
        this.fileMenu.addSeparator();
        this.closeItem = this.makeCommandMenuItem("\u9589\u3058\u308b(C)", 'C');
        this.fileMenu.add(this.closeItem);
        this.quiteItem = this.makeCommandMenuItem("\u7d42\u4e86(Q)", 'Q');
        this.fileMenu.add(this.quiteItem);
    }

    protected void buiildEditMenu() {
        this.editMenu = this.makeJMenu("\u7de8\u96c6(E)", 'E');
        this.answerModeItem = this.makeCommandRadioButtonMenuItem("\u89e3\u7b54\u30e2\u30fc\u30c9(A)", 'A');
        this.editMenu.add(this.answerModeItem);
        this.problemEditModeItem = this.makeCommandRadioButtonMenuItem("\u554f\u984c\u5165\u529b\u30e2\u30fc\u30c9(E)", 'E');
        this.editMenu.add(this.problemEditModeItem);
        this.editMenu.addSeparator();
        this.clearItem = this.makeCommandMenuItem("\u89e3\u7b54\u6d88\u53bb(C)", 'C');
        this.editMenu.add(this.clearItem);
        this.editMenu.addSeparator();
        this.undoItem = this.makeCommandMenuItem("\u5143\u306b\u623b\u3059(U)", 'U');
        this.editMenu.add(this.undoItem);
        this.redoItem = this.makeCommandMenuItem("\u3084\u308a\u76f4\u3057(R)", 'R');
        this.editMenu.add(this.redoItem);
        this.palybackItem = this.makeCommandMenuItem("\u5c65\u6b74\u518d\u751f(P)", 'P');
        this.editMenu.add(this.palybackItem);
        this.editMenu.addSeparator();
        this.checkAnswerItem = this.makeCommandMenuItem("\u6b63\u7b54\u5224\u5b9a(H)", 'H');
        this.editMenu.add(this.checkAnswerItem);
        this.modeGroup = new ButtonGroup();
        this.modeGroup.add(this.answerModeItem);
        this.modeGroup.add(this.problemEditModeItem);
        this.editMenu.addMenuListener(new EditMenuListener());
    }

    protected void buildViewMenu() {
        this.viewMenu = this.makeJMenu("\u8868\u793a(V)", 'V');
        this.buildDisplaySizeMenu();
        this.buildGridStyleMenu();
        this.colorMenu = this.makeJMenu("\u8272\u306e\u8a2d\u5b9a(L)", 'L');
        this.viewMenu.add(this.colorMenu);
        this.viewMenu.add(this.displaySizeMenu);
        this.showIndexModeItem = this.makeCheckBoxCommandMenuItem("\u884c\u5217\u756a\u53f7\u8868\u793a(I)", 'I', true);
        this.viewMenu.add(this.showIndexModeItem);
        this.viewMenu.addSeparator();
        this.viewMenu.addMenuListener(new ViewMenuListener());
    }

    protected void buildHelpMenu() {
        this.helpMenu = this.makeJMenu("\u30d8\u30eb\u30d7(H)", 'H');
        this.aboutItem = this.makeCommandMenuItem("PencilBox\u306b\u3064\u3044\u3066(A)", 'A');
        this.helpMenu.add(this.aboutItem);
    }

    protected void buildRotationMenu() {
        this.makeRotationItem("\u5de690\u00b0\u56de\u8ee2(1)", '1', "1");
        this.makeRotationItem("180\u00b0\u56de\u8ee2(2)", '2', "2");
        this.makeRotationItem("\u53f390\u00b0\u56de\u8ee2(3)", '3', "3");
        this.makeRotationItem("\u7e26\u6a2a\u4ea4\u63db(4)", '4', "4");
        this.makeRotationItem("\u5de6\u53f3\u53cd\u8ee2(5)", '5', "5");
        this.makeRotationItem("180\u00b0\u56de\u8ee2+\u7e26\u6a2a\u4ea4\u63db(6)", '6', "6");
        this.makeRotationItem("\u4e0a\u4e0b\u53cd\u8ee2(7)", '7', "7");
    }

    protected void buildRotationMenu2() {
        this.makeRotationItem("\u7e26\u6a2a\u4ea4\u63db(4)", '4', "4");
    }

    void buildDisplaySizeMenu() {
        this.displaySizeMenu = this.makeJMenu("\u8868\u793a\u30b5\u30a4\u30ba(S)", 'S');
        this.displaySizeGroup = new ButtonGroup();
        this.makeDisplaySizeItem(32, "\u5927");
        this.makeDisplaySizeItem(26, "\u4e2d").setSelected(true);
        this.makeDisplaySizeItem(20, "\u5c0f");
        this.makeDisplaySizeItem(14, "\u6975\u5c0f");
    }

    protected void buildGridStyleMenu() {
        this.gridStyleMenu = this.makeJMenu("\u7f6b\u7dda\u8868\u793a(G)", 'G');
        this.gridStyleGroup = new ButtonGroup();
    }

    private void setAccelerators() {
        this.newBoardItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.coloseAndOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.closeItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.answerModeItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.problemEditModeItem.setAccelerator(KeyStroke.getKeyStroke(113, 1));
        if (this.renewColorItem != null) {
            this.renewColorItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        }
    }

    protected void addTrimAnswerMenuItem() {
        this.trimAnswerItem = this.makeCommandMenuItem("\u88dc\u52a9\u8a18\u53f7\u6d88\u53bb(T)", 'T');
        this.editMenu.add((Component)this.trimAnswerItem, 4);
    }

    protected void addSymmetricPlacementMenuItem() {
        this.symmetricPlacementItem = this.makeCheckBoxCommandMenuItem("\u5bfe\u79f0\u914d\u7f6e(S)", 'S', false);
        this.editMenu.insertSeparator(8);
        this.editMenu.add((Component)this.symmetricPlacementItem, 9);
    }

    protected void addCursorMenu() {
        this.cursorItem = this.makeJCheckBoxMenuItem("\u30ab\u30fc\u30bd\u30eb(C)", 'C', this.panel.isCursorOn());
        this.cursorItem.addActionListener(this.commandAction);
        this.viewMenu.add((Component)this.cursorItem, 3);
    }

    protected void addRenewColorMenu() {
        this.renewColorItem = this.makeCommandMenuItem("\u8272\u306e\u66f4\u65b0(U)", 'U');
        this.viewMenu.add(this.renewColorItem);
    }

    protected void addGridStyleMenu() {
        this.viewMenu.add((Component)this.gridStyleMenu, 3);
    }

    protected void addToViewMenu(JMenuItem item) {
        this.viewMenu.add(item);
    }

    protected JMenuItem makeRotationItem(String text, char mnemonic, String n) {
        JMenuItem rotationItem = new JMenuItem(text, mnemonic);
        rotationItem.addActionListener(this.rotationCommandAction);
        rotationItem.setActionCommand(n);
        this.rotationMenu.add(rotationItem);
        return rotationItem;
    }

    protected JRadioButtonMenuItem makeDisplaySizeItem(final int n, String text) {
        JRadioButtonMenuItem displaySizeItem = new JRadioButtonMenuItem(text);
        displaySizeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBase.this.panel.setDisplaySize(n);
                MenuBase.this.frame.resize();
            }
        });
        this.displaySizeGroup.add(displaySizeItem);
        this.displaySizeMenu.add(displaySizeItem);
        return displaySizeItem;
    }

    protected JRadioButtonMenuItem makeDisplayStyleItem(final int n, String text) {
        JRadioButtonMenuItem gridStyleItem = new JRadioButtonMenuItem(text);
        gridStyleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuBase.this.panel.setDisplayStyle(n);
                MenuBase.this.panel.repaint();
            }
        });
        this.gridStyleGroup.add(gridStyleItem);
        this.gridStyleMenu.add(gridStyleItem);
        return gridStyleItem;
    }

    protected JMenuItem addColorMenuItem(String text) {
        JMenuItem item = new JMenuItem(text);
        item.addActionListener(this.changeColorAction);
        this.colorMenu.add(item);
        return item;
    }

    public Color getColor(JMenuItem name) {
        return null;
    }

    public void setColor(JMenuItem name, Color color) {
    }

    public void executeCommand(JMenuItem target) {
        if (target == this.newBoardItem) {
            this.command.newBoard();
        } else if (target == this.openItem) {
            this.command.open();
        } else if (target == this.coloseAndOpenItem) {
            this.command.closeAndOpen();
        } else if (target == this.saveItem) {
            this.command.save();
        } else if (target == this.duplicateItem) {
            this.command.duplicate();
        } else if (target == this.exportProblemDataStringItem) {
            this.command.exporProblemDatatString();
        } else if (target == this.saveImageItem) {
            this.command.saveImage();
        } else if (target == this.copyImageItem) {
            this.command.copyImage();
        } else if (target == this.printItem) {
            this.command.print();
        } else if (target == this.propertyItem) {
            this.command.property();
        } else if (target == this.closeItem) {
            this.command.close();
        } else if (target == this.quiteItem) {
            this.command.quit();
        } else if (target == this.aboutItem) {
            this.command.about();
        } else if (target == this.clearItem) {
            this.command.clear();
        } else if (target == this.trimAnswerItem) {
            this.command.trimAnswer();
        } else if (target == this.symmetricPlacementItem) {
            this.command.setSymmetricPlacementMode(target.isSelected());
        } else if (target == this.undoItem) {
            this.command.undo();
        } else if (target == this.redoItem) {
            this.command.redo();
        } else if (target == this.palybackItem) {
            this.command.playback();
        } else if (target == this.checkAnswerItem) {
            this.command.checkAnswer();
        } else if (target == this.renewColorItem) {
            this.command.renewColor();
        } else if (target == this.cursorItem) {
            this.command.setCursorOn(target.isSelected());
        } else if (target == this.answerModeItem) {
            this.command.setProblemEditMode(false);
        } else if (target == this.problemEditModeItem) {
            this.command.setProblemEditMode(true);
        } else if (target == this.showIndexModeItem) {
            this.command.setShowIndexMode(target.isSelected());
        } else {
            this.executeCommand2(target);
        }
        this.panel.repaint();
    }

    public void executeCommand2(JMenuItem target) {
    }

    protected JMenuItem makeCommandMenuItem(String title, char mnumonic) {
        JMenuItem item = this.makeJMenuItem(title, mnumonic);
        item.addActionListener(this.commandAction);
        return item;
    }

    protected JMenuItem makeCommandRadioButtonMenuItem(String title, char mnumonic) {
        JMenuItem item = this.makeJRadioButtonMenuItem(title, mnumonic);
        item.addActionListener(this.commandAction);
        return item;
    }

    protected JCheckBoxMenuItem makeCheckBoxCommandMenuItem(String title, char mnumonic, boolean initial) {
        JCheckBoxMenuItem item = this.makeJCheckBoxMenuItem(title, mnumonic, initial);
        item.addActionListener(this.commandAction);
        return item;
    }

    public void updateCurrentMenuSelection() {
        this.showIndexModeItem.setSelected(this.getPanelBase().isShowIndexMode());
        if (this.cursorItem != null) {
            this.cursorItem.setSelected(this.getPanelBase().isCursorOn());
        }
        if (this.symmetricPlacementItem != null) {
            this.symmetricPlacementItem.setSelected(this.getPanelEventHandlerBase().isSymmetricPlacementMode());
        }
        this.problemEditModeItem.setSelected(this.getPanelEventHandlerBase().isProblemEditMode());
    }

    public JMenu makeJMenu(String text, char mnemonic) {
        JMenu menu = new JMenu(text);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public JMenuItem makeJMenuItem(String text, char mnemonic) {
        return new JMenuItem(text, mnemonic);
    }

    public JMenuItem makeJRadioButtonMenuItem(String text, char mnemonic) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(text);
        item.setMnemonic(mnemonic);
        return item;
    }

    public JCheckBoxMenuItem makeJCheckBoxMenuItem(String text, char mnemonic, boolean initial) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(text);
        item.setMnemonic(mnemonic);
        item.setSelected(initial);
        return item;
    }

    protected class EditMenuListener
    implements MenuListener {
        protected EditMenuListener() {
        }

        public void menuSelected(MenuEvent evt) {
            MenuBase.this.undoItem.setEnabled(MenuBase.this.command.canUndo());
            MenuBase.this.redoItem.setEnabled(MenuBase.this.command.canRedo());
            MenuBase.this.palybackItem.setEnabled(MenuBase.this.command.canUndo() || MenuBase.this.command.canRedo());
            boolean b = MenuBase.this.getPanelBase().isProblemEditMode();
            MenuBase.this.problemEditModeItem.setSelected(b);
            MenuBase.this.answerModeItem.setSelected(!b);
        }

        public void menuDeselected(MenuEvent evt) {
            MenuBase.this.undoItem.setEnabled(true);
            MenuBase.this.redoItem.setEnabled(true);
            MenuBase.this.palybackItem.setEnabled(true);
        }

        public void menuCanceled(MenuEvent evt) {
        }
    }

    protected class ViewMenuListener
    implements MenuListener {
        protected ViewMenuListener() {
        }

        public void menuSelected(MenuEvent evt) {
        }

        public void menuDeselected(MenuEvent evt) {
        }

        public void menuCanceled(MenuEvent evt) {
        }
    }
}

