/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.gui.PanelBase;

public class HintDot {
    private static int[] DIGIT = new int[26];
    private Color dotColor = Color.MAGENTA;
    private int dotSize = 6;
    private int dotDist = 6;
    private int dotOffset = 1;
    private int unit = 3;
    private int maxNumber = 9;
    private PanelBase panel;

    static {
        int i = 0;
        while (i <= 25) {
            HintDot.DIGIT[i] = 1 << i;
            ++i;
        }
    }

    public void setDot(PanelBase panel, int unit, int cellSize) {
        this.panel = panel;
        this.maxNumber = unit * unit;
        this.unit = unit;
        this.setDotSize(cellSize);
    }

    public void setDotSize(int cellSize) {
        int s = (cellSize - 3) / this.unit;
        this.dotSize = s <= 3 ? 2 : s - 2;
        this.dotOffset = 2;
        this.dotDist = (cellSize - this.dotOffset * 2 - this.dotSize) / (this.unit - 1);
    }

    public void placeHintCross(Graphics2D g, int r, int c) {
        g.setColor(Color.red);
        this.panel.placeCross(g, r, c);
    }

    public void placeHintDot(Graphics2D g, int r, int c, int pattern) {
        g.setColor(this.dotColor);
        int x = this.panel.toX(c) + this.dotOffset;
        int y = this.panel.toY(r) + this.dotOffset;
        int d = 1;
        while (d <= this.maxNumber) {
            if ((pattern & DIGIT[d]) != 0) {
                int dy = (d - 1) / this.unit;
                int dx = (d - 1) % this.unit;
                if (this.dotSize >= 5) {
                    g.fillOval(x + this.dotDist * dx, y + this.dotDist * dy, this.dotSize, this.dotSize);
                } else {
                    g.fillRect(x + this.dotDist * dx, y + this.dotDist * dy, this.dotSize, this.dotSize);
                }
            }
            ++d;
        }
    }
}

