/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.util.Colors;
import pencilbox.yajilin.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnBranchedLink = false;
    private boolean colorForEachLink = false;
    private Color circleColor = Color.MAGENTA;
    private Color lineColor = Color.BLUE;
    private Color paintColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color errorColor = Color.RED;

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isWarnBranchedLink() {
        return this.warnBranchedLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color blackColor) {
        this.paintColor = blackColor;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color whiteColor) {
        this.circleColor = whiteColor;
    }

    public Panel() {
        this.setGridColor(Color.BLACK);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        int state;
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                state = this.board.getNumber(r, c);
                if (state == -2) {
                    g.setColor(this.paintColor);
                    if (this.isWarnBranchedLink() && this.board.isBlock(r, c)) {
                        g.setColor(this.errorColor);
                    }
                    this.paintCell(g, r, c);
                } else if (state == -1) {
                    g.setColor(this.circleColor);
                    this.placeCircle(g, r, c);
                } else if (state >= 0) {
                    g.setColor(this.getNumberColor());
                    this.placeArrow(g, r, c, state);
                } else if (state == -4) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
        int d = 0;
        while (d <= 1) {
            int r2 = 0;
            while (r2 < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    state = this.board.getState(d, r2, c);
                    if (state == 1) {
                        g.setColor(this.lineColor);
                        if (this.isColorForEachLink()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r2, c).getID()));
                        }
                        if (this.isWarnBranchedLink() && this.board.isBranchedLink(d, r2, c)) {
                            g.setColor(this.errorColor);
                        }
                        this.placeTraversalLine(g, d, r2, c);
                    } else if (state == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r2, c);
                    }
                    ++c;
                }
                ++r2;
            }
            ++d;
        }
    }

    private void placeArrow(Graphics2D g, int r, int c, int arrow) {
        this.placeSquare(g, r, c, r, c);
        g.setColor(Color.BLACK);
        int direction = arrow >> 4 & 3;
        int number = arrow & 0xF;
        this.drawArrow(g, r, c, number, direction);
    }

    private void drawArrow(Graphics2D g, int r, int c, int number, int direction) {
        char arrowChar = '\u0000';
        if (direction == 0) {
            arrowChar = '\u2191';
        } else if (direction == 2) {
            arrowChar = '\u2193';
        } else if (direction == 1) {
            arrowChar = '\u2190';
        } else if (direction == 3) {
            arrowChar = '\u2192';
        }
        String arrowS = Character.toString(arrowChar);
        String numberS = Integer.toString(number);
        FontMetrics metrics = g.getFontMetrics();
        if ((direction & 1) == 0) {
            g.drawString(arrowS, this.toX(c) + (this.getCellSize() - 1 - metrics.charWidth(arrowChar)) / 2 + 1 + this.getHalfCellSize() * 4 / 5, this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
        } else if ((direction & 1) == 1) {
            g.drawString(arrowS, this.toX(c) + (this.getCellSize() - 1 - metrics.charWidth(arrowChar)) / 2 + 1, this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1 - this.getHalfCellSize() * 4 / 5);
        }
        g.drawString(numberS, this.toX(c) + (this.getCellSize() - 1 - metrics.stringWidth(numberS)) / 2 + 1, this.toY(r) + (this.getCellSize() - 1 - metrics.getHeight()) / 2 + metrics.getAscent() + 1);
    }
}

