/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlWriterBase;
import pencilbox.slitherlink.Board;

public class XmlWriter
extends XmlWriterBase {
    protected void setBoardData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows() - 1;
        int cols = board.cols() - 1;
        int r = 0;
        while (r < rows) {
            this.startBrow(r);
            int c = 0;
            while (c < cols) {
                int st = board.getNumber(r, c);
                if (st >= 0 && st <= 5) {
                    this.outN(st);
                } else {
                    this.out("s");
                }
                ++c;
            }
            this.endBrow();
            ++r;
        }
    }

    protected void setAnswerData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startArow(r);
            int c = 0;
            while (c < cols) {
                int type = 0;
                if (r < rows - 1 && board.getState(1, r, c) == 1) {
                    ++type;
                }
                if (c < cols - 1 && board.getState(0, r, c) == 1) {
                    type += 2;
                }
                if (r < rows - 1 && board.getState(1, r, c) == -1) {
                    type += 4;
                }
                if (c < cols - 1 && board.getState(0, r, c) == -1) {
                    type += 8;
                }
                switch (type) {
                    case 0: {
                        this.out("s");
                        break;
                    }
                    case 1: {
                        this.out("h");
                        break;
                    }
                    case 2: {
                        this.out("v");
                        break;
                    }
                    case 3: {
                        this.out("hv");
                        break;
                    }
                    default: {
                        this.outN(type);
                    }
                }
                ++c;
            }
            this.endArow();
            ++r;
        }
    }
}

