/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.hitori.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color errorColor = Color.RED;
    private Color singleNumberColor = new Color(0xC0C0C0);
    private boolean hideSingleMode = false;
    private boolean warnMultipleNumber = false;
    private boolean warnWrongWall = false;
    private char[] letters = new char[0];

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public boolean isWarnWrongWall() {
        return this.warnWrongWall;
    }

    public void setWarnWrongWall(boolean warnWrongWall) {
        this.warnWrongWall = warnWrongWall;
    }

    public boolean isWarnMultipleNumber() {
        return this.warnMultipleNumber;
    }

    public void setWarnMultipleNumber(boolean warnMultilpleNumber) {
        this.warnMultipleNumber = warnMultilpleNumber;
    }

    public boolean isHideSingleMode() {
        return this.hideSingleMode;
    }

    public void setHideSingleMode(boolean hideSingleMode) {
        this.hideSingleMode = hideSingleMode;
    }

    String getLetters() {
        return new String(this.letters);
    }

    void setLetters(String string) {
        this.letters = string.toCharArray();
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                int number = this.board.getNumber(r, c);
                this.drawState(g, r, c, state);
                if (number > 0) {
                    this.drawNumber(g, r, c, number);
                } else if (number == -1) {
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawState(Graphics2D g, int r, int c, int state) {
        if (state == -2) {
            g.setColor(this.paintColor);
            if (this.isWarnWrongWall()) {
                if (this.board.getChain(r, c) == -1) {
                    g.setColor(this.errorColor);
                } else {
                    g.setColor(this.paintColor);
                }
                if (this.board.isBlock(r, c)) {
                    g.setColor(this.errorColor);
                }
            }
            this.paintCell(g, r, c);
        } else if (state == -1) {
            g.setColor(this.circleColor);
            this.placeCircle(g, r, c);
        }
    }

    private void drawNumber(Graphics2D g, int r, int c, int number) {
        if (this.isHideSingleMode() && this.board.isSingle(r, c)) {
            g.setColor(this.singleNumberColor);
        } else if (this.isWarnMultipleNumber() && !this.board.isBlack(r, c) && this.board.isMultipleNumber(r, c)) {
            g.setColor(this.errorColor);
        } else {
            g.setColor(this.getNumberColor());
        }
        if (number <= this.letters.length) {
            this.placeLetter(g, r, c, this.letters[number - 1]);
        } else {
            this.placeNumber(g, r, c, number);
        }
    }
}

