/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.bijutsukan.Board;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnWrongIllumination = false;
    private boolean showBeamMode = false;
    private Color wallColor = Color.BLACK;
    private Color illuminationColor = Color.BLUE;
    private Color illuminatedColor = new Color(0xAAFFFF);
    private Color noilluminationColor = Color.MAGENTA;
    private Color wallNumberColor = Color.WHITE;
    private Color errorColor = Color.RED;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isWarnWrongIllumination() {
        return this.warnWrongIllumination;
    }

    public void setWarnWrongIllumination(boolean warnWrongIllumination) {
        this.warnWrongIllumination = warnWrongIllumination;
    }

    public boolean isShowBeamMode() {
        return this.showBeamMode;
    }

    public void setShowBeamMode(boolean showRayMode) {
        this.showBeamMode = showRayMode;
    }

    public Color getIlluminatedColor() {
        return this.illuminatedColor;
    }

    public void setIlluminatedColor(Color illuminatedColor) {
        this.illuminatedColor = illuminatedColor;
    }

    public Color getIlluminationColor() {
        return this.illuminationColor;
    }

    public void setIlluminationColor(Color illuminationColor) {
        this.illuminationColor = illuminationColor;
    }

    public Color getNoilluminationColor() {
        return this.noilluminationColor;
    }

    public void setNoilluminationColor(Color noilluminationColor) {
        this.noilluminationColor = noilluminationColor;
    }

    public void drawPanel(Graphics2D g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    protected void drawBoard(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                int l = this.board.getHorizIlluminated(r, c);
                int m = this.board.getVertIlluminated(r, c);
                if (l > 0 || m > 0) {
                    g.setColor(this.illuminatedColor);
                    this.paintCell(g, r, c);
                }
                if (this.isShowBeamMode()) {
                    g.setColor(this.illuminationColor);
                    if (l > 0) {
                        if (this.isWarnWrongIllumination() && l > 1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeMidline(g, r, c, 1);
                    }
                    g.setColor(this.illuminationColor);
                    if (m > 0) {
                        if (this.isWarnWrongIllumination() && m > 1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeMidline(g, r, c, 0);
                    }
                }
                if (state >= 0 && state <= 5) {
                    g.setColor(this.wallColor);
                    this.paintCell(g, r, c);
                    if (state >= 0 && state <= 4) {
                        int st;
                        g.setColor(this.wallNumberColor);
                        if (this.warnWrongIllumination && (st = this.board.checkAdjacentIllumination(r, c)) == -1) {
                            g.setColor(this.errorColor);
                        }
                        this.placeNumber(g, r, c, state);
                    }
                } else if (state == -2) {
                    g.setColor(this.illuminationColor);
                    if (this.warnWrongIllumination && this.board.isMultiIlluminated(r, c)) {
                        g.setColor(this.errorColor);
                    }
                    this.placeFilledCircle(g, r, c);
                } else if (state == -3) {
                    g.setColor(this.noilluminationColor);
                    this.placeCross(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }
}

