/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Panel;
import pencilbox.shikaku.Square;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private Address dragStart = new Address(Address.NOWEHER);

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.dragStart.set(pos);
        this.setDraggingArea(new Square(this.dragStart.r(), this.dragStart.c(), pos.r(), pos.c()));
    }

    protected void rightPressed(Address dragEnd) {
        this.board.removeSquareIncluding(dragEnd);
    }

    protected void leftDragged(Address dragEnd) {
        if (this.getDraggingArea() == null) {
            return;
        }
        this.getDraggingArea().set(this.dragStart.r(), this.dragStart.c(), dragEnd.r(), dragEnd.c());
    }

    protected void leftDragFixed(Address dragEnd) {
        if (this.getDraggingArea() == null) {
            return;
        }
        this.setDraggingArea(null);
        this.board.addSquareSpanning(this.dragStart, dragEnd);
        this.dragStart.setNowhere();
    }

    protected void dragFailed() {
        this.setDraggingArea(null);
        this.dragStart.setNowhere();
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), -1);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), -1);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), -1);
            }
        }
    }

    void setDraggingArea(Square draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    Square getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }
}

