package pencilbox.kakuro;

import pencilbox.common.core.Address;

/**
 * JbN̏c܂͉̔}XȂ\NX
 */
public class Word {
	
	private Address head;  // }X̍W
	private int size;    // }X
	private int sum;  // v̐
	private int filledSize;   // ܂Ă}X
	private int filledSum;     // ܂Ă鐔̍v

	/**
	 * @return Returns the size.
	 */
	int getSize() {
		return size;
	}
	/**
	 * @return Returns the sum.
	 */
	int getSum() {
		return sum;
	}
	/**
	 * @return Returns the head.
	 */
	Address getHead() {
		return head;
	}
	/**
	 * @param r
	 * @param c
	 * @param count
	 * @param number
	 */
	public Word(int r, int c, int count, int number) {
		
		this.head = new Address(r,c);
		this.size = count;
		this.sum = number; 
		
	}
	public void clear() {
		filledSize = 0;
		filledSum = 0;
	}
	public void addNumber(int after) {
		filledSize++;
		filledSum += after;
	}
	public void removeNumber(int before) {
		filledSize--;
		filledSum -= before;
	}
	public void changeNumber(int before, int after) {
		if (before == 0) {
			if (after > 0) {
				filledSize++;
				filledSum += after;
			} 
		}
		else if (before > 0 ) {
			if (after == 0) {
				filledSize--;
				filledSum -= before;
			} else if (after > 0) {
				filledSum = filledSum - before + after;
			}
		}
	}
	/**
	 * Ԃ擾B
	 * @return
	 * ܂ĂȂ}X : 0
	 * ׂẴ}X܂ĂāCv͐ : 1
	 * ׂẴ}X܂ĂāCv͊ԈႢ : -1
	 * i܂ĂȂ}XāCvȂ肦Ȃj͍͔肵ĂȂ
	 */
	 public int getStatus() {
	 	int status = 0;
	 	if (filledSize < size) status = 0;
	 	else {
	 		if (filledSum == sum) status = 1;
	 		else status = -1;
	 	} 
	 	return status;
	 }
}
