package pencilbox.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.undo.UndoManager;

import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.factory.Constants;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;
import pencilbox.common.io.IOController;
import pencilbox.util.Colors;


/**
 * j[R}hNX
 */
public class MenuCommand {

	private PencilType pencilType;

	private Frame frame;
	private PanelBase panel;
	private PanelEventHandlerBase handler;
	private Problem problem;
	private BoardBase board;
	private UndoManager undoManager;

	private Timer playBackTimer;

	/**
	 * sCeNXƊ֘At
	 * IuWFNgɎgp
	 * @param puzzleType pY̎
	 * @param frame ֘AtFrame
	 * @param panel ֘AtPanel
	 * @param problem ֘AtProblem
	 */
	public void setup(PencilType puzzleType, Frame frame, PanelBase panel, PanelEventHandlerBase handler, Problem problem) {
		this.pencilType = puzzleType;
		this.frame = frame;
		this.panel = panel;
		this.handler = handler;
		this.problem = problem;
		this.board = problem.getBoard();
		setFrameTitle();
		undoManager = new UndoManager();
		undoManager.setLimit(1000);
		board.setUndoManager(undoManager);
		board.initBoard();
	}
	public void setup(PencilType puzzleType, Problem problem) {
		this.pencilType = puzzleType;
//		this.frame = frame;
//		this.panel = panel;
		this.problem = problem;
		this.board = problem.getBoard();
		setFrameTitle();
		undoManager = new UndoManager();
		undoManager.setLimit(1000);
		board.setUndoManager(undoManager);
		board.initBoard();
	}
	/**
	 * @return Returns the panel.
	 */
	public PanelBase getPanelBase() {
		return panel;
	}
	/**
	 * @return Returns the handler.
	 */
	public PanelEventHandlerBase getPanelEventHandlerBase() {
		return handler;
	}
	/**
	 * @return Returns the frame.
	 */
	public Frame getFrame() {
		return frame;
	}
	/**
	 * @return Returns the problem.
	 */
	public Problem getProblem() {
		return problem;
	}

	/**
	 * t[^Cgݒ肷
	 * ҏW̃pY̎ނƃt@C\
	 */
	private void setFrameTitle() {
//		frame.setTitle(problem.getFileName() + " - " + pencilType.getTitle() + " - " + Constants.TITLE);
		frame.setTitle(problem.getFileName() + " - " + Constants.TITLE);
	}
	/**
	 * @param e
	 */
	public void showErrorMessage(Exception e) {
		JOptionPane.showMessageDialog(frame,e.getMessage(),"Error",JOptionPane.ERROR_MESSAGE);
	}
	/**
	 * @param s
	 */
	public void showErrorMessage(String s) {
		JOptionPane.showMessageDialog(frame,s,"Error",JOptionPane.ERROR_MESSAGE);
	}
	
	/*
	 * ȉCej[Ȉ
	 */
	/**
	 *  [t@C]-[VK쐬]
	 */
	public void newBoard() {
		try {
			NewBoardDialog newBoardDialog = NewBoardDialog.getInstance();
//			newBoardDialog.setPencilType(pencilType);
			newBoardDialog.setCurrentSize(board.getSize());
			if (newBoardDialog.showDialog(frame, "VKՖ") == PencilBoxDialog.OK_OPTION) {
				Size newSize = newBoardDialog.getNewSize();
				if (newSize != null && isValidSize(newSize)) {
					PencilFactory.getInstance(pencilType, this).createNewFrame(newSize);
				}
			}
		} catch (PencilBoxClassException e) {
			showErrorMessage(e);
		}
	}
	/**
	 * ՖʃTCY̊mFs
	 * Ƃ̏ꍇ̔ՖʃTCYsB
	 * ʃpYɊւ鏈ʃNXōŝ͂CbIɂŏ邱ƂɂB
	 * ̂ƂB
	 * @param s TCY
	 * @return TCYȂ true Ԃ
	 */
	private boolean isValidSize(Size s) {
		int rows = s.getRows();
		int cols = s.getCols();
		if (rows < 0 || cols < 0) {
			showErrorMessage("sȃTCYł");
			return false;
		} else if (rows > 200 || cols > 200) {
			showErrorMessage("ɑ傫ł");
			return false;
		}
		if (pencilType.getPencilName().equals("sudoku")) {
			if (rows == cols) {
				for (int n = 1; n < 10; n++) {
					if (rows == n*n)
						return true;
				}
			}
			showErrorMessage("sȃTCYł");
			return false;
		}
		return true;
	}
	/**
	 * t@CI_CAO擾C݂̃t@CpXݒ肷B
	 */
	private FileChooser prepareFileChooser() {
		FileChooser fileChooser = FileChooser.getProblemFileChooser();
		File currentFile = problem.getFile();
		if (currentFile != null)
			fileChooser.setSelectedFile(currentFile);
		return fileChooser;
	}
	/**
	 *  [t@C]-[J]
	 */
	public void open() {
		FileChooser fileChooser = prepareFileChooser();
		try {
			if (fileChooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
				File file = fileChooser.getSelectedFile();
				PencilFactory.getInstance(pencilType, this).createNewFrame(file);
			}
		} catch (PencilBoxException e) {
			showErrorMessage(e);
		}
	}
	/**
	 *  [t@C]-[ĊJ]
	 */
	public void closeAndOpen() {
		FileChooser fileChooser = prepareFileChooser();
		try {
			if (fileChooser.showOpenDialog(frame) == JFileChooser.APPROVE_OPTION) {
				File file = fileChooser.getSelectedFile();
				PencilFactory.getInstance(pencilType, this).createNewBoard(file);
			}
		} catch (PencilBoxException e) {
			showErrorMessage(e);
		}
	}
	/**
	 *  [t@C]-[ۑ]
	 */
	public void save() {
		FileChooser fileChooser = prepareFileChooser();
		try {
			if (fileChooser.showSaveDialog(frame) == JFileChooser.APPROVE_OPTION) {
				File file = fileChooser.getSelectedFile();
				IOController.getInstance(pencilType).saveFile(problem, file);
			}
		} catch (PencilBoxException e) {
			showErrorMessage(e);
		}
		setFrameTitle();
	}

	/**
	 *  [t@C]-[]
	 */
	public void duplicate() {
		try {
			PencilFactory.getInstance(pencilType, this).duplicateFrame();
		} catch (PencilBoxClassException e) {
			showErrorMessage(e);
		}
	}

	/**
	 *  [t@C]-[]E]]
	 */
	public void rotateBoard(int n) {
		try {
			PencilFactory.getInstance(pencilType, this).rotateBoard(n);
		} catch (PencilBoxClassException e) {
			showErrorMessage(e);
		}
	}
	/**
	 *  [t@C]-[]
	 * Ȃ
	 */
	public void print() {
		try {
			PrinterJob job = PrinterJob.getPrinterJob();
			job.setPrintable(panel);
			if (job.printDialog()) {
				job.print();
			}
		} catch (PrinterException e) {
			showErrorMessage(e);
		}
	}
	/**
	 *  [t@C]-[f[^o]
	 */
	void exporProblemDatatString() {
		DataExportDialog dataExportFrame = new DataExportDialog();
		try {
			String problemDataS = IOController.getInstance(pencilType).getProblemDataString(board);
			dataExportFrame.setText("problem=" + problemDataS);
			dataExportFrame.showDialog(frame, "f[^o");
		} catch (PencilBoxClassException e) {
			e.printStackTrace();
		}
	}
	/**
	 *  [t@C]-[摜ۑ]
	 */
	public void saveImage() {
		new PanelImageWriter().run(panel);
	}
	/**
	 *  [t@C]-[摜Rs[]
	 */
	public void copyImage() {
		new PanelImageTransfer().run(panel);
	}
	/**
	 *  [t@C]-[vpeB]
	 */
	public void property() {
		PropertyDialog propertyDialog = PropertyDialog.getInstance();
		propertyDialog.setPropertyToDialog(problem.getProperty());
		if (propertyDialog.showDialog(frame, "vpeB") == PencilBoxDialog.OK_OPTION)
			propertyDialog.getPropertyFromDialog(problem.getProperty());
	}
	/**
	 *  [t@C]-[]
	 */
	public void close() {
		frame.dispose();
	}
	/**
	 *  [t@C]-[SI]
	 */
	public void quit() {
		System.exit(0);
	}
	/**
	 *  [wv]-[o[W]
	 */
	public void about() {
//		AboutDialog dialog = AboutDialog.getInstance();
//		dialog.setPuzzleType(puzzleType);
//		showDialog(dialog);
		JOptionPane.showMessageDialog(
				frame,
				getAboutText(),
				Constants.TITLE + "ɂ",
				JOptionPane.INFORMATION_MESSAGE);
	}
	private String getAboutText() {
		return ""
		+ Constants.TITLE + " version " + Constants.VERSION + '\n'
		+ Constants.COPYRIGHT + '\n'
		+ Constants.URL +'\n'
		;
	}

	/**
	 *  [ҏW]-[𓚏]
	 */
	public void clear() {
		undoManager.discardAllEdits();
		board.clearBoard();
		panel.repaint();
	}
	/**
	 *  [ҏW]-[⏕L]
	 */
	public void trimAnswer() {
		board.trimAnswer();
		panel.repaint();
	}
	/**
	 *  [ҏW]-[Ώ̔zu]
	 */
	public void setSymmetricPlacementMode(boolean b) {
		handler.setSymmetricPlacementMode(b);
	}
	/**
	 *  [ҏW]-[]
	 */
	public void checkAnswer() {
		JOptionPane.showMessageDialog(
			frame,
			board.checkAnswerString(),
			"",
			JOptionPane.INFORMATION_MESSAGE);
	}
	/**
	 * [ҏW]-[UNDO]
	 */
	public void undo() {
		if (undoManager.canUndo())
			undoManager.undo();
	}
	/**
	 * [ҏW]-[REDO]
	 */
	public void redo() {
		if (undoManager.canRedo())
			undoManager.redo();
	}
	/**
	 * [ҏW]+[ŏ܂UNDO]
	 */
	public void undoAll() {
		while (undoManager.canUndo()) {
			undoManager.undo();
		}
	}
	/**
	 * [ҏW]+[Ō܂REDO]
	 */
	public void redoAll() {
		while (undoManager.canRedo()) {
			undoManager.redo();
		}
	}
	/**
	 *  [ҏW]-[Đ]
	 */
	public void playback() {
		undoAll();
		if(playBackTimer == null)
			makePlayBackTimer();
		playBackTimer.start();
	}
	/**
	 * Đp^C}[쐬
	 * ߂ɂ͂߂ɎgƂɂPxgp
	 * 
	 */
	private void makePlayBackTimer() {
		playBackTimer = new Timer(10, new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				if (undoManager.canRedo()) {
					undoManager.redo();
					panel.repaint();
				} else {
					playBackTimer.stop();
				}
			}
		});
	}
	/**
	 * UNDO \
	 * @return UNDO \
	 */
	public boolean canUndo() {
		return undoManager.canUndo();
	}
	/**
	 * REDO \
	 * @return REDO \ 
	 */
	public boolean canRedo() {
		return undoManager.canRedo();
	}
	/**
	 *  [ҏW]-[̓[h]
	 *  @param b true Ŗ̓[hɂCfalse ŉ𓚃[hɂ
	 */
	public void setProblemEditMode(boolean b) {
		if(panel.isProblemEditMode() == b)
			return;
		if (b==false)
			board.initBoard();
		handler.setProblemEditMode(b);
		panel.repaint();
	}
	/**
	 *  [\]-[J[\ON]
	 */
	public void setCursorOn(boolean b) {
		panel.setCursorOn(b);
		panel.repaint();
	}
	/**
	 *  [\]-[sԍ\]
	 */
	public void setShowIndexMode(boolean b) {
		panel.changeShowIndexMode(b);
		frame.resize();
	}
	/**
	 *  [\]-[F̍XV]
	 */
	public void renewColor() {
		Colors.randomize();
		panel.repaint();
	}
}
