/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.fillomino.Area;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNSTABLE = 0;
    static final int STABLE = 1;
    static final int UNKNOWN = 0;
    private int[][] state;
    private int[][] number;
    private Area[][] area;
    private List areaList;
    private Area initializingArea;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList();
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isStable(r, c)) {
                    this.number[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    public boolean isStable(int r, int c) {
        return this.state[r][c] == 1;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public boolean isUnknown(int r, int c) {
        return this.number[r][c] == 0;
    }

    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        ArrayUtil.initArrayObject2(this.area, null);
        this.areaList.clear();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0 && this.area[r][c] == null) {
                    this.initArea(r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void initArea(int r, int c) {
        this.initializingArea = new Area(this.getNumber(r, c));
        this.initializingArea.add(r, c);
        this.setArea(r, c, this.initializingArea);
        this.areaList.add(this.initializingArea);
        this.initArea1(r, c);
    }

    private void initArea1(int r, int c) {
        if (this.initArea2(r - 1, c)) {
            this.initArea1(r - 1, c);
        }
        if (this.initArea2(r, c - 1)) {
            this.initArea1(r, c - 1);
        }
        if (this.initArea2(r + 1, c)) {
            this.initArea1(r + 1, c);
        }
        if (this.initArea2(r, c + 1)) {
            this.initArea1(r, c + 1);
        }
    }

    private boolean initArea2(int r, int c) {
        if (!this.isOn(r, c)) {
            return false;
        }
        if (this.getNumber(r, c) != this.initializingArea.getNumber()) {
            return false;
        }
        if (this.getArea(r, c) == this.initializingArea) {
            return false;
        }
        this.initializingArea.add(r, c);
        this.setArea(r, c, this.initializingArea);
        return true;
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void changeNumber(int r, int c, int n) {
        int prevNum = this.getNumber(r, c);
        this.setNumber(r, c, n);
        if (prevNum > 0) {
            this.splitArea(r, c, prevNum);
        }
        if (n > 0) {
            this.mergeArea(r, c, n);
        }
    }

    public void enterNumberA(int r, int c, int n) {
        if (n < 0) {
            return;
        }
        if (n == this.number[r][c]) {
            return;
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.number[r][c], n)));
        this.changeNumber(r, c, n);
    }

    public void increaseNumber(int r, int c) {
        this.enterNumberA(r, c, this.number[r][c] + 1);
    }

    public void decreaseNumber(int r, int c) {
        if (this.number[r][c] <= 0) {
            return;
        }
        this.enterNumberA(r, c, this.number[r][c] - 1);
    }

    void mergeArea(int r, int c, int number) {
        Area mergedArea = null;
        mergedArea = this.mergeArea1(this.getArea(r - 1, c), mergedArea, number);
        mergedArea = this.mergeArea1(this.getArea(r, c - 1), mergedArea, number);
        mergedArea = this.mergeArea1(this.getArea(r + 1, c), mergedArea, number);
        mergedArea = this.mergeArea1(this.getArea(r, c + 1), mergedArea, number);
        if (mergedArea == null) {
            mergedArea = new Area(number);
            this.areaList.add(mergedArea);
        }
        mergedArea.add(r, c);
        this.setArea(r, c, mergedArea);
    }

    private Area mergeArea1(Area area, Area mergedArea, int number) {
        if (area != null && area.getNumber() == number) {
            if (mergedArea == null) {
                mergedArea = area;
            } else if (mergedArea != area) {
                mergedArea.addAll(area);
                Iterator itr = area.iterator();
                while (itr.hasNext()) {
                    Address pos = (Address)itr.next();
                    this.setArea(pos.r(), pos.c(), mergedArea);
                }
                this.areaList.remove(area);
            }
        }
        return mergedArea;
    }

    void splitArea(int r, int c, int number) {
        this.areaList.remove(this.getArea(r, c));
        Iterator itr = this.getArea(r, c).iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            this.setArea(pos.r(), pos.c(), null);
        }
        if (this.isOn(r - 1, c) && this.getNumber(r - 1, c) == number && this.getArea(r - 1, c) == null) {
            this.initArea(r - 1, c);
        }
        if (this.isOn(r, c - 1) && this.getNumber(r, c - 1) == number && this.getArea(r, c - 1) == null) {
            this.initArea(r, c - 1);
        }
        if (this.isOn(r + 1, c) && this.getNumber(r + 1, c) == number && this.getArea(r + 1, c) == null) {
            this.initArea(r + 1, c);
        }
        if (this.isOn(r, c + 1) && this.getNumber(r, c + 1) == number && this.getArea(r, c + 1) == null) {
            this.initArea(r, c + 1);
        }
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isUnknown(r, c)) {
                    result |= 1;
                }
                ++c;
            }
            ++r;
        }
        Iterator itr = this.areaList.iterator();
        while (itr.hasNext()) {
            int status = ((Area)itr.next()).getStatus();
            if (status == -1) {
                result |= 2;
                continue;
            }
            if (status != 0) continue;
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u5b8c\u6210\u3067\u3059";
        }
        if (result == 1) {
            return "\u7a7a\u767d\u30de\u30b9\u304c\u3042\u308b\n";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append("\u6570\u5b57\u3088\u308a\u9762\u7a4d\u306e\u5927\u304d\u3044\u9818\u57df\u304c\u3042\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u6570\u5b57\u3088\u308a\u9762\u7a4d\u306e\u5c0f\u3055\u3044\u9818\u57df\u304c\u3042\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.after);
        }

        public boolean addEdit(UndoableEdit anEdit) {
            Step edit = (Step)anEdit;
            if (edit.row == this.row && edit.col == this.col) {
                this.after = edit.after;
                return true;
            }
            return false;
        }
    }
}

