/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean showStar = true;
    private boolean showAreaBorder = true;
    private boolean showAreaHint = false;
    private Color areaBorderColor = Color.BLUE;
    private Color noStarAreaColor = new Color(0xFFFF80);
    private Color whiteAreaColor = new Color(0x80FFFF);
    private Color blackAreaColor = new Color(0xFF80FF);
    private Color starColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private int halfStarSize = 4;
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getBlackAreaColor() {
        return this.blackAreaColor;
    }

    public void setBlackAreaColor(Color blackAreaColor) {
        this.blackAreaColor = blackAreaColor;
    }

    public Color getWhiteAreaColor() {
        return this.whiteAreaColor;
    }

    public void setWhiteAreaColor(Color whiteAreaColor) {
        this.whiteAreaColor = whiteAreaColor;
    }

    public boolean isShowAreaBorder() {
        return this.showAreaBorder;
    }

    public void setShowAreaBorder(boolean showAreaBorder) {
        this.showAreaBorder = showAreaBorder;
    }

    public boolean isShowStar() {
        return this.showStar;
    }

    public void setShowStar(boolean showStar) {
        this.showStar = showStar;
    }

    public boolean isShowAreaHint() {
        return this.showAreaHint;
    }

    public void setShowAreaHint(boolean useDifferentColor) {
        this.showAreaHint = useDifferentColor;
    }

    public void setDisplaySize(int size) {
        this.halfStarSize = size / 7 + 1;
        super.setDisplaySize(size);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        this.paintAreas(g);
        if (this.isShowStar()) {
            this.drawStars(g);
        }
        if (this.isShowAreaBorder()) {
            this.drawAreaBorders(g);
        }
    }

    private void paintAreas(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.isCovered(r, c) && this.board.getArea(r, c) != this.draggingArea) {
                    if (this.isShowAreaHint()) {
                        int starType = this.board.getArea(r, c).getStarType();
                        if (starType == -1) {
                            g.setColor(this.errorColor);
                        } else if (starType == 1) {
                            g.setColor(this.whiteAreaColor);
                        } else if (starType == 2) {
                            g.setColor(this.blackAreaColor);
                        } else {
                            g.setColor(this.noStarAreaColor);
                        }
                    } else {
                        g.setColor(this.whiteAreaColor);
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawStars(Graphics g) {
        g.setColor(this.starColor);
        int r = 0;
        while (r < this.board.rows() * 2 - 1) {
            int c = 0;
            while (c < this.board.cols() * 2 - 1) {
                if (this.board.hasStar(r, c)) {
                    this.placeStar(g, r, c, this.board.getStar(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics g) {
        int c;
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows() - 1) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) != this.board.getArea(r + 1, c)) {
                    this.placeSideLine(g, 1, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    public void placeStar(Graphics g, int r, int c, int star) {
        if (star == 1) {
            g.drawOval(this.getOffsetx() + this.getHalfCellSize() * (c + 1) - this.halfStarSize, this.getOffsety() + this.getHalfCellSize() * (r + 1) - this.halfStarSize, this.halfStarSize * 2, this.halfStarSize * 2);
        } else if (star == 2) {
            g.fillOval(this.getOffsetx() + this.getHalfCellSize() * (c + 1) - this.halfStarSize, this.getOffsety() + this.getHalfCellSize() * (r + 1) - this.halfStarSize, this.halfStarSize * 2, this.halfStarSize * 2);
        }
    }

    public void drawCursor(Graphics g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.getCursorColor());
            g.drawRect(this.getOffsetx() + (this.getCellSize() * this.getCellCursor().c() + this.getHalfCellSize()) / 2, this.getOffsety() + (this.getCellSize() * this.getCellCursor().r() + this.getHalfCellSize()) / 2, this.getHalfCellSize(), this.getHalfCellSize());
        }
    }
}

