/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean warnWrongNumber = false;
    private boolean highlightSelectedNumber = false;
    private Color inputColor = Color.BLUE;
    private Color areaBorderColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private Color noAreaColor = new Color(0xC0C0C0);
    private int selectedNumber = 0;
    private Color selectedNumberColor = new Color(0xAAFFAA);
    private Color emissionColor = new Color(0x800000);
    private Area draggingArea;
    private boolean showAllowedNumberDot = false;
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorOn(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public int getSelectedNumber() {
        return this.selectedNumber;
    }

    public void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public boolean isHighlightSelectedNumber() {
        return this.highlightSelectedNumber;
    }

    public void setHighlightSelectedNumber(boolean highlightSelectedNumber) {
        this.highlightSelectedNumber = highlightSelectedNumber;
    }

    public boolean isShowAllowedNumberDot() {
        return this.showAllowedNumberDot;
    }

    public void setShowAllowedNumberDot(boolean showAllowedNumberDot) {
        this.showAllowedNumberDot = showAllowedNumberDot;
    }

    public boolean isWarnWrongNumber() {
        return this.warnWrongNumber;
    }

    public void setWarnWrongNumber(boolean warnWrongNumber) {
        this.warnWrongNumber = warnWrongNumber;
    }

    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        this.paintCells(g);
        this.drawEmission(g);
        this.drawNumbers(g);
        if (this.isShowAllowedNumberDot()) {
            this.drawDots(g);
        }
        this.drawBorders(g);
    }

    private void drawEmission(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                if (this.isHighlightSelectedNumber() && n > 0 && n == this.getSelectedNumber()) {
                    int cc = c - n;
                    while (cc <= c + n) {
                        if (cc != c && this.board.isOn(r, cc)) {
                            g.setColor(this.emissionColor);
                            this.placeMidline(g, r, cc, 1);
                        }
                        ++cc;
                    }
                    int rr = r - n;
                    while (rr <= r + n) {
                        if (rr != r && this.board.isOn(rr, c)) {
                            g.setColor(this.emissionColor);
                            this.placeMidline(g, rr, c, 0);
                        }
                        ++rr;
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCells(Graphics g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) == null || this.board.getArea(r, c) == this.draggingArea) {
                    g.setColor(this.noAreaColor);
                    this.paintCell(g, r, c);
                }
                if (this.isHighlightSelectedNumber() && this.getSelectedNumber() > 0 && this.board.getNumber(r, c) == this.getSelectedNumber()) {
                    g.setColor(this.selectedNumberColor);
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                if (this.board.getNumber(r, c) > 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                    } else if (this.isWarnWrongNumber() && this.board.isError(r, c)) {
                        g.setColor(this.errorColor);
                    } else {
                        g.setColor(this.inputColor);
                    }
                    this.placeNumber(g, r, c, this.board.getNumber(r, c));
                } else if (n == 0 && this.board.isStable(r, c)) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawBorders(Graphics g) {
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            if (this.board.getArea(r, 0) != null) {
                this.placeSideLine(g, 0, r, -1);
            }
            if (this.board.getArea(r, this.board.cols() - 1) != null) {
                this.placeSideLine(g, 0, r, this.board.cols() - 1);
            }
            ++r;
        }
        int c = 0;
        while (c < this.board.cols()) {
            int r2 = 0;
            while (r2 < this.board.rows() - 1) {
                if (this.board.getArea(r2, c) != this.board.getArea(r2 + 1, c)) {
                    this.placeSideLine(g, 1, r2, c);
                }
                ++r2;
            }
            if (this.board.getArea(0, c) != null) {
                this.placeSideLine(g, 1, -1, c);
            }
            if (this.board.getArea(this.board.rows() - 1, c) != null) {
                this.placeSideLine(g, 1, this.board.rows() - 1, c);
            }
            ++c;
        }
    }

    private void drawDots(Graphics g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int num = this.board.getNumber(r, c);
                if (num == 0) {
                    int pat = this.board.getPattern(r, c);
                    if (pat == 0) {
                        this.hintDot.placeHintCross(g, r, c);
                    } else {
                        this.hintDot.placeHintDot(g, r, c, pat);
                    }
                }
                ++c;
            }
            ++r;
        }
    }
}

