/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.hashi.Board;
import pencilbox.hashi.Pier;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int UP = 0;
    static final int DN = 2;
    static final int LT = 1;
    static final int RT = 3;
    private Board board;
    private boolean colorForEachLink = false;
    private boolean showNumberHint = false;
    private Color bridgeColor = Color.BLUE;
    private Color crossBridgeColor = Color.RED;
    private Color errorColor = Color.RED;
    private Color successColor = Color.GREEN;

    public Panel() {
        this.setGridColor(Color.GRAY);
        this.setDisplayStyle(2);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getBridgeColor() {
        return this.bridgeColor;
    }

    public void setBridgeColor(Color bridgeColor) {
        this.bridgeColor = bridgeColor;
    }

    public boolean isColorForEachLink() {
        return this.colorForEachLink;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public boolean isShowNumberHint() {
        return this.showNumberHint;
    }

    public void setShowNumberHint(boolean showNumberHint) {
        this.showNumberHint = showNumberHint;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        if (this.getDisplayStyle() == 0) {
            this.drawGrid(g);
        }
        this.drawBoard(g);
        this.drawBorder(g);
        this.drawCursor(g);
    }

    void drawBoard(Graphics g) {
        g.setFont(this.getNumberFont());
        g.setColor(this.getNumberColor());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.isPier(r, c)) {
                    this.placeBridgeAndPier(g, r, c, this.board.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    void placeBridgeAndPier(Graphics g, int r0, int c0, int n) {
        Pier pier = this.board.getPier(r0, c0);
        if (this.isColorForEachLink()) {
            g.setColor(Colors.getColor(pier.getChain()));
        } else {
            g.setColor(this.bridgeColor);
        }
        int r = r0;
        int c = c0;
        if (pier.getNBridge(2) > 0) {
            while (!this.board.isPier(++r, c)) {
                this.placeMidlines(g, r, c, 0, pier.getNBridge(2));
            }
        }
        r = r0;
        c = c0;
        if (pier.getNBridge(3) > 0) {
            while (!this.board.isPier(r, ++c)) {
                this.placeMidlines(g, r, c, 1, pier.getNBridge(3));
            }
        }
        this.placePier(g, r0, c0, n);
    }

    void placePier(Graphics g, int r, int c, int n) {
        if (this.isShowNumberHint()) {
            if (this.board.checkPier(r, c) < 0) {
                g.setColor(this.errorColor);
                this.placeFilledCircle(g, r, c, this.getCellSize());
            } else if (this.board.checkPier(r, c) == 0) {
                g.setColor(this.successColor);
                this.placeFilledCircle(g, r, c, this.getCellSize());
            }
        }
        g.setColor(this.getNumberColor());
        this.placeCircle(g, r, c, this.getCellSize());
        if (n <= 8) {
            this.placeNumber(g, r, c, n);
        }
    }

    void placeBridge(Graphics g, int r, int c) {
        int v = this.board.getVertBridge(r, c);
        int h = this.board.getHorizBridge(r, c);
        if (v > 0 && h > 0) {
            g.setColor(this.crossBridgeColor);
        } else {
            g.setColor(this.bridgeColor);
        }
        if (v > 0) {
            this.placeMidlines(g, r, c, 0, v);
        }
        if (h > 0) {
            this.placeMidlines(g, r, c, 1, h);
        }
    }

    public void placeMidlines(Graphics g, int r, int c, int dir, int n) {
        if (n == 1) {
            this.drawMidline(g, this.toX(c), this.toY(r), dir);
        } else if (n == 2) {
            this.drawMidline2(g, this.toX(c), this.toY(r), dir);
        }
    }

    public void drawMidline(Graphics g, int x, int y, int direction) {
        if (direction == 1) {
            g.fillRect(x, y + this.getHalfCellSize() - 1, this.getCellSize() + 1, 3);
        } else if (direction == 0) {
            g.fillRect(x + this.getHalfCellSize() - 1, y, 3, this.getCellSize() + 1);
        }
    }

    public void drawMidline2(Graphics g, int x, int y, int direction) {
        if (direction == 1) {
            g.fillRect(x, y + this.getCellSize() / 3 - 1, this.getCellSize() + 1, 3);
            g.fillRect(x, y + this.getCellSize() * 2 / 3 - 1, this.getCellSize() + 1, 3);
        } else if (direction == 0) {
            g.fillRect(x + this.getCellSize() / 3 - 1, y, 3, this.getCellSize() + 1);
            g.fillRect(x + this.getCellSize() * 2 / 3 - 1, y, 3, this.getCellSize() + 1);
        }
    }
}

