/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.io.PclReaderBase;
import pencilbox.common.io.PclWriterBase;
import pencilbox.common.io.TxtReaderBase;
import pencilbox.common.io.TxtWriterBase;
import pencilbox.common.io.XmlReaderBase;
import pencilbox.common.io.XmlWriterBase;

public class IOController {
    private static final int EXT_PCL = 3;
    private static final int EXT_XML = 1;
    private PencilType pencilType;

    public static IOController getInstance(PencilType pencilType) {
        return new IOController(pencilType);
    }

    private IOController(PencilType pencilType) {
        this.pencilType = pencilType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Problem openFile(File file) throws PencilBoxException {
        block18: {
            problem = null;
            board = null;
            in = null;
            is = null;
            try {
                try {
                    switch (this.checkFileExt(file)) {
                        case 3: {
                            is = new FileInputStream(file);
                            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            doc = builder.parse(is);
                            pclReader = this.createPclReader();
                            problem = pclReader.makeProblem(doc);
                            break;
                        }
                        case 1: {
                            is = new FileInputStream(file);
                            xmlReader = this.createXmlReader();
                            problem = xmlReader.readProblem(is);
                            break;
                        }
                        default: {
                            in = new FileReader(file);
                            txtReader = this.createTxtReader();
                            board = txtReader.readProblem(in);
                            problem = new Problem(board);
                            break;
                        }
                    }
                }
                catch (ParserConfigurationException e) {
                    throw new PencilBoxException(e);
                }
                catch (SAXException e) {
                    throw new PencilBoxException(e);
                }
                catch (IOException e) {
                    throw new PencilBoxException(e);
                }
                catch (RuntimeException e) {
                    throw new PencilBoxException(e);
                }
            }
            catch (Throwable var12_15) {
                var11_16 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (is == null) throw var12_15;
                    is.close();
                    throw var12_15;
                }
                catch (IOException var13_18) {
                    // empty catch block
                }
                throw var12_15;
            }
            {
                var11_17 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 205->228)] { 
lbl49:
            // 1 sources

            if (in != null) {
                in.close();
            }
            if (is != null) {
                is.close();
            }
            break block18;
lbl54:
            // 1 sources

            catch (IOException var13_19) {
                // empty catch block
            }
        }
        problem.setFile(file);
        return problem;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Problem readProblemData(String problemData) throws PencilBoxException {
        block10: {
            problem = null;
            board = null;
            in = null;
            try {
                try {
                    in = new StringReader(problemData.replace('/', '\n').replace('_', ' '));
                    txtReader = this.createTxtReader();
                    board = txtReader.readProblem(in);
                    problem = new Problem(board);
                }
                catch (IOException e) {
                    throw new PencilBoxException(e);
                }
                catch (RuntimeException e) {
                    throw new PencilBoxException(e);
                }
            }
            catch (Throwable var7_8) {
                var6_9 = null;
                try {
                    if (in == null) throw var7_8;
                    in.close();
                    throw var7_8;
                }
                catch (IOException var8_11) {
                    // empty catch block
                }
                throw var7_8;
            }
            {
                var6_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 91->104)] { 
lbl27:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block10;
lbl30:
            // 1 sources

            catch (IOException var8_12) {
                // empty catch block
            }
        }
        problem.setFile(null);
        return problem;
    }

    /*
     * Exception decompiling
     */
    public void saveFile(Problem problem, File file) throws PencilBoxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 213->217)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getProblemDataString(BoardBase board) throws PencilBoxClassException {
        TxtWriterBase txtWriter = this.createTxtWriter();
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        txtWriter.writeQuestion(out, board);
        String separator = System.getProperty("line.separator");
        String problemDataS = sw.toString().replace(separator, "/").replace(' ', '_');
        out.close();
        return problemDataS;
    }

    private int checkFileExt(File file) {
        String filename = file.getName();
        int len = filename.length();
        if (len >= 4) {
            if (filename.substring(len - 4).equals(".pcl")) {
                return 3;
            }
            if (filename.substring(len - 4).equals(".xml")) {
                return 1;
            }
        }
        return 0;
    }

    private XmlReaderBase createXmlReader() throws PencilBoxClassException {
        XmlReaderBase xmlReader = (XmlReaderBase)ClassUtil.createInstance(this.pencilType, "XmlReader");
        xmlReader.setPuzzleType(this.pencilType.getPencilName());
        return xmlReader;
    }

    private XmlWriterBase createXmlWriter() throws PencilBoxClassException {
        XmlWriterBase xmlWriter = (XmlWriterBase)ClassUtil.createInstance(this.pencilType, "XmlWriter");
        xmlWriter.setPuzzleType(this.pencilType.getPencilName());
        return xmlWriter;
    }

    private PclReaderBase createPclReader() throws PencilBoxClassException {
        PclReaderBase pclReader = (PclReaderBase)ClassUtil.createInstance(this.pencilType, "PclReader");
        return pclReader;
    }

    private PclWriterBase createPclWriter() throws PencilBoxClassException {
        PclWriterBase pclWriter = (PclWriterBase)ClassUtil.createInstance(this.pencilType, "PclWriter");
        return pclWriter;
    }

    private TxtReaderBase createTxtReader() throws PencilBoxClassException {
        TxtReaderBase txtReader = (TxtReaderBase)ClassUtil.createInstance(this.pencilType, "TxtReader");
        return txtReader;
    }

    private TxtWriterBase createTxtWriter() throws PencilBoxClassException {
        TxtWriterBase txtWriter = (TxtWriterBase)ClassUtil.createInstance(this.pencilType, "TxtWriter");
        return txtWriter;
    }
}

