/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.PanelBase;

public class PanelEventHandlerBase {
    private PanelBase panel;
    private BoardBase board;
    private KeyHandler keyHandler = new KeyHandler();
    private MouseHandler mouseHandler = new MouseHandler();
    private MouseHandlerEdge mouseHandlerEdge = new MouseHandlerEdge();
    private int maxInputNumber = 99;
    private int previousInput = 0;
    private int symmetricPlacementMode = 0;

    public void setup(PanelBase panel, BoardBase board) {
        this.panel = panel;
        this.board = board;
        this.setBoard(board);
        panel.addKeyListener(this.keyHandler);
        panel.addMouseListener(this.mouseHandler);
        panel.addMouseMotionListener(this.mouseHandler);
        panel.addMouseListener(this.mouseHandlerEdge);
    }

    public void setup(BoardBase board) {
        this.board = board;
        this.setBoard(board);
        this.getCellCursor().resetPosition();
        this.resetPreviousInput();
    }

    protected void setBoard(BoardBase board) {
    }

    public PanelBase getPanel() {
        return this.panel;
    }

    public boolean isSymmetricPlacementMode() {
        return this.symmetricPlacementMode == 1;
    }

    public void setSymmetricPlacementMode(boolean symmetricPlacementMode) {
        this.symmetricPlacementMode = symmetricPlacementMode ? 1 : 0;
    }

    protected void setMaxInputNumber(int number) {
        this.maxInputNumber = number;
    }

    public void resetPreviousInput() {
        this.previousInput = 0;
    }

    public int getCellSize() {
        return this.panel.getCellSize();
    }

    public int getHalfCellSize() {
        return this.panel.getHalfCellSize();
    }

    public int getOffsetx() {
        return this.panel.getOffsetx();
    }

    public int getOffsety() {
        return this.panel.getOffsety();
    }

    public boolean isProblemEditMode() {
        return this.panel.isProblemEditMode();
    }

    public void setProblemEditMode(boolean b) {
        this.panel.setProblemEditMode(b);
        this.resetPreviousInput();
    }

    public CellCursor getCellCursor() {
        return this.panel.getCellCursor();
    }

    public boolean isCursorOn() {
        return this.panel.isCursorOn();
    }

    public void repaint() {
        this.panel.repaint();
    }

    public boolean isOn(Address position) {
        return this.board.isOn(position);
    }

    public boolean isSideOn(SideAddress position) {
        return this.board.isSideOn(position);
    }

    public boolean isCursorOnBoard(Address position) {
        return this.board.isOn(position);
    }

    public final int toC(int x) {
        return (x + this.getCellSize() - this.getOffsetx()) / this.getCellSize() - 1;
    }

    public final int toR(int y) {
        return (y + this.getCellSize() - this.getOffsety()) / this.getCellSize() - 1;
    }

    public Address getSymmetricPosition(Address pos) {
        return new Address(this.board.rows() - 1 - pos.r(), this.board.cols() - 1 - pos.c());
    }

    protected void arrowKeyEntered(int direction) {
        if (!this.isProblemEditMode() && !this.isCursorOn()) {
            return;
        }
        Address pos = this.getCellCursor().getPosition();
        pos.move(direction);
        if (this.isCursorOnBoard(pos)) {
            this.getCellCursor().setPosition(pos);
            this.resetPreviousInput();
        }
    }

    protected void numberKeyEntered(int number) {
        if (!this.isProblemEditMode() && !this.isCursorOn()) {
            return;
        }
        Address pos = this.getCellCursor().getPosition();
        if (this.previousInput >= 1 && this.previousInput <= 9) {
            if (this.previousInput * 10 + number <= this.maxInputNumber) {
                number = this.previousInput * 10 + number;
            }
            if (number <= this.maxInputNumber) {
                this.numberEntered(pos, number);
                this.previousInput = 0;
            }
        } else if (number <= this.maxInputNumber) {
            this.numberEntered(pos, number);
            this.previousInput = number;
        }
    }

    protected void numberEntered(Address pos, int num) {
    }

    protected void spaceEntered(Address pos) {
    }

    protected void spaceKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.spaceEntered(pos);
    }

    protected void minusEntered(Address pos) {
    }

    protected void minusKeyEntered() {
        Address pos = this.getCellCursor().getPosition();
        this.minusEntered(pos);
    }

    protected void slashKeyEntered() {
        if (this.isProblemEditMode()) {
            this.board.initBoard();
        }
        this.setProblemEditMode(!this.isProblemEditMode());
    }

    protected void leftPressed(Address position) {
    }

    protected void leftPressedShift(Address position) {
    }

    protected void leftClicked(Address position) {
    }

    protected void leftClickedShift(Address position) {
    }

    protected void leftDragged(Address position) {
    }

    protected void leftDragged(Address oldPos, Address position) {
        this.leftDragged(position);
    }

    protected void leftDragFixed(Address dragEnd) {
    }

    protected void rightPressed(Address position) {
    }

    protected void rightClicked(Address position) {
    }

    protected void rightDragged(Address position) {
    }

    protected void rightDragged(Address oldPos, Address position) {
        this.rightDragged(position);
    }

    protected void rightDragFixed(Address dragEnd) {
    }

    protected void dragFailed() {
    }

    protected void moveCursor(Address position) {
        this.getCellCursor().setPosition(position);
        this.resetPreviousInput();
    }

    protected void leftClickedEdge(SideAddress position) {
    }

    protected void leftClickedShiftEdge(SideAddress position) {
    }

    protected void rightClickedEdge(SideAddress position) {
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 47: 
                case 111: {
                    PanelEventHandlerBase.this.slashKeyEntered();
                    break;
                }
                case 37: {
                    PanelEventHandlerBase.this.arrowKeyEntered(1);
                    break;
                }
                case 38: {
                    PanelEventHandlerBase.this.arrowKeyEntered(0);
                    break;
                }
                case 39: {
                    PanelEventHandlerBase.this.arrowKeyEntered(3);
                    break;
                }
                case 40: {
                    PanelEventHandlerBase.this.arrowKeyEntered(2);
                    break;
                }
                case 32: 
                case 46: 
                case 110: {
                    PanelEventHandlerBase.this.spaceKeyEntered();
                    break;
                }
                case 45: 
                case 109: {
                    PanelEventHandlerBase.this.minusKeyEntered();
                    break;
                }
                case 59: 
                case 107: {
                    break;
                }
                case 106: 
                case 513: {
                    break;
                }
                case 48: 
                case 96: {
                    PanelEventHandlerBase.this.numberKeyEntered(0);
                    break;
                }
                case 49: 
                case 97: {
                    PanelEventHandlerBase.this.numberKeyEntered(1);
                    break;
                }
                case 50: 
                case 98: {
                    PanelEventHandlerBase.this.numberKeyEntered(2);
                    break;
                }
                case 51: 
                case 99: {
                    PanelEventHandlerBase.this.numberKeyEntered(3);
                    break;
                }
                case 52: 
                case 100: {
                    PanelEventHandlerBase.this.numberKeyEntered(4);
                    break;
                }
                case 53: 
                case 101: {
                    PanelEventHandlerBase.this.numberKeyEntered(5);
                    break;
                }
                case 54: 
                case 102: {
                    PanelEventHandlerBase.this.numberKeyEntered(6);
                    break;
                }
                case 55: 
                case 103: {
                    PanelEventHandlerBase.this.numberKeyEntered(7);
                    break;
                }
                case 56: 
                case 104: {
                    PanelEventHandlerBase.this.numberKeyEntered(8);
                    break;
                }
                case 57: 
                case 105: {
                    PanelEventHandlerBase.this.numberKeyEntered(9);
                }
            }
            PanelEventHandlerBase.this.repaint();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    public class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private Address oldPos = new Address(-1, -1);
        private Address newPos = new Address(-1, -1);

        public void mousePressed(MouseEvent e) {
            this.newPos.set(PanelEventHandlerBase.this.toR(e.getY()), PanelEventHandlerBase.this.toC(e.getX()));
            if (!PanelEventHandlerBase.this.isOn(this.newPos)) {
                return;
            }
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    PanelEventHandlerBase.this.leftPressedShift(this.newPos);
                } else {
                    PanelEventHandlerBase.this.leftPressed(this.newPos);
                }
            } else if ((modifier & 4) != 0) {
                PanelEventHandlerBase.this.rightPressed(this.newPos);
            }
            PanelEventHandlerBase.this.moveCursor(this.newPos);
            this.oldPos.set(this.newPos);
            PanelEventHandlerBase.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            this.newPos.set(PanelEventHandlerBase.this.toR(e.getY()), PanelEventHandlerBase.this.toC(e.getX()));
            if (!PanelEventHandlerBase.this.isOn(this.newPos)) {
                this.oldPos.setNowhere();
                return;
            }
            if (this.newPos.equals(this.oldPos)) {
                return;
            }
            if ((e.getModifiers() & 0x10) != 0) {
                PanelEventHandlerBase.this.leftDragged(this.oldPos, this.newPos);
            } else if ((e.getModifiers() & 4) != 0) {
                PanelEventHandlerBase.this.rightDragged(this.oldPos, this.newPos);
            }
            PanelEventHandlerBase.this.moveCursor(this.newPos);
            this.oldPos.set(this.newPos);
            PanelEventHandlerBase.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (!PanelEventHandlerBase.this.isOn(this.oldPos)) {
                PanelEventHandlerBase.this.dragFailed();
                PanelEventHandlerBase.this.repaint();
                return;
            }
            if ((e.getModifiers() & 0x10) != 0) {
                PanelEventHandlerBase.this.leftDragFixed(this.oldPos);
            } else if ((e.getModifiers() & 4) != 0) {
                PanelEventHandlerBase.this.rightDragFixed(this.oldPos);
            }
            PanelEventHandlerBase.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!PanelEventHandlerBase.this.isOn(this.newPos)) {
                return;
            }
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    PanelEventHandlerBase.this.leftClickedShift(this.newPos);
                } else {
                    PanelEventHandlerBase.this.leftClicked(this.newPos);
                }
            } else if ((modifier & 4) != 0) {
                PanelEventHandlerBase.this.rightClicked(this.newPos);
            }
            PanelEventHandlerBase.this.repaint();
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    public class MouseHandlerEdge
    implements MouseListener {
        private SideAddress position = new SideAddress();

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (((y - PanelEventHandlerBase.this.getOffsety() - (x - PanelEventHandlerBase.this.getOffsetx()) + PanelEventHandlerBase.this.board.cols() * PanelEventHandlerBase.this.getCellSize() * 2) / PanelEventHandlerBase.this.getCellSize() + (y - PanelEventHandlerBase.this.getOffsety() + (x - PanelEventHandlerBase.this.getOffsetx())) / PanelEventHandlerBase.this.getCellSize()) % 2 == 0) {
                this.position.set(0, PanelEventHandlerBase.this.toR(y), PanelEventHandlerBase.this.toC(x - PanelEventHandlerBase.this.getHalfCellSize()));
            } else {
                this.position.set(1, PanelEventHandlerBase.this.toR(y - PanelEventHandlerBase.this.getHalfCellSize()), PanelEventHandlerBase.this.toC(x));
            }
            if (!PanelEventHandlerBase.this.isSideOn(this.position)) {
                return;
            }
            int modifier = e.getModifiers();
            if ((modifier & 0x10) != 0) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    PanelEventHandlerBase.this.leftClickedShiftEdge(this.position);
                } else {
                    PanelEventHandlerBase.this.leftClickedEdge(this.position);
                }
            } else if ((modifier & 4) != 0) {
                PanelEventHandlerBase.this.rightClickedEdge(this.position);
            }
            PanelEventHandlerBase.this.repaint();
        }
    }
}

