/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import java.util.Iterator;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;

public class Rotator {
    private int rotation = 0;
    private int rows;
    private int cols;

    public static boolean isTransposed(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public Rotator() {
    }

    public Rotator(int rows, int cols, int rotation) {
        this.rows = rows;
        this.cols = cols;
        this.rotation = rotation;
    }

    public void setup(int rows, int cols, int rotation) {
        this.rows = rows;
        this.cols = cols;
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isTransposed() {
        return Rotator.isTransposed(this.rotation);
    }

    public Address rotateAddress(Address pos) {
        Address dst = new Address();
        switch (this.rotation) {
            case 0: {
                dst.set(pos.r(), pos.c());
                break;
            }
            case 1: {
                dst.set(this.cols - 1 - pos.c(), pos.r());
                break;
            }
            case 2: {
                dst.set(this.rows - 1 - pos.r(), this.cols - 1 - pos.c());
                break;
            }
            case 3: {
                dst.set(pos.c(), this.rows - 1 - pos.r());
                break;
            }
            case 4: {
                dst.set(pos.c(), pos.r());
                break;
            }
            case 5: {
                dst.set(pos.r(), this.cols - 1 - pos.c());
                break;
            }
            case 6: {
                dst.set(this.cols - 1 - pos.c(), this.rows - 1 - pos.r());
                break;
            }
            case 7: {
                dst.set(this.rows - 1 - pos.r(), pos.c());
            }
        }
        return dst;
    }

    public int rotateDirection(int direction) {
        switch (this.rotation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                direction = (direction + this.rotation) % 4;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                direction = (direction + this.rotation) % 4;
                direction ^= 1;
            }
        }
        return direction;
    }

    public Area rotateArea(Area src, Area dst) {
        Iterator itr = src.iterator();
        while (itr.hasNext()) {
            dst.add(this.rotateAddress((Address)itr.next()));
        }
        return dst;
    }

    public void rotateArrayInt2(int[][] src, int[][] dst) {
        Address address = new Address();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                address.set(r, c);
                address = this.rotateAddress(address);
                dst[address.r()][address.c()] = src[r][c];
                ++c;
            }
            ++r;
        }
    }

    public void rotateArrayInt3(int[][][] src, int[][][] dst) {
        switch (this.rotation) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                Rotator rotator2 = new Rotator(this.rows, this.cols - 1, this.rotation);
                rotator2.rotateArrayInt2(src[0], dst[0]);
                rotator2 = new Rotator(this.rows - 1, this.cols, this.rotation);
                rotator2.rotateArrayInt2(src[1], dst[1]);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                Rotator rotator2 = new Rotator(this.rows, this.cols - 1, this.rotation);
                rotator2.rotateArrayInt2(src[0], dst[1]);
                rotator2 = new Rotator(this.rows - 1, this.cols, this.rotation);
                rotator2.rotateArrayInt2(src[1], dst[0]);
            }
        }
    }
}

