/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

public class Address
implements Comparable {
    public static final Address NOWEHER = new Address(-1, -1);
    private int r;
    private int c;

    public Address() {
        this(0, 0);
    }

    public Address(Address pos) {
        this.r = pos.r;
        this.c = pos.c;
    }

    public Address(int r, int c) {
        this.r = r;
        this.c = c;
    }

    public int r() {
        return this.r;
    }

    public int c() {
        return this.c;
    }

    public void set(Address pos) {
        this.r = pos.r;
        this.c = pos.c;
    }

    public void set(int r, int c) {
        this.r = r;
        this.c = c;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return address.r == this.r && address.c == this.c;
    }

    public boolean equals(int rr, int cc) {
        return rr == this.r && cc == this.c;
    }

    public int hashCode() {
        return this.r * 1000 + this.c;
    }

    public boolean isNowhere() {
        return this.r == -1 && this.c == -1;
    }

    public void setNowhere() {
        this.r = -1;
        this.c = -1;
    }

    public void move(int direction) {
        switch (direction) {
            case 0: {
                --this.r;
                break;
            }
            case 1: {
                --this.c;
                break;
            }
            case 2: {
                ++this.r;
                break;
            }
            case 3: {
                ++this.c;
                break;
            }
        }
    }

    public int compareTo(Object o) {
        Address other = (Address)o;
        if (this.r < other.r) {
            return -1;
        }
        if (this.r > other.r) {
            return 1;
        }
        if (this.c < other.c) {
            return -1;
        }
        if (this.c > other.c) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.r + ',' + this.c + ']';
    }
}

