/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import java.awt.Color;
import java.awt.Graphics;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.numberlink.Board;
import pencilbox.numberlink.Link;
import pencilbox.util.Colors;

public class Panel
extends PanelEventHandler {
    private Board board;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color lightColor = Color.GREEN;
    private boolean warnBranchedLink = false;
    private boolean colorForEachLink = false;
    private boolean highlightSelectedLink = true;
    private Link selectedLink = null;
    private int selectedNumber = 0;
    private Color numberlessLinkColor = Color.CYAN;
    private Color selectedLinkColor = Color.GREEN;
    private Color branchedLinkColor = Color.RED;
    private Color errorColor = Color.RED;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setColorForEachLink(boolean colorForEachLink) {
        this.colorForEachLink = colorForEachLink;
    }

    public void setHighlightSelectedLink(boolean highlightSelectedLink) {
        this.highlightSelectedLink = highlightSelectedLink;
    }

    public void setWarnBranchedLink(boolean warnBranchedLink) {
        this.warnBranchedLink = warnBranchedLink;
    }

    public void drawPanel(Graphics g) {
        this.paintBackground(g);
        this.drawIndex(g);
        this.drawBoard(g);
        this.drawGrid(g);
        this.drawBorder(g);
        if (this.getCellCursor() != null) {
            this.drawCursor(g);
        }
    }

    void drawBoard(Graphics g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        g.setColor(this.lineColor);
                        this.placeTraversalLine(g, d, r, c);
                    } else if (state == -1) {
                        g.setColor(this.crossColor);
                        this.placeSideCross(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0) {
                    g.setColor(this.getBackgroundColor());
                    this.placeFilledCircle(g, r, c);
                    g.setColor(this.lightColor);
                    g.setColor(this.getNumberColor());
                    this.placeNumber(g, r, c, number);
                } else if (number == -1) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    public void placeTraversalLine(Graphics g, int d, int r, int c) {
        Link link = this.board.getLink(d, r, c);
        int linkNo = link.getNumber();
        if (this.warnBranchedLink && this.board.isBranchedLink(d, r, c)) {
            g.setColor(this.errorColor);
        } else if (this.highlightSelectedLink && (linkNo > 0 && linkNo == this.selectedNumber || link == this.selectedLink)) {
            g.setColor(this.selectedLinkColor);
        } else if (this.colorForEachLink) {
            if (linkNo == 0) {
                g.setColor(this.numberlessLinkColor);
            } else if (linkNo == -1) {
                g.setColor(this.branchedLinkColor);
            } else {
                g.setColor(Colors.getDarkColor(linkNo));
            }
        }
        super.placeTraversalLine(g, d, r, c);
    }

    public void placeNumber(Graphics g, int r, int c, int n) {
        if (this.highlightSelectedLink && n == this.selectedNumber) {
            g.setColor(this.selectedLinkColor);
            super.paintCell(g, r, c);
            g.setColor(this.getNumberColor());
        } else if (this.warnBranchedLink && (this.board.getLink(r, c) != null && this.board.getLink(r, c).getNumber() == -1 || this.board.countLine(r, c) > 1)) {
            g.setColor(this.errorColor);
        } else if (this.colorForEachLink) {
            g.setColor(Colors.getDarkColor(this.board.getNumber(r, c)));
        } else {
            g.setColor(this.getNumberColor());
        }
        super.placeNumber(g, r, c, n);
    }

    public void drawGrid(Graphics g) {
        g.setColor(this.getGridColor());
        switch (this.getDisplayStyle()) {
            case 0: {
                super.drawGrid(g);
                break;
            }
            case 1: {
                int r = 0;
                while (r < this.rows()) {
                    g.drawLine(this.toX(0) + this.getCellSize() / 2, this.toY(r) + this.getCellSize() / 2, this.toX(this.cols()) - this.getCellSize() / 2, this.toY(r) + this.getCellSize() / 2);
                    ++r;
                }
                int c = 0;
                while (c < this.cols()) {
                    g.drawLine(this.toX(c) + this.getCellSize() / 2, this.toY(0) + this.getCellSize() / 2, this.toX(c) + this.getCellSize() / 2, this.toY(this.rows()) - this.getCellSize() / 2);
                    ++c;
                }
                break;
            }
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r, pos.c, -1);
        }
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r == dragEnd.r || dragStart.c == dragEnd.c) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r == dragEnd.r || dragStart.c == dragEnd.c) {
            this.board.determineInlineState(dragStart, dragEnd, 0);
        }
    }

    protected void leftClicked(Address pos) {
        Link link = this.board.getLink(pos.r, pos.c);
        int newNumber = 0;
        if (this.board.isNumber(pos.r, pos.c)) {
            newNumber = this.board.getNumber(pos.r, pos.c);
        } else if (link != null) {
            newNumber = link.getNumber();
        }
        if (newNumber == this.selectedNumber && this.selectedLink == link) {
            this.selectedLink = null;
            this.selectedNumber = 0;
        } else {
            this.selectedLink = link;
            this.selectedNumber = newNumber;
        }
    }
}

