/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.DigitPatternHint;

public class Board
extends BoardBase {
    static final int UNSTABLE = 0;
    static final int STABLE = 1;
    static final int UNKNOWN = 0;
    private List areaList;
    private int maxNumber = 9;
    private int[][] state;
    private int[][] number;
    private Area[][] area;
    private int[][] multi;
    private int[][] multi2;
    private DigitPatternHint hint;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList();
        this.multi = new int[this.rows()][this.cols()];
        this.multi2 = new int[this.rows()][this.cols()];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isStable(r, c)) {
                    this.number[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public boolean isStable(int r, int c) {
        return this.state[r][c] == 1;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public boolean isUnknown(int r, int c) {
        return this.number[r][c] == 0;
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public boolean isError(int r, int c) {
        return this.isTooClose(r, c) || this.isMultipleNumber(r, c) || this.isTooLarge(r, c);
    }

    public boolean isTooClose(int r, int c) {
        return this.multi[r][c] > 1;
    }

    public boolean isMultipleNumber(int r, int c) {
        return this.multi2[r][c] > 1;
    }

    public boolean isTooLarge(int r, int c) {
        return this.getArea(r, c) != null && this.getNumber(r, c) > this.getArea(r, c).size();
    }

    int getPattern(int r, int c) {
        return this.hint.getPattern(r, c);
    }

    boolean canPlace(int r, int c, int n) {
        return this.hint.canPlace(r, c, n);
    }

    public void changeNumber(int r, int c, int n) {
        if (this.getNumber(r, c) == n) {
            return;
        }
        int prevNum = this.getNumber(r, c);
        this.updateMulti(r, c, n);
        if (this.getArea(r, c) != null) {
            this.updateMulti2(r, c, n);
        }
        this.setNumber(r, c, n);
        if (prevNum == 0 && n > 0) {
            this.hint.checkUsedNumber(r, c, n);
        } else {
            this.hint.initHint();
        }
    }

    public void enterNumberA(int r, int c, int n) {
        if (n < 0) {
            return;
        }
        if (n == this.number[r][c]) {
            return;
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.number[r][c], n)));
        this.changeNumber(r, c, n);
    }

    public void increaseNumber(int r, int c) {
        if (this.number[r][c] == this.maxNumber) {
            return;
        }
        this.enterNumberA(r, c, this.number[r][c] + 1);
    }

    public void decreaseNumber(int r, int c) {
        if (this.number[r][c] <= 0) {
            return;
        }
        this.enterNumberA(r, c, this.number[r][c] - 1);
    }

    public void addArea(Area newArea) {
        Iterator itr = newArea.iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            this.area[pos.r][pos.c] = newArea;
        }
        this.areaList.add(newArea);
    }

    public void removeArea(Area oldArea) {
        Iterator itr = oldArea.iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            if (this.area[pos.r][pos.c] != oldArea) continue;
            this.area[pos.r][pos.c] = null;
        }
        this.areaList.remove(oldArea);
    }

    List getAreaList() {
        return this.areaList;
    }

    int getMaxNumber() {
        return this.maxNumber;
    }

    int[][] getNumber() {
        return this.number;
    }

    public void initBoard() {
        super.initBoard();
        this.initMulti();
        this.initMulti2();
        this.hint.initHint();
    }

    void initMulti() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0) {
                    this.initMulti1(r, c, this.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void initMulti1(int r0, int c0, int num) {
        this.multi[r0][c0] = 1;
        int c = c0 - num;
        while (c <= c0 + num) {
            if (c != c0 && this.isOn(r0, c) && this.getNumber(r0, c) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++c;
        }
        int r = r0 - num;
        while (r <= r0 + num) {
            if (r != r0 && this.isOn(r, c0) && this.getNumber(r, c0) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++r;
        }
    }

    void updateMulti(int r0, int c0, int num) {
        int r;
        int c;
        int prevNum = this.getNumber(r0, c0);
        if (this.multi[r0][c0] > 1) {
            c = c0 - prevNum;
            while (c <= c0 + prevNum) {
                if (c != c0 && this.isOn(r0, c) && this.getNumber(r0, c) == prevNum) {
                    int[] nArray = this.multi[r0];
                    int n = c;
                    nArray[n] = nArray[n] - 1;
                }
                ++c;
            }
            r = r0 - prevNum;
            while (r <= r0 + prevNum) {
                if (r != r0 && this.isOn(r, c0) && this.getNumber(r, c0) == prevNum) {
                    int[] nArray = this.multi[r];
                    int n = c0;
                    nArray[n] = nArray[n] - 1;
                }
                ++r;
            }
        }
        if (num == 0) {
            this.multi[r0][c0] = 0;
        } else if (num > 0) {
            this.multi[r0][c0] = 1;
            c = c0 - num;
            while (c <= c0 + num) {
                if (c != c0 && this.isOn(r0, c) && this.getNumber(r0, c) == num) {
                    int[] nArray = this.multi[r0];
                    int n = c;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = this.multi[r0];
                    int n2 = c0;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                ++c;
            }
            r = r0 - num;
            while (r <= r0 + num) {
                if (r != r0 && this.isOn(r, c0) && this.getNumber(r, c0) == num) {
                    int[] nArray = this.multi[r];
                    int n = c0;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray3 = this.multi[r0];
                    int n3 = c0;
                    nArray3[n3] = nArray3[n3] + 1;
                }
                ++r;
            }
        }
    }

    void initMulti2() {
        int r = this.rows() - 1;
        while (r >= 0) {
            int c = this.cols() - 1;
            while (c >= 0) {
                if (this.getNumber(r, c) > 0 && this.getArea(r, c) != null) {
                    this.initMulti21(r, c, this.getNumber(r, c));
                }
                --c;
            }
            --r;
        }
    }

    private void initMulti21(int r0, int c0, int num) {
        this.multi2[r0][c0] = 1;
        Iterator itr = this.getArea(r0, c0).iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            if (pos.equals(r0, c0) || this.getNumber(pos.r, pos.c) != num) continue;
            int[] nArray = this.multi2[r0];
            int n = c0;
            nArray[n] = nArray[n] + 1;
        }
    }

    void updateMulti2(int r0, int c0, int num) {
        Address pos;
        Iterator itr;
        int prevNum = this.getNumber(r0, c0);
        if (this.multi2[r0][c0] > 1) {
            itr = this.getArea(r0, c0).iterator();
            while (itr.hasNext()) {
                pos = (Address)itr.next();
                if (pos.equals(r0, c0) || this.getNumber(pos.r, pos.c) != prevNum) continue;
                int[] nArray = this.multi2[pos.r];
                int n = pos.c;
                nArray[n] = nArray[n] - 1;
            }
        }
        if (num == 0) {
            this.multi2[r0][c0] = 0;
        } else if (num > 0) {
            this.multi2[r0][c0] = 1;
            itr = this.getArea(r0, c0).iterator();
            while (itr.hasNext()) {
                pos = (Address)itr.next();
                if (pos.equals(r0, c0) || this.getNumber(pos.r, pos.c) != num) continue;
                int[] nArray = this.multi2[pos.r];
                int n = pos.c;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.multi2[r0];
                int n2 = c0;
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0 && this.isMultipleNumber(r, c)) {
                    result |= 2;
                }
                if (this.isTooLarge(r, c)) {
                    result |= 4;
                }
                if (this.isTooClose(r, c)) {
                    result |= 8;
                }
                if (this.isUnknown(r, c)) {
                    result |= 1;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u5b8c\u6210\u3067\u3059";
        }
        if (result == 1) {
            return "\u672a\u5b8c\u6210\n";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append("\u540c\u3058\u6570\u5b57\u3092\u8907\u6570\u542b\u3080\u9818\u57df\u304c\u3042\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u9818\u57df\u9762\u7a4d\u3088\u308a\u5927\u304d\u3044\u6570\u5b57\u3092\u542b\u3080\u9818\u57df\u304c\u3042\u308b\n");
        }
        if ((result & 8) == 8) {
            message.append("\u9593\u9694\u4e0d\u8db3\u306e\u6570\u5b57\u304c\u3042\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.after);
        }

        public boolean addEdit(UndoableEdit anEdit) {
            Step edit = (Step)anEdit;
            if (edit.row == this.row && edit.col == this.col) {
                this.after = edit.after;
                return true;
            }
            return false;
        }
    }
}

