/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pencilbox.common.core.Size;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.PencilBoxDialog;

public class NewBoardDialog
extends PencilBoxDialog {
    private static NewBoardDialog instance = new NewBoardDialog();
    private JPanel freeSizePanel;
    private JTextField fieldRows;
    private JTextField fieldCols;
    private boolean freeSize = true;
    private Size newSize;

    public static NewBoardDialog getInstance() {
        return instance;
    }

    private NewBoardDialog() {
    }

    protected void makeDialog() {
        super.makeDialog();
        this.makeFreeSizePanel();
    }

    private void makeFreeSizePanel() {
        this.freeSizePanel = new JPanel();
        this.freeSizePanel.setLayout(new FlowLayout());
        this.fieldCols = new JTextField(3);
        this.fieldRows = new JTextField(3);
        this.freeSizePanel.add(new JLabel("\u30e8\u30b3"));
        this.freeSizePanel.add(this.fieldCols);
        this.freeSizePanel.add(new JLabel("\u30bf\u30c6"));
        this.freeSizePanel.add(this.fieldRows);
        this.add((Component)this.freeSizePanel, "Center");
    }

    public void setPencilType(PencilType pencilType) throws PencilBoxClassException {
    }

    public void setCurrentSize(Size s) {
        this.newSize = null;
        if (this.freeSize) {
            this.fieldCols.setText(Integer.toString(s.getCols()));
            this.fieldCols.selectAll();
            this.fieldRows.setText(Integer.toString(s.getRows()));
            this.fieldRows.selectAll();
        }
    }

    protected void setInitialFocus() {
        this.fieldCols.requestFocusInWindow();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void accept() {
        try {
            try {
                int rows = Integer.parseInt(this.fieldRows.getText());
                int cols = Integer.parseInt(this.fieldCols.getText());
                this.newSize = new Size(rows, cols);
            }
            catch (NumberFormatException e) {
                this.showErrorMessage(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            super.accept();
            throw throwable;
        }
        {
            Object var3_6 = null;
            super.accept();
            return;
        }
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public Size getNewSize() {
        return this.newSize;
    }
}

