/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.undo.UndoManager;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.DataExportDialog;
import pencilbox.common.gui.FileChooser;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.NewBoardDialog;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.common.gui.PanelImageTransfer;
import pencilbox.common.gui.PanelImageWriter;
import pencilbox.common.gui.PropertyDialog;
import pencilbox.common.io.IOController;
import pencilbox.util.Colors;

public class MenuCommand {
    private PencilType pencilType;
    private Frame frame;
    private PanelEventHandler panel;
    private Problem problem;
    private BoardBase board;
    private UndoManager undoManager;
    private JFileChooser fileChooser;
    private Timer playBackTimer;

    public void setup(PencilType puzzleType, Frame frame, PanelEventHandler panel, Problem problem) {
        this.pencilType = puzzleType;
        this.frame = frame;
        this.panel = panel;
        this.problem = problem;
        this.board = problem.getBoard();
        this.setFrameTitle();
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1000);
        this.board.setUndoManager(this.undoManager);
        this.board.initBoard();
    }

    public void setup(PencilType puzzleType, Problem problem) {
        this.pencilType = puzzleType;
        this.problem = problem;
        this.board = problem.getBoard();
        this.setFrameTitle();
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1000);
        this.board.setUndoManager(this.undoManager);
        this.board.initBoard();
    }

    public PanelEventHandler getPanelBase() {
        return this.panel;
    }

    public Frame getFrame() {
        return this.frame;
    }

    private void setFrameTitle() {
        this.frame.setTitle(String.valueOf(this.problem.getFileName()) + " - " + "PencilBox");
    }

    public void showErrorMessage(Exception e) {
        JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
    }

    public void showErrorMessage(String s) {
        JOptionPane.showMessageDialog(this.frame, s, "Error", 0);
    }

    public void newBoard() {
        try {
            Size newSize;
            NewBoardDialog newBoardDialog = NewBoardDialog.getInstance();
            newBoardDialog.setPencilType(this.pencilType);
            newBoardDialog.setCurrentSize(this.board.getSize());
            if (newBoardDialog.showDialog(this.frame, "\u65b0\u898f\u76e4\u9762") == 0 && (newSize = newBoardDialog.getNewSize()) != null && this.isValidSize(newSize)) {
                PencilFactory.getInstance(this.pencilType).createNewFrame(newSize);
                if (this.problem.getFile() == null) {
                    this.frame.dispose();
                }
            }
        }
        catch (PencilBoxClassException e) {
            this.showErrorMessage(e);
        }
    }

    private boolean isValidSize(Size s) {
        int rows = s.getRows();
        int cols = s.getCols();
        if (rows < 0 || cols < 0) {
            this.showErrorMessage("\u30b5\u30a4\u30ba\u304c\u4e0d\u6b63");
            return false;
        }
        if (rows > 200 || cols > 200) {
            this.showErrorMessage("\u3055\u3059\u304c\u306b\u5927\u304d\u3059\u304e\u3067\u3057\u3087");
            return false;
        }
        if (this.pencilType.getPencilName().equals("sudoku")) {
            if (rows == cols) {
                int n = 1;
                while (n < 9) {
                    if (rows == n * n) {
                        return true;
                    }
                    ++n;
                }
            } else {
                this.showErrorMessage("\u4e0d\u6b63\u306a\u30b5\u30a4\u30ba");
                return false;
            }
        }
        return true;
    }

    private void prepareFileChooser() {
        File currentFile;
        if (this.fileChooser == null) {
            this.fileChooser = FileChooser.getInstance();
        }
        if ((currentFile = this.problem.getFile()) != null) {
            this.fileChooser.setSelectedFile(currentFile);
        }
    }

    public void open() {
        if (this.problem.getFile() == null) {
            this.open1(1);
        } else {
            this.open1(0);
        }
    }

    public void closeAndOpen() {
        this.prepareFileChooser();
        try {
            if (this.fileChooser.showOpenDialog(this.frame) == 0) {
                File file = this.fileChooser.getSelectedFile();
                PencilFactory.getInstance(this.pencilType).createNewBoard(this, file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
    }

    private void open1(int mode) {
        this.prepareFileChooser();
        try {
            if (this.fileChooser.showOpenDialog(this.frame) == 0) {
                File file = this.fileChooser.getSelectedFile();
                PencilFactory.getInstance(this.pencilType).createNewFrame(file);
                if (mode == 1) {
                    this.frame.dispose();
                }
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
    }

    public void save() {
        this.prepareFileChooser();
        try {
            if (this.fileChooser.showSaveDialog(this.frame) == 0) {
                File file = this.fileChooser.getSelectedFile();
                IOController.getInstance(this.pencilType).saveFile(this.problem, file);
            }
        }
        catch (PencilBoxException e) {
            this.showErrorMessage(e);
        }
        this.setFrameTitle();
    }

    public void print() {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(this.panel);
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (PrinterException e) {
            this.showErrorMessage(e);
        }
    }

    void exporProblemDatatString() {
        DataExportDialog dataExportFrame = new DataExportDialog();
        try {
            String problemDataS = IOController.getInstance(this.pencilType).getProblemDataString(this.board);
            dataExportFrame.setText("problem=" + problemDataS);
            dataExportFrame.showDialog(this.frame, "\u554f\u984c\u30c7\u30fc\u30bf\u6587\u5b57\u5217\u51fa\u529b");
        }
        catch (PencilBoxClassException e) {
            e.printStackTrace();
        }
    }

    public void saveImage() {
        new PanelImageWriter().run(this.panel);
    }

    public void copyImage() {
        new PanelImageTransfer().run(this.panel);
    }

    public void property() {
        PropertyDialog propertyDialog = PropertyDialog.getInstance();
        propertyDialog.setPropertyToDialog(this.problem.getProperty());
        if (propertyDialog.showDialog(this.frame, "\u30d7\u30ed\u30d1\u30c6\u30a3") == 0) {
            propertyDialog.getPropertyFromDialog(this.problem.getProperty());
        }
    }

    public void close() {
        this.frame.dispose();
    }

    public void quit() {
        System.exit(0);
    }

    public void about() {
        JOptionPane.showMessageDialog(this.frame, this.getAboutText(), "PencilBox\u306b\u3064\u3044\u3066", 1);
    }

    private String getAboutText() {
        return "PencilBox version 1.0.2\nCopyright (c) 2003-2006 Nayuta\nhttp://pencilbox.sourceforge.jp/\n";
    }

    public void clear() {
        this.undoManager.discardAllEdits();
        this.board.clearBoard();
        this.panel.repaint();
    }

    public void checkAnswer() {
        JOptionPane.showMessageDialog(this.frame, this.board.checkAnswerString(), "\u6b63\u7b54\u5224\u5b9a", 1);
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void undoAll() {
        while (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redoAll() {
        while (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void playback() {
        this.undoAll();
        if (this.playBackTimer == null) {
            this.makePlayBackTimer();
        }
        this.playBackTimer.start();
    }

    private void makePlayBackTimer() {
        this.playBackTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (MenuCommand.this.undoManager.canRedo()) {
                    MenuCommand.this.undoManager.redo();
                    MenuCommand.this.panel.repaint();
                } else {
                    MenuCommand.this.playBackTimer.stop();
                }
            }
        });
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void setProblemEditMode(boolean b) {
        if (this.panel.isProblemEditMode() == b) {
            return;
        }
        if (!b) {
            this.board.initBoard();
        }
        this.panel.setProblemEditMode(b);
        this.panel.repaint();
    }

    public void setCursorOn(boolean b) {
        this.panel.setCursorOn(b);
        this.panel.repaint();
    }

    public void setShowIndexMode(boolean b) {
        this.panel.changeShowIndexMode(b);
        this.frame.pack();
    }

    public void renewColor() {
        Colors.randomize();
        this.panel.repaint();
    }
}

