/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import pencilbox.common.core.Size;

public final class PencilType {
    private static final PencilType[] pencilTypeList = new PencilType[]{new PencilType("kakuro", "\u30ab\u30c3\u30af\u30ed", 12), new PencilType("kurodoko", "\u9ed2\u30de\u30b9\u306f\u3069\u3053\u3060", 9), new PencilType("shikaku", "\u56db\u89d2\u306b\u5207\u308c", 10), new PencilType("sudoku", "\u6570\u72ec", 9), new PencilType("slitherlink", "\u30b9\u30ea\u30b6\u30fc\u30ea\u30f3\u30af", 11), new PencilType("tentaisho", "\u5929\u4f53\u30b7\u30e7\u30fc", 10), new PencilType("numberlink", "\u30ca\u30f3\u30d0\u30fc\u30ea\u30f3\u30af", 10), new PencilType("nurikabe", "\u306c\u308a\u304b\u3079", 10), new PencilType("hakyukoka", "\u6ce2\u53ca\u52b9\u679c", 10), new PencilType("hashi", "\u6a4b\u3092\u304b\u3051\u308d", 9), new PencilType("bijutsukan", "\u7f8e\u8853\u9928", 10), new PencilType("hitori", "\u3072\u3068\u308a\u306b\u3057\u3066\u304f\u308c", 8), new PencilType("fillomino", "\u30d5\u30a3\u30eb\u30aa\u30df\u30ce", 10), new PencilType("heyawake", "\u3078\u3084\u308f\u3051", 10), new PencilType("masyu", "\u307e\u3057\u3085", 10), new PencilType("yajilin", "\u30e4\u30b8\u30ea\u30f3", 10)};
    private String pencilName;
    private String title;
    private int defaultSize;

    public static int getNPencilType() {
        return pencilTypeList.length;
    }

    public static PencilType getPencilType(int i) {
        if (i >= 0 && i < pencilTypeList.length) {
            return pencilTypeList[i];
        }
        return null;
    }

    public static PencilType getPencilType(String name) {
        int i = 0;
        while (i < pencilTypeList.length) {
            if (pencilTypeList[i].getPencilName().equals(name)) {
                return pencilTypeList[i];
            }
            ++i;
        }
        return null;
    }

    private PencilType() {
    }

    private PencilType(String pencilName, String title, int defaultSize) {
        this.pencilName = pencilName;
        this.title = title;
        this.defaultSize = defaultSize;
    }

    public String getPencilName() {
        return this.pencilName;
    }

    public String getTitle() {
        return this.title;
    }

    public Size getDefaultSize() {
        return new Size(this.defaultSize, this.defaultSize);
    }
}

