/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.FileChooser;

public class PencilBoxLauncher {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new PencilBoxLauncher();
        FileChooser.getInstance();
    }

    public PencilBoxLauncher() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setTitle("PencilBox");
        JPanel panel = new JPanel();
        int n = PencilType.getNPencilType();
        panel.setLayout(new GridLayout(n + 1, 1));
        int i = 0;
        while (i < n) {
            panel.add(this.makeButton(PencilType.getPencilType(i)));
            ++i;
        }
        panel.add(this.makeExitButton());
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private JButton makeButton(final PencilType pencilType) {
        JButton button = new JButton(pencilType.getTitle());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    PencilFactory.getInstance(pencilType).createNewFrame();
                }
                catch (PencilBoxClassException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                }
            }
        });
        return button;
    }

    private JButton makeExitButton() {
        JButton button = new JButton("\u7d42\u4e86");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        return button;
    }
}

