package pencilbox.common.gui;

import java.awt.event.*;

import pencilbox.common.core.*;

/**
 * plɑ΂}EXCL[{[h̃CxgsNX
 */
public class PanelEventHandler extends PanelBase {

	private KeyHandler keyHandler = new KeyHandler();
	protected MouseHandlerCursor mouseHandlerCursor = new MouseHandlerCursor();
	private MouseHandler mouseHandler = new MouseHandler();
	private MouseHandlerEdge mouseHandlerEdge = new MouseHandlerEdge();

	private int maxInputNumber = 99;
	private int previousInput = 0;
	
	/**
	 * Panel𐶐
	 */
	public PanelEventHandler() {
		addKeyListener(keyHandler);
		addMouseListener(mouseHandler);
		addMouseMotionListener(mouseHandler);
		addMouseListener(mouseHandlerEdge);
		addMouseListener(mouseHandlerCursor);
		setCellCursor(createCursor());
	}
	/**
	 * mouseHandlerCorsor  mouseListenerXg珜
	 * SL, TS ł́@ƍWnقȂ邽߁CmouseHandlerCursor OĂ
	 */
	protected void removeMouseHandlerCursor() {
		removeMouseListener(mouseHandlerCursor);
	}
	/**
	 *  J[\𐶐
	 * @return J[\
	 */
	public CellCursor createCursor() {
		return new CellCursor(this);
	}

	public void setup(BoardBase board) {
		super.setup(board);
		getCellCursor().setPosition(0,0);
	}
	/**
	 * Ֆʕ\̉]ݒ肷
	 * @param rotation ݒ肷]
	 */
	protected void setRotation(int rotation) {
		getCellCursor().setPosition(0,0);
		super.setRotation(rotation);
	}
	/**
	 * ͉\ȍő吔ݒ肷
	 * @param number ݒ肷鐔l
	 */
	protected void setMaxInputNumber(int number) {
		maxInputNumber = number;
	}
	/**
	 * ͐̈ꎞLNA
	 */
	public void resetPreviousInput() {
		previousInput = 0;
	}
	/**
	 * PanelxsNZWPanel̗}XWɕϊ
	 * @param x Panel̃sNZWx
	 * @return xPanelWɕϊl
	 */
	public final int toC(int x) {
		return (x + getCellSize() - getOffsetx()) / getCellSize() - 1;
	}
	/**
	 * Panel̂sNZWPanel̍s}XWɕϊ
	 * @param y Panel̃sNZWy
	 * @return yPanelWɕϊl
	 */
	public final int toR(int y) {
		return (y + getCellSize() - getOffsety()) / getCellSize() - 1;
	}

	/**
	 * L[Xi[
	 */
	public class KeyHandler implements KeyListener {

		private Address position = new Address();

		/**
		 * L[{[h͏
		 * 0-9 ̐L[^CvꂽƂɂ͓͐󂯂ƂC
		 * 󋵂ɉāC2̐ɂ numberEntered \bhɓn
		 */
		public void keyPressed(KeyEvent e) {
			int keyChar = e.getKeyChar();
			if (keyChar == '/')
				slashEntered();
			if (isProblemEditMode() || isCursorOn()) {
				moveCursor(e);
				position.set(getCellCursor().getBoardPosition());
				if (keyChar == ' ') {
					spaceEntered(position);
				} else 	if (keyChar == '.') {
					spaceEntered(position);
				} else 	if (keyChar == '-') {
					minusEntered(position);
				} else if (
					keyChar >= '0' && keyChar <= '9') { // 0 - 9 ̃L[͂ꂽƂ̂ݖɂĂ
					int number = keyChar - '0';
					if (previousInput >= 1 && previousInput <= 9) {
	//					&& position.equals(previousPosition)) {
						if (previousInput * 10 + number <= maxInputNumber) {
							number = previousInput * 10 + number;
						}
						if (number <= maxInputNumber) {
							numberEntered(position, number);
							previousInput = 0;
						}
					} else {
						if (number <= maxInputNumber) {
							numberEntered(position, number);
							previousInput = number;
						}
					}
				}
			}
			repaint();
		}
		private void moveCursor(KeyEvent e) {
			int keyCode = e.getKeyCode();
			switch (keyCode) {
				case KeyEvent.VK_LEFT :
						getCellCursor().moveLt();
					break;
				case KeyEvent.VK_UP :
						getCellCursor().moveUp();
					break;
				case KeyEvent.VK_RIGHT :
						getCellCursor().moveRt();
					break;
				case KeyEvent.VK_DOWN :
						getCellCursor().moveDn();
					break;
				default :
					break;
			}
		}

		public void keyTyped(KeyEvent e) {
		}
		public void keyReleased(KeyEvent e) {
		}
	}
	/**
	 * L[͂ƂɌĂ΂
	 * ̓pY̎ނƂɃTuNXŋLq
	 * @param pos ͂}X̍W
	 * @param num ͂
	 */
	protected void numberEntered(Address pos, int num) {
	}
	/**
	 * Xy[XL[͂ƂɌĂ΂
	 * ̓pY̎ނƂɃTuNXŋLq
	 * @param pos ͂}X̍W
	 */
	protected void spaceEntered(Address pos) {
	}
	/**
	 * '-'L[͂ƂɌĂ΂
	 * ̓pY̎ނƂɃTuNXŋLq
	 * @param pos ͂}X̍W
	 */
	protected void minusEntered(Address pos) {
	}
	/**
	 * '/'L[͂ƂɌĂ΂
	 * u̓[hvƁu𓚃[hv؂ւ
	 */
	protected void slashEntered() {
		setProblemEditMode(!isProblemEditMode());
	}

	/**
	 * }EXXi[̋ʃX[p[NX
	 * }EXƂC
	 * hbO܂ܐV}XɈړƂC
	 * hbOIƂC̓C
	 * TuNXŃI[o[Chėp
	 */
//	private Address moveNewPos = new Address();
//	private Address moveOldPos = new Address();
//	private Address movePos= new Address();
	public class MouseHandler
		implements MouseListener, MouseMotionListener {

		private Address oldPos = new Address(-1, -1);
		private Address newPos = new Address(-1, -1);

		public void mousePressed(MouseEvent e) {

			newPos.set(toR(e.getY()), toC(e.getX()));
			if (!isOn(newPos))
				return;
			p2b(newPos);
			//		System.out.println(oldPos.toString() + newPos.toString());
			int modifier = e.getModifiers();
			if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
				if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
					leftPressedShift(newPos);
				else
					leftPressed(newPos);
			} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
				rightPressed(newPos);
			}

			oldPos.set(newPos); // ݈ʒuXV
			repaint();
		}

		public void mouseDragged(MouseEvent e) {

			newPos.set(toR(e.getY()), toC(e.getX()));
			if (!isOn(newPos)) {
				oldPos.setNowhere();
				// ̕ȂƁCՊOoRhbOȂ ĂȂĂ
				return;
			}
			p2b(newPos);

			if (newPos.equals(oldPos))
				return; // }XɎ~܂Cxg͖
			//			if (!newPos.isNextTo(oldPos)) return; // אڃ}XȊÕCxg͖
			//			if (dragIneffective(oldPos, newPos)) return; // אڃ}XȊÕCxg͖

			if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
				leftDragged(oldPos, newPos);
			} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
				rightDragged(oldPos, newPos);
			}

			oldPos.set(newPos); // ݈ʒuXV
			repaint();
			//		repaint(newPos);
		}

		public void mouseReleased(MouseEvent e) {

			if (!isOn(oldPos)) {
				dragFailed();
				repaint();
				return;
			}
			if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
				leftDragFixed(oldPos);
			} else if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
				rightDragFixed(oldPos);
			}
			repaint();
		}
		public void mouseExited(MouseEvent e) {
		}
		public void mouseEntered(MouseEvent e) {
		}
		public void mouseClicked(MouseEvent e) {
			if (!isOn(newPos))
				return;
			int modifier = e.getModifiers();
			if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
				if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
					leftClickedShift(newPos);
				else
					leftClicked(newPos);
			} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
				rightClicked(newPos);
			}
			repaint();
		}

		public void mouseMoved(MouseEvent e) {
//			movePos.set(toR(e.getY()), toC(e.getX()));
//			if (!isOn(movePos))
//				return;
////			p2b(movePos);
//			mouseMovedTo(movePos);
//			repaint();
		}
	}
	/**
	 * {^ꂽƂC
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void leftPressed(Address position) {
	}
	protected void leftPressedShift(Address position) {
	}
	protected void leftClicked(Address position) {
	}
	protected void leftClickedShift(Address position) {
	}	
	/**
	 * hbO܂܂V}XɈړƂɌĂ΂D
	 * KvɉăTuNXőI[o[ChD
	 * I[o[ChȂ΁CleftPressed Ɠ
	 * @param position
	 */
	protected void leftDragged(Address position) {
//		leftPressed(position);
	}
	protected void leftDragged(Address oldPos, Address position) {
		leftDragged(position);
	}

	/**
	 * }EX{^𗣂čhbOm肵ƂɌĂ΂
	 * TuNXŃI[o[Ch
	 * @param dragEnd
	 */
	protected void leftDragFixed(Address dragEnd) {
	}
	/**
	 * E{^ꂽƂCEhbO܂܂V}XɈړƂɌĂ΂D
	 * TuNXőI[o[ChD
	 * @param position
	 */
	protected void rightPressed(Address position) {
	}
	protected void rightClicked(Address position) {
	}
	/**
	 * EhbO܂܂V}XɈړƂɌĂ΂D
	 * TuNXőI[o[ChD
	 * I[o[ChȂ΁CrightPressed Ɠ
	 * @param position
	 */
	protected void rightDragged(Address position) {
//		rightPressed(position);
	}
	protected void rightDragged(Address oldPos, Address position) {
		rightDragged(position);
	}
	/**
	 * E}EX{^𗣂ĉEhbOm肵ƂɌĂ΂
	 * TuNXŃI[o[Ch
	 * @param dragEnd
	 */
	protected void rightDragFixed(Address dragEnd) {
	}
	/**
	 * ՓŃhbOJnՊOŃhbOIƂɌĂ΂D
	 * KvɉTuNXŃhbǑn
	 */
	protected void dragFailed() {
	}

	protected void mouseMovedTo(Address pos){}

	/**
	 * ӂ̑spYp̃}EXXi[̋ʃX[p[NX
	 * ӂNbNƂ̓TuNXŃI[o[ChĎgp
	 */
	public class MouseHandlerEdge implements MouseListener {

		private SideAddress position = new SideAddress();

		public void mousePressed(MouseEvent e) {
		}
		public void mouseReleased(MouseEvent e) {
		}
		public void mouseExited(MouseEvent e) {
		}
		public void mouseEntered(MouseEvent e) {
		}
		public void mouseClicked(MouseEvent e) {

			int x = e.getX();
			int y = e.getY();

			if ((((y - getOffsety()) - (x - getOffsetx()) + cols() * getCellSize() * 2) / getCellSize()
				+ ((y - getOffsety()) + (x - getOffsetx())) / getCellSize())
				% 2
				== 0) {
				position.set(Direction.VERT, toR(y), toC(x - getHalfCellSize())); // c̕ӏ
			} else {
				position.set(Direction.HORIZ, toR(y - getHalfCellSize()), toC(x)); // ̕ӏ
			}
			if (!isSideOn(position))
				return;
			p2bSide(position);
			int modifier = e.getModifiers();
			if ((modifier & InputEvent.BUTTON1_MASK) != 0) {
				if ((e.getModifiersEx() & InputEvent.SHIFT_DOWN_MASK) != 0)
					leftClickedShiftEdge(position);
				else
					leftClickedEdge(position);
			} else if ((modifier & InputEvent.BUTTON3_MASK) != 0) {
				rightClickedEdge(position);
			}
			repaint();
		}
	}
	protected void leftClickedEdge(SideAddress position) {
	}
	protected void leftClickedShiftEdge(SideAddress position) {
	}
	protected void rightClickedEdge(SideAddress position) {
	}

	/**
	 * J[\p̃}EXXi[
	 */
	public class MouseHandlerCursor implements MouseListener {
		/* 
		 * J[\ړ
		 */
		public void mousePressed(MouseEvent e) {
			getCellCursor().setPosition(toR(e.getY()), toC(e.getX()));
			repaint();
		}
		public void mouseClicked(MouseEvent e) {
		}
		public void mouseEntered(MouseEvent e) {
		}
		public void mouseExited(MouseEvent e) {
		}
		public void mouseReleased(MouseEvent e) {
		}
	}

}
