#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;* )$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+ */

//SH_LS
/*	GPLv3+	*/
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*SH_doc*
title=*SH_bn* section=3 repnl=\040
@name	laptime
@_brief	research interval times
@_syno
 #include *SH_bn*.h
 
 const char* laptime([int num / const char* msg]);
 const char* flaptime(FILE* fp, [int num / const char* msg]);
@tl_dr
	@(code)@
 #include <unistd.h>		//sleep()
 #include "*SH_bn*.h"

 int main(int argc, char** argv) {
 	cosnt char* p = NULL;
 	laptime(0);  //reset and start
 	sleep(1);	
 	laptime();   //>> real 1009ms	: src.c 4:func(): msg:- (to stderr)
 	laptime("hw");  //>> real 1010ms	: src.c 5:func(): msg:hw
 
 	laptime(0); // reset
 	laptime();  //>> real 5ms	: src.c 4:func(): msg:-	
 	
 	flaptime(stdout, 0);   //laptime(0) with req fp, 
 	flaptime(stdout);      //laptime()
 	flaptime(stdout, "hello");   //laptime("hello")
 	
 	p = flaptime(NULL, "hw");    //nodisp if fp == NULL
 	puts(p);   //ret output msg in the inner static sbuf[]
 	
 	return 0;
 }
 // ~$ cc src.c
	@()@
@params
		@(code)--@
	- num : int. only 0. reset and start timer.
	- msg : char*. disp spend times+msg
	- void: conv to blank lit "".
	- fp  : output FILE* fp. laptime() use stderr. noout if set NULL
		@()@
@return
	msgptr saved in inner static sbuf[128]. output msg is not limited,
	but rtnstr maybe cutoff if too long.
@_desc
	save times to static val when set laptime(0). thread-unsafe.
	time precision is 'ms'.
@notes -
@copyrihgt Copyright 2022 momi-g, GPLv3+
@conforming_to POSIX.1-2001+ (-D_XOPEN_SOURCE=600 etc)
@_ver 2022-07-10 v1.0.3	(2021-02-17 v1.0.0)
//SH_docE*/

/*SH_ED*/

/*SH_HD*/
#ifndef e56c45531f01
#define e56c45531f01

#include <features.h> 	//SH_co* -D_XOPEN_SOURCE=600 -std=c99 */
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include	"stop cc: needs compiler posix-2001 or upper(c99+)"
#endif


#define laptime(...)	laptime_sub(stderr, #__VA_ARGS__, __FILE__,__LINE__, __func__, __VA_ARGS__+0)
#define flaptime(fp, ...)	laptime_sub(fp, #__VA_ARGS__, __FILE__,__LINE__, __func__, __VA_ARGS__+0)
const char* laptime_sub(FILE* fp, const char* s
	, const char* fname, int lnum, const char* fcname, const char* msg);

//hpp
#ifdef _IMPL_*SH_bn*
	#include "*SH_bn*.c"	/*SH_rf* *SH_bn*.c */
#endif

#endif
/*SH_ED*/

/*SH_SC*/
#include <stdio.h>
#include <unistd.h>
#include <time.h>

#ifdef TEST
#include "*SH_bn*.h"
 #if  (199901L <= __STDC_VERSION__ +0)
	#include "msgp.h"
	#include "hcut.h"
 #endif
#endif

#define LAPTIME_MSGSZ 128 -1
static char sbuf[LAPTIME_MSGSZ+1] = {0};
static struct timespec lapbase;

const char* laptime_sub(FILE* fp, const char* str
 , const char* fname, int lnum, const char* fcname, const char* msg){
	 
	if(str[0]!='\0'&&msg==NULL){ clock_gettime(CLOCK_MONOTONIC, &lapbase); return sbuf; }
	struct timespec tbuf;
	clock_gettime(CLOCK_MONOTONIC, &tbuf);
	time_t s = tbuf.tv_sec-lapbase.tv_sec;
	long ns = tbuf.tv_nsec-lapbase.tv_nsec;
	if(ns<0){s--; ns+=1000*1000*1000;}
	double bet = (double)s*1000 + (double)ns/1000/1000;

	msg==NULL ? msg="-": 0;
	char* fmt = "real\t%.3f ms\t:  %s %d: %s(): msg:%s\n";

	fp ? fprintf(fp,fmt, 	bet, fname, lnum, fcname, msg) :0;
	snprintf(sbuf, LAPTIME_MSGSZ, fmt, 	bet, fname, lnum, fcname, msg);
	return sbuf;
}

#ifdef TEST
#include <unistd.h>
HCUT_ADD(t_laptime) {
	const char* p = NULL;
	//
	laptime(0);
	sleep(1);
	laptime();
	laptime();
	laptime(0);
	laptime("unkokko");
	p = flaptime(NULL, "hello");
	puts(p);
}
#endif

#ifdef TEST
HCUT_RUN("stderr", 1,
t_laptime );
#endif

/*SH_SMP
#include <unistd.h>		//sleep()
#include "*SH_bn*.h"

int main(int argc, char** argv) {
	laptime(0);	//reset
	sleep(1);	
	laptime();		//>> real 9ms	: src.c 4:func(): msg:-
	laptime("hw");	//>> real 10ms	: src.c 5:func(): msg:hw

	laptime(0);	// reset
	laptime();	//>> real 5ms	: src.c 4:func(): msg:-	
	return 0;
}
// ~$ cc src.c *SH_bn*.c
//SH_SMPE*/


/*
 change log
 --
2022-07-10 Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c(header): add hpp, change apt rtntype void >> int

	* *SH_bn*.c(flaptime): add newapi, rewriet output code

2021-06-22  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c(header): fix #error, edit cmt etc. v1.0.2

2021-02-17  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.c: v1.0.0

*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 $dm -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rh $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $dm $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s fgr0 "${C}SMP" "${C}SMPE"<$R0|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"fml $@"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/
/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP y cp $Rs $bn.cbrt;$p"cbrt $bn.cbrt --c $Rs --h cbft.h"|fv	#*/
/*SH_OP Y $e"$Cm$O$Cw">/dev/null;$e"$Cy";fborn;$p"$Rs $Rh $tf"		#*/

/*SH_DF
#-- noob
fman()( $p"cat $1|sed -e '/${C}docE/q'|fgr0 '${C}doc' '${C}docE'|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
fy(){
set -e
cat<<'EEE'|fv
fgr0 "${C}YACC" "${C}YACCE"<$Rs|fbn>myyacc.y
fgr0 "${C}LEX" "${C}LEXE"<$Rs|fbn>mylex.l
fgR "${C}YACC" "${C}YACCE"<$Rs>$Rm
fgR "${C}LEX" "${C}LEXE"<$Rm>$Rs

lex mylex.l
#bison -Wnone -Wall -Wno-empty-rule -p zz -dv myyacc.y 
# bisonはy.tab.c固定名ではなくsrc.tab.c/hを吐く 標準に戻す
bison -Wnone -Wall -Wno-empty-rule -dv myyacc.y --defines=y.tab.h -o y.tab.c

cat $Rh y.tab.c lex.yy.c > $Rs
$p"$Rs"
EEE
}

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C##*]}lit/b l;p;d;:l;n;/${C##*]}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;b l')

fml()(
 # --show-leak-kinds=definite,indirect(inner ref),possible,reachable(doesnt p=NULL)
 #cmd="valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 cmd="valgrind --leak-check=full --show-leak-kinds=definite,possible --track-origins=no --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"
 test $# = 0 && $p"$cmd"|fv && return
 set -- " " "$@"
 $e"$Ct"
 test $? = 0 && $p"$cmd"|fv
)

ftm(){
 awk -v w="$1" '
 /^HCUT_ADD/ && index($0,"("w")")==0 {
	while(match($0,"^#endif$") ==0 ){getline}
	print $0; next
 }
 {print $0}'
}

fte()(
 cat > $Rm-
 cmd="cat"
 [ $# != 0 ] && cmd='ftm $b'
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 b=`$p"$a"|tr ',' ' '`
 sed -ne "p;/_RUN/b l;d;:l;/[)]/{c \\$O $a)$O p;d};n;b l" $Rm-|$e"$cmd"|
 fgr0 "^#ifdef TEST" '^#endif$'
 rm $Rm-
)

ftt(){
 [ $# != 0 ] && [ "${1#[0123]}" = "" ]&&dm="-DVLV=$1"&&shift
 (cat $Rs;fte "$@"<$tf)>$Rm
}
fborn(){
 fgr "^#ifdef TEST" "^#endif$"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif$"<$tf |fte>tests.code
 fgR "^#ifdef TEST" "^#endif$"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
