#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[#]SH_'			;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;R=$R${O%%.*};Re=eval\ 
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

#SH_LS
#!/bin/sh
# GPL_3+
cat << 'EEE' > /dev/null
/* Copyright (C) 2022 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

cat << 'EEE' > /dev/null
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief one-way transpiler for ccl(alt_tcl/tk) to tcl
@_syno
	*SH_bn* [-hHVsS] [files...]
@tl_dr
	@(code)@
	~$ *SH_bn* -s	#>> output sample. use -S to see full grammer
	~$ *SH_bn* -s | *SH_bn*	#>> conv
	~$ *SH_bn* src.ccl src.ccl		#>> cat src.ccl src.ccl|*SH_bn*
	~$ *SH_bn* src.ccl | tee src.tcl	#>> general use
	@()@

	@(code)--@
	-- src.ccl              | -- src.tcl
	//cmt2                  | #cmt2
	#cmt3                   | #cmt3
	puts [[1 +2]]           | puts [expr 1+ 2]
	b=1+2; b(1, 2 3)="$a"   | set b [expr 1+2 ]; set b(1,23) "$a"
	if(a++)                 | if {[incr a]} {..}
	{..};                   | 
	for(i=0;$i<9;i++){..}   | for {set i 0} {$i<9} {incr i} {..}
	@()
@_opt
	@(list_o)
	-hHV: usage, version
	-sS: output ccl sample code, ccl grammer
	@()
@_desc
	ccl is alt_tcl/tk with C-lang oriented syntax extension. --
	opt -s/S outputs ccl sample/full-grammer. --
	you can mix the orig-tcl and ccl code in the same srcfile.
	ccl2tcl ignores/pass through non-ccl strings. 

@EXIT_STATUS
	suc/fail == 0/not 0, return err if src.ccl is something wrong.
@notes
	There is no grammar in Tcl. The idea and simplicity are great.
	Topical performance such as learning cost, stability, history,
	portability will come next to C language and POSIX-Shell. --
	The problem is that the code is a command, so typing is difficult.
	CCL improves it.
@conforming_to	posix-shell
@copyright
	Copyright (C) 2022 Momi-g --
	License GPLv3+ <https://gnu.org/licenses/gpl.html>
@_ver 2022-03-28 v1.1.0 (2022-03-26 v1.0.0)
@_see https://www.tcl-lang.org --
	https://en.wikipedia.org/wiki/Tcl
#SH_docE
EEE
#SH_ED

#SH_HD
#SH_ED

#SH_SC
f_usage(){
cat << 'EEE'
HowTo (*SH_bn* - ccl(alt_tcl/tk) to tcl transpiler)
opt: -sS(ample), -hHV(hHelp,version)
---
eg) ~$ *SH_bn* -s	#>> output TL_DR text
    ~$ *SH_bn* -S | less	#>> disp ccl full-grammer
    ~$ cat src.ccl | *SH_bn* 	#>> exec transpile
    ~$ *SH_bn* src.ccl  	#>> cat ag1 ag2..|ccl2tcl if ag exists
    ~$ *SH_bn* src.ccl | tee src.tcl	#>> general use
EEE
exit 0
}

f_usage_H(){
 cat << 'E'|sed -e'1d;$d'
	#SH_rf* *SH_bn*.1.txt	*
E
exit 0
}
f_version_info(){
cat << 'EEE'
*SH_bn* *SH_ver*
Copyright (C) 2022 Momi-g
License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>
EEE
exit 0
}

f_err(){ echo "`basename $0`:ERR: $*" >/dev/stderr; exit 1;}
f_msg(){ echo "`basename $0`:msg: $*" >/dev/stderr; }

# readlinkp: Copyright (C) 2021 Momi-g: License GPLv3+ <https://gnu.org/licenses/gpl.html>
readlinkp()(
	b="$1"; LC_ALL=C
	while :;do
		[ "${b##/*}" = "" ] || b="$PWD/$b"
		[ -d "$b" ] && { cd "$b";printf '%s'_ "$PWD";return 0; }
		[ ! -e "$b" ]&&
		(	s=""
			while [ "$b" != "" ]; do
			[ "${b%%*/..}" = "" ] && { b="${b%/*}";b="${b%/*}";continue;}
			[ "${b%%*/.}" = "" ] && { b="${b%/*}";continue;}
			s="/${b##*/}$s";b="${b%/*}"
			done
			printf '%s'_ "$s"
		) && return 0
		cd "${b%/*}"
		[ -L "$b" ]||break; s="$b: symbolic link to @"
		b=`file -h "${b%:*}"|cut -b ${#s}-;printf @`
		b="${b%??}"
	done
	printf '%s/%s' "$PWD" "${b##*/}_"
)
# readlinkp: end
exdir=`readlinkp "$0"`
exdir=$(dirname "$exdir")

f_sample(){
cat<<'EEE'
#sample.ccl
/* this code shows allmost all
the ccl extension syntax */

puts [[1 +2]]; puts $a(1 ,2); puts 'hw{}gw'
b=1+2; b(1, 2 3) = "$a"	//assign: lv must varname except '$'
b='1+2'; {b} = "$a"	// rv==calc if top isnt {['" 
$b=1+2	//ignore if ccl syntax isnt
b++ ;{b}++ ;b(1,  $a)++
if(a++)		//if,elif,elseif,else
{..}; while(a="b"){..}	
for(i=0;$i<10;i++){..}
loop(10){ a = [[$a +1]] }	//loop() is changed to for(), _i is fixed
fn myf(a, $10 z){...}	//fn name() is changed to proc(). '$' is/isnt

//pragma_rawb
[[1+2]], ccl2tcl skips 'pragma_raw(sp*)(\n)' b-e lines 
#pragma_rawe
ccl_printf "123"	//see -S opt + rep_word 

// ~$ ./ccl2tcl -s | ./ccl2tcl
// ~$ ./ccl2tcl -S | less
EEE
	exit 0
}

f_grammer(){
cat<<'EEE'
# ccl.ped - alt_tcltk, C-lang oriented syntax extension, GPLv3+

##extension:
#	cmt : #, //, /**/	>> ;#..  ;#... if 0 {...}
#	calc: [[...]]	>> [expr ...]
#	blk : {..[[nest_work]]..}, '..sh-qu}..' >> { [expr ] }, {..sh-qu\}..} 
#	val : $a(1  , a$b)	>> $a(1,a$b)
#	assign: a(1, 2 3) = 1; a='z'	>> set a(1,23) [expr 1 ]; set a {z}
#	iter  : {i}++, 'i'++, "i"--, abc(0 3)--	>> incr {i}, incr abc(03) -1
#	flow: if/while(1){..}, for(i=0;$i<1;abc i++){..}, loop(10){..}
#		>> if {1} {...}, for {set i 0} {$i<1} {abc incr i}
#		>> (loop '_i' is fix) for {set _i 10} {$_i>0} {incr _i -1} {..} 
#	def : fn/proc myf($10, b,$c){...}	>> proc myf {10 b c} {...}
#	skip: ...pragma_rawb(sp)(\n) ..pragma_rawe(sp)(\n)	>>skip transpile 

##guideline/restrection for ccl code
# - avoid non-genaral varname: OK: $a(1) $a::b2(2), AVOID: $_)(%&(1) 
# - single quote '' works the same as shell '' and cant hold sq itself
# - ccl2tcl doesnt parse sq_blk '..' inner strings
# - assign 'lv=rv' works if rv top isnt {['" >> calc  

#--main_rules
BOF <- !!.
code <- node / .	# {}() may hit to '.', for support ccl syntax
node <- CMT		# corerule 
	/ BLANK / SEP
	/ ext_stx		# $a=1, fn(){} etc
	/ CB_BLK / DQ_BLK / SQ_BLK
	/ CMDR	# replace [..]
	/ rep_word		#'printf' >> 'format' etc
	/ CSEQ	# Char Sequences
EOF <- !.
#--main_rules_end

	#--replace name,word,token etc
rep_word <- 'ccl_printf' ![a-zA-Z0-9_]		{_1 = 'format'}
	#	/ 'printf' ![a-zA-Z0-9_]		{_1 = 'format'}
	#	/ 'pf'	![a-zA-Z0-9_]		{_1 = 'format'}

	#--cmn
BLANK <- e'([ \t\n]|\r\n)+'
	/ EOF
NL <- e'(\r\n|\n)' / EOF
SP <- e'[ \t]+'
SEP <- ';'
CHAR <- e'(\\.|\\\r\n|.)'

#--subrules
	#--cmt
CMT <- rawcode/ lcmt / mcmt / ocmt		# // /**/ == ;#, ;if 0 { ... }
rawcode <- NL? e'[^\n]*pragma_rawb' SP* NL
	(! e'[^\n]*pragma_rawe[ \t]*(\r\n|\n)' .)*
	e'[^\n]*pragma_rawe' SP* NL
	{_2=_4 ';#rawcode_b'; _6 = ';#rawcode_e' }

lcmt <- '//' e'[^\n]*\n' { _1 = ';#' }
	# yx(  [^x]*[y]  |  [x]*[^xy] )*  x+y >> /[*]([^*]*[/]|[*]*[^*/])*[*]+/
mcmt <- '/*' (!'*/' c_mcmt)* '*/' { _0 = ';if 0 {;#mcmt:' _2 '} ' }
c_mcmt <- [{}] { _0 = '\\' _0  }
		/ .
ocmt <- (SEP/SP)* '#' { _0 = ';#' }

	#--cmd_replace
CMDR <- '[[' ( !']]' code)* ']]'	{ _0 = '[expr ' _2 ' ]' }
	/ '[' ( !']' code)* ']'
	
	#--block
CB_BLK <- '{' (!'}' node)* '}' 		{ _0 = ' ' _0 ' ' }
DQ_BLK <- '"' ( VAR/CMDR/!["] CHAR)* '"' 	{ _0 = ' ' _0 ' ' }
SQ_BLK <- "'" sqCHAR* "'" 	{ _0 = ' {' _2 '} ' }
	sqCHAR <- [{}]	{_0 = '\\' _0 }
		/ e'(\\.|\\\r\n|[^'])'
	
	#--pass_chars: ')}]' is catched at 'code' rule
CSEQ <- (CMDR/VAR/!(SEP/BLANK/e'[][{}()]')CHAR)+

	#--ignore_array_blank:	$a(1 2 , ) >> $a(12,)
VAR <- '$' VNAME
VNAME <-	e'[{](\\}|[^}])*[}]'		# ${...} >> dont parse in ${var} nameblk
		/	e'[a-zA-Z0-9_:]+' _IDX	
		/	e'[a-zA-Z0-9_:]+'
_IDX <- '(' _IDXags* ')'	# (1,   3 4) >> (1,34)
	_IDXags <- BLANK? _IDXag BLANK? ','?  { _1=''; _3='' }
	_IDXag <- ( CMDR / VAR / !(SEP/BLANK/e'[],)]')CHAR )+

	#---ext_syntax, assign, loop etc
ext_stx <- ass	# a = 10
	/ flow	# if/for/while/loop
	/ fdef	# fn fname(a,b=10){...}

	#---ass
ass <- LNAME BLANK? !OP '=' BLANK? RVAL {_0='set ' _1 ' ' _6 }
	/ LNAME '++'	{_0='incr ' _1 }
	/ LNAME '--'	{_0='incr ' _1 ' -1' }
LNAME <- VNAME
		/ SQ_BLK
		/ DQ_BLK
OP <- '==' / '<=' / '>=' / '!='		# '=' >> assign, '==' >> compare
RVAL <- CMDR / CB_BLK / DQ_BLK / SQ_BLK
	/ (!(NL/SEP/CMT) code)+ { _0 = '[expr ' _0 ' ]' }

	#---flow:  if/for/while/loop (1==1){...} >> if { 1==1 } { ... }
flow <- flow_if	/ flow_for 

IF_WORD <- 'if' / 'while' / 'elseif' / 'elif' { _0= 'elseif' }
flow_if <- IF_WORD BLANK? '(' (!')' node)* ')' BLANK? { _3=' {'; _5='} '; _6='' }
	/ 'loop' BLANK? '(' (!')' node)* ')' BLANK?
		{ _0 = 'for {set _i ' _4 '} {$_i>0} {incr _i -1}' }

flow_for <- 'for' BLANK? '(' (!')' cond)+ ')' BLANK?  { _0 = _1 _4}
cond <- BLANK? node BLANK? SEP? {_0 = ' {' _2 '}' }

	#---fdef: fn a(x,y $z){...} >> proc a {x y z} {...}
fdef <- e'fn|proc' BLANK+ e'[a-zA-Z0-9_:]+' BLANK? _AGS BLANK?
	{ _0 = 'proc ' _3 ' { ' _5 ' } '}
_AGS <- '(' _AG* ')'	{_0 = _2}
	_AG <- BLANK? '$'? e'[a-zA-Z0-9_:]+' BLANK? ','?  { _0 = _3 ' ' }

EEE
}
set -e
#--

*SH_bn*_main(){
	#--args
OPTIND=1
while getopts hHVSs flg
do
	case $flg in
	h) f_usage;;
	H) f_usage_H;;
	V) f_version_info;;
	S) f_grammer;exit 0;;
	s) f_sample;;
	[?]) exit 1;;
	esac
done
shift $((OPTIND - 1))

	#--preset_dfl
incmd='cat /dev/stdin'
[ $# != 0 ] && incmd='cat "$@"'
rstr="`f_grammer`"

#printf '%s\n' "$rstr"
#exit 0
cmd="$incmd|"'$exdir/ped -re "$rstr"'
#printf '%s\n' "$cmd"
eval "$cmd"
}

#SH_TSS
test_1(){
	_eq 1 1
	buf=`echo 123 |*SH_bn*_main`
	_eq 123 "$buf"	"msg:ignore"

	buf=`echo '//..' |*SH_bn*_main`
	_eq ';#..' "$buf"	"msg:lcmt"	

	buf=`echo '/*..*/' |*SH_bn*_main`
	echo "test: $buf"	
	_eq 0 0	"msg:mcmt"
	
	buf=`echo '[[..]]' |*SH_bn*_main`
	_eq '[expr .. ]' "$buf"	"msg:calc"

	buf=`echo '{[[..]]}' |*SH_bn*_main`
	_eq ' {[expr .. ]} ' "$buf"	"msg:nest"

	buf=`echo "'.[[]]{}..'" |*SH_bn*_main`
	_eq ' {.[[]]\{\}..} ' "$buf"	"msg:sq"

	buf=`echo '$a(1  , a$b)' |*SH_bn*_main`
	_eq '$a(1,a$b)' "$buf"	"msg:arr"

	buf=`echo 'a(1, 2 3) = [[1 +2]]' |*SH_bn*_main`
	_eq 'set a(1,23) [expr 1 +2 ]' "$buf"	"msg:arrass"

	buf=`echo 'if($a == 1){..}' |*SH_bn*_main`
	_eq 'if {$a == 1}  {..} ' "$buf"	"msg:if"

	buf=`echo 'fn myf($1, b,$c){..}' |*SH_bn*_main`
	_eq 'proc myf { 1 b c  }  {..} ' "$buf"	"msg:fn"
#add
	buf=`echo "'a'++ {a}++ abc(0 3)--" |*SH_bn*_main`
	_eq 'incr  {a}  incr {a} incr abc(03) -1' "$buf"	"msg:iter"

	buf=`echo '"a"++' |*SH_bn*_main`
	_eq 'incr  "a" ' "$buf"	"msg:dqiter"

	buf=`echo 'a = 12' |*SH_bn*_main`
	_eq 'set a [expr 12 ]' "$buf"	"msg: expr ass"

	buf=`echo '"a" = 12' |*SH_bn*_main`
	_eq 'set  "a"  [expr 12 ]' "$buf"	"msg: expr ass2"

	buf=`echo 'a = "12"' |*SH_bn*_main`
	_eq 'set a  "12" ' "$buf"	"msg: direct ass"

	buf=`echo 'a = {12}' |*SH_bn*_main`
	_eq 'set a  {12} ' "$buf"	"msg: cb ass"

	buf=`echo 'a = [[12]]' |*SH_bn*_main`
	_eq 'set a [expr 12 ]' "$buf"	"msg: [] ass"

	buf=`echo 'a = "12[[1]]"' |*SH_bn*_main`
	_eq 'set a  "12[expr 1 ]" ' "$buf"	"msg: dq ass"

	buf=`echo "a = '12[[1]]'" |*SH_bn*_main`
	_eq "set a  {12[[1]]} " "$buf"	"msg: sq ass"

#	_res
}
#SH_TSE

*SH_bn*_main "$@"	#SH_MAIN

cat << EEE >/dev/null
/*
 change log
 --
2022-03-28 Momi-g	<dmy@dmy.dmy>

	* *SH_bn* (ccl.ped): change assign $a = 1 >> a=1. v1.1.0
	: allow lv==VNAME, DQ, SQ >> beta test
	: del 'pragma_rawe' trailing blank line
	: add rep_word, ccl_printf >> format etc
	
2022-03-28 Momi-g	<dmy@dmy.dmy>

	* *SH_bn* (ccl.ped): add $a = ![{['"]123 >> expr. v1.0.1

2022-03-26 Momi-g	<dmy@dmy.dmy>

	* *SH_bn* (none): init v1.0.0

*/
EEE
#SH_ED

#SH_OP _ a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
#SH_OP h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout	GPLv3+"	 #*/
#SH_OP f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0|tr -d ' \t'|grep -F '()' #*/
#SH_OP t $e"$CW";ftt "$@";bash --posix $Ox $tf
#SH_OP x Ox="-x"

#SH_OP b $e"$CW"
#SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;chmod 755 $bn;$p"$bn $Rs $Rh $tf"	#*/
#SH_OP o $e"$CW";$p'fman $Rh 1'|fv		#*/

#SH_DF
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 -l -<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
 #(echo '.mso ja.tmac';cat $bn.$2)|man -Tutf8 -l -|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
)

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" -v cs='#' -v ce='' 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"%s--copyfrom %s %s\";cat \"%s\";echo \"%s--copyend %s %s\")"
 mm="[ -f \"%s\" ]&&(_=\"%s%s%s\";cat \"%s\";_=\"%s%s%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,cs,v,ce,v,cs,v,ce))}
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte()(
 cat > $Rm-
 suite=$(cat $Rm-|awk '$1~/^test_[^(]*\(\)/{print $1}'|sed -e 's/[(].*//g')
 [ $# = 0 ] && suite="$suite $suite"|| suite="$suite $@"
 suite=`$p'%s\n' "$suite"|tr '[ \t]' '\n'|sort|uniq -d|fsl`
 (cat $bn $Rm-|grep -vF "${C##*]}MAIN"
 $p' [ $# = 0 ] && set -- '"$suite"';for fc;do $fc ;done;_res')
 rm -f $Rm-
)
ftt()(shunit_m>$Rm;fte "$@"<$tf>>$Rm;mv $Rm $tf)

fborn(){
 fgr0 "${C}TSS" "${C}TSE"<$R0|fbn>$tf
 fgR "${C}TSS" "${C}TSE"<$Rs|fbn|tee $Rm>$bn;mv -f $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
 fgR "${C}TSS_" "${C}TSE"<$R0 |fgr0 "${C}TSS" "${C}TSE"|fbn|fte>tests.code
}
#SH_DE
