#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

#	(
#	set -e	#exit 1 if anycmd rtns $? = 1
#	skip=0
#	cd `dirname "$0"`
#	
#	cp ./sed_edited.tar.gz ../
#	cd ../
#	[ -d  sed_edited ] && skip=1
#	[ $skip = 0 ] && tar -xf sed_edited.tar.gz
#	cd sed_edited
#	mv ../src/tmp.c ./sed
#	echo "sed pkg is running. wait a minutes..."
#	#autoreconf
#	[ $skip = 0 ] && ./configure
#	make
#	rm libtmp.a 2>/dev/null||:
#	ar -r libtmp.a `find ./ -type f|grep '\.o$'|grep -v main.o`
#	cp libtmp.a ../src 
#	cd ..
#	rm sed_edited.tar.gz 2>/dev/null||:
#	)
#	exit 0

set -eu	#exit 1 if anycmd rtns $? = 1
(
pdir=`pwd`	#parent, callsrc dir
cd `dirname $0`	#base $0 dir
bdir=`pwd`
cd ..
topdir=`pwd`	#configure root
rm -rf ./exdir 2>/dev/null|| :
mkdir -p exdir
cd $bdir

v_afiles=`ls *.tar.gz *.zip 2>/dev/null || :`
[ ${#v_afiles} != 0 ] || exit 0

for v_afile in $v_afiles;do
	conflg=0
	cd $bdir
	v_dname=${v_afile%.tar.gz}
	v_dname=${v_dname%.zip}
	ucmd="tar -xf $v_afile"
	[ "$v_dname" = "${v_afile%.tar.gz}" ] || ucmd="unzip $v_afile"
	[ "../$v_dname" -nt "$v_afile" ] ||
	{
		cp $v_afile ../
		cd ../
		rm -rf "$v_dname"
		eval "$ucmd"
		conflg=1
		rm $v_afile 2>/dev/null||:
		cd $bdir
	}
	cd ../$v_dname
# [ ${v_afile#app123} != $v_afile ] && make,cp,remove,ls,copy etc. not autotool pkg
	case "$v_dname" in
	sed_edited*)
		mv "$topdir"/src/tmp.c ./sed
		#autoreconf
		[ $conflg = 0 ] || ./configure
		make CFLAGS="-fPIC"
		rm libtmp.a 2>/dev/null||:
		ar -r libtmp.a `find ./ -type f|grep '\.o$'|grep -v main.o`
		cp libtmp.a "$topdir"/exdir 
	;;
	*)
		echo "unreachable code, $0" >/dev/stderr
		exit 1
	;;
	esac
done
cd "$topdir/exdir"	
buf=`find ./	\
	-name '*.a'		\
-o	-name '*.h'		\
`
for i in $buf;do
	cp $i ../src
done
# mv ../../src/libluajit.a ../../src/libluajit_e.a
)

#	# prepare.sh ./src でexcopyにexternalsの中身がコピーされて、内部でmakeされて
#	# srcにインストールされる。
#	# ./dst -e でdstに入ってmakeを実行、../にインストールする。
#	# ファイル名展開findの兼ね合いで再帰起動にしてる。
#	
#	# get fullpath
#	savdir=`pwd -P`
#	savdir="${savdir%/}"
#	
#	base="${0%/*}"
#	test "$base" = "$0" && base="./" 
#	cd "$base"
#	fbase=`pwd -P`
#	fbase="${fbase%/}"
#	fname="${0##*/}"
#	fname="$fbase/$fname"
#	cd "$savdir"
#	
#	if ! [ -d "$1" ]; then
#		echo "$0: $1, need args1, dstdir. sleep." >/dev/stderr
#		while : ; do sleep 1000 ; done
#	fi
#	
#	cd "$1"
#	dstdir=`pwd -P`	#get dst full
#	dstdir="${dstdir%/}"
#	cd "$savdir"
#	# 実行パス、dstパス、このスクリプトの場所pathのパス
#	# 全てfullpathで取得完了。実行パスに戻る。
#	
#	#extend,	sh '$now' '{}' '-e' ';'
#	# 今コピー先の内部にいるので、一つ上がればソースの海になってる。
#	if [ "$2" != "" ]; then
#		cd "$1"
#		#if $1 = "aaa_dir" then ...
#		# フォルダごとに分ける場合。並べるとか。
#		make
#		make install prefix="$2"
#		exit
#	fi
#	
#	# copy all dirs
#	cd "$fbase"
#	
#	mkdir -p "$fbase/../excopy"	#-p: 存在の場合はスルー
#	# -R 再帰+フォルダ -n 上書きしない。
#	# fileを合法的に扱うにはfindしか手段がない。set * でposでもいけそうだけどdirは無理
#	find -L ./ -maxdepth 1 -type d ! -path ./ -exec cp -L -R -n '{}' "$fbase/../excopy" ';'
#	cd "$fbase/../excopy"
#	# recursive run with '-e'
#	find -L ./ -maxdepth 1 -type d ! -path ./ -exec sh "$fname" '{}' "$dstdir" ';'
