package jp.sf.pal.ggadget.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.ggadget.GGadgetConstants;
import jp.sf.pal.ggadget.GGadgetException;
import jp.sf.pal.ggadget.entity.GGadget;
import jp.sf.pal.ggadget.form.EditForm;
import jp.sf.pal.ggadget.pager.GGadgetPager;
import jp.sf.pal.ggadget.service.GGadgetService;
import jp.sf.pal.ggadget.util.GGadgetList;
import jp.sf.pal.ggadget.util.GGadgetUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.seasar.struts.exception.ActionMessagesException;

public class EditAction implements Serializable {

    private static final long serialVersionUID = -706071679279481385L;

    private static final Log log = LogFactory.getLog(EditAction.class);

    public List<GGadget> gadgetItems;

    public List<Integer> pageItems;

    public String currentName;

    public boolean existPrevPage;

    public boolean existNextPage;

    public int allRecordCount;

    public int allPageCount;

    public int currentPageNumber;

    @ActionForm
    private EditForm editForm;

    private GGadgetPager gGadgetPager;

    private GGadgetService gGadgetService;

    private transient HttpServletRequest request;

    @Execute(validator = false, input = "error.jsp")
    public String index() {
        try {
            currentName = GGadgetUtil.getPreferenceValue(request,
                    GGadgetConstants.NAME, "");

            editForm.category = gGadgetPager.getCategory();
            editForm.query = gGadgetPager.getQuery();
            editForm.language = gGadgetPager.getLanguage();

            GGadgetList<GGadget> gadgets = gGadgetService
                    .getGGadgetList(gGadgetPager);
            allRecordCount = gadgets.getAllRecordCount();
            allPageCount = gadgets.getAllPageCount();
            currentPageNumber = gadgets.getCurrentPageNumber();
            existPrevPage = gadgets.isExistPrevPage();
            existNextPage = gadgets.isExistNextPage();
            gadgetItems = gadgets;
            request.getSession().setAttribute(GGadgetConstants.GADGET_ITEMS,
                    gadgetItems);

            int startIdx = currentPageNumber - 5;
            if (startIdx < 1) {
                startIdx = 1;
            }
            int endIdx = currentPageNumber + 5;
            if (endIdx > allPageCount) {
                endIdx = allPageCount;
            }
            pageItems = new ArrayList<Integer>();
            for (int i = startIdx; i <= endIdx; i++) {
                pageItems.add(i);
            }

            return "index.jsp";
        } catch (GGadgetException e) {
            log.error(e.getMessage(), e);
            throw new ActionMessagesException(
                    "errors.could_not_load_gadget_info");
        }
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "setcategory/{category}")
    public String find() {
        gGadgetPager.reset();
        gGadgetPager.setCategory(editForm.category);
        gGadgetPager.setQuery(editForm.query);
        gGadgetPager.setLanguage(editForm.language);
        return index();
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "list/{pageNumber}")
    public String list() {
        try {
            int start = (Integer.parseInt(editForm.pageNumber) - 1)
                    * gGadgetPager.getNum();
            gGadgetPager.setStart(start);
        } catch (NumberFormatException e) {
            // nothing
        }
        return index();
    }

    @Execute(validator = false, input = "error.jsp", urlPattern = "update/{id}")
    public String update() {
        if (editForm.id == null) {
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_no_id");
        }

        gadgetItems = (List<GGadget>) request.getSession().getAttribute(
                GGadgetConstants.GADGET_ITEMS);
        if (gadgetItems == null) {
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_no_session");
        }

        gadgetItems = (List<GGadget>) HotdeployUtil.rebuildValue(gadgetItems);

        boolean isUpdate = false;
        int id = Integer.parseInt(editForm.id);
        for (GGadget gadget : gadgetItems) {
            if (gadget.getId() == id) {
                try {
                    GGadgetUtil.store(request, gadget);
                    GGadgetUtil.addMessage(request, "success.update_gadget");
                    isUpdate = true;
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                    throw new ActionMessagesException(
                            "errors.failed_to_update_because_of_system_error");
                }
            }
        }

        if (!isUpdate) {
            throw new ActionMessagesException(
                    "errors.failed_to_update_because_of_no_object");
        }

        return index();
    }

    @Execute(validator = false, input = "error.jsp")
    public String prev() {
        int start = gGadgetPager.getStart();
        start -= gGadgetPager.getNum();
        if (start < 0) {
            start = 0;
        }
        gGadgetPager.setStart(start);
        return index();
    }

    @Execute(validator = false, input = "error.jsp")
    public String next() {
        int start = gGadgetPager.getStart();
        start += gGadgetPager.getNum();
        gGadgetPager.setStart(start);
        return index();
    }

    public GGadgetService getGGadgetService() {
        return gGadgetService;
    }

    public void setGGadgetService(GGadgetService gadgetService) {
        gGadgetService = gadgetService;
    }

    public GGadgetPager getGGadgetPager() {
        return gGadgetPager;
    }

    public void setGGadgetPager(GGadgetPager gadgetPager) {
        gGadgetPager = gadgetPager;
    }

    public EditForm getEditForm() {
        return editForm;
    }

    public void setEditForm(EditForm editForm) {
        this.editForm = editForm;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}
