/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.teeda.extension.annotation.takeover.TakeOver;

public class UserCreatePage extends AbstractUserPage implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 4251184998427709566L;

    private List<Map<String, String>> roleNameItems;

    /**
     * @return the roleItems
     */
    public List<Map<String, String>> getRoleNameItems() {
        return roleNameItems;
    }

    /**
     * @param roleItems the roleItems to set
     */
    public void setRoleNameItems(List<Map<String, String>> roleItems) {
        this.roleNameItems = roleItems;
    }

    public String initialize() {
        return null;
    }

    public String prerender() {
        // set pull-down
        setRoleNameItems(getUserManagementService().getRoleNames());

        // update?

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(properties = "name,password,updateRequired,roleName")
    public Class doConfirm() {
        PALAdminUtil.setPasswordToSession(getPassword());
        setPassword("******");
        return UserConfirmPage.class;
    }
}
