/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.web.AbstractPagerPage;
import jp.sf.pal.admin.web.CrudType;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;

public class UserAttributeListPage extends AbstractPagerPage implements
        Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 8042231097969101982L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserAttributeListPage.class);

    private String name;

    private String key;

    private int userAttributeIndex;

    private List<Map<String, Object>> userAttributeItems;

    private String value;

    private UserManagementService userManagementService;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the key
     */
    public String getKey() {
        return key;
    }

    /**
     * @param key the key to set
     */
    public void setKey(String key) {
        this.key = key;
    }

    public int getUserAttributeIndex() {
        return userAttributeIndex;
    }

    public void setUserAttributeIndex(int userAttributeIndex) {
        this.userAttributeIndex = userAttributeIndex;
    }

    public List<Map<String, Object>> getUserAttributeItems() {
        return userAttributeItems;
    }

    public void setUserAttributeItems(
            List<Map<String, Object>> userAttributeItems) {
        this.userAttributeItems = userAttributeItems;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService() {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    @TakeOver(properties = "crudType,name")
    public Class doCreate() {
        setCrudType(CrudType.CREATE);
        return UserAttributeEditPage.class;
    }

    public String initialize() {
        return null;
    }

    public String prerender() {
        try {
            getUserManagementService().loadPage(this);
        } catch (PALAdminException e) {
            FacesMessageUtil.addErrorMessage("failed.to.get.userattributes");
            logger.error("Failed to get user attributes: " + getName(), e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

}
