/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.web.CrudType;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class UserAttributeConfirmPage extends AbstractUserAttributePage
        implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 8059029609744518426L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserAttributeConfirmPage.class);

    public Class initialize() {
        return null;
    }

    public Class prerender() {
        if (getCrudType() == CrudType.DELETE) {
            //  update
            if (getKey() != null) {
                try {
                    getUserManagementService().loadPage(this);
                } catch (PALAdminException e) {
                    FacesMessageUtil
                            .addErrorMessage("failed.to.get.userattributes");
                    logger.error("Failed to get user attributes: " + getName(),
                            e);
                }
            } else {
                setCrudType(CrudType.READ);
                return UserAttributeListPage.class;
            }
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "name")
    public Class doUpdate() {

        switch (getCrudType()) {
        case CrudType.CREATE:
            try {
                getUserManagementService().insert(this);
                FacesMessageUtil.addInfoMessage("added.new.userattribute",
                        new Object[] { getName() });
            } catch (PALAdminException e) {
                FacesMessageUtil.addErrorMessage(
                        "failed.to.add.new.userattribute",
                        new Object[] { getName() });
                logger.error(
                        "Failed to add a new user attribute: " + getName(), e);
            }
            break;
        case CrudType.UPDATE:
            try {
                getUserManagementService().update(this);
                FacesMessageUtil.addInfoMessage("added.new.userattribute",
                        new Object[] { getName() });
            } catch (PALAdminException e) {
                FacesMessageUtil.addErrorMessage(
                        "failed.to.add.new.userattribute",
                        new Object[] { getName() });
                logger.error(
                        "Failed to add a new user attribute: " + getName(), e);
            }
            break;
        case CrudType.DELETE:
            try {
                getUserManagementService().delete(this);
                FacesMessageUtil.addInfoMessage("deleted.userattribute",
                        new Object[] { getName() });
            } catch (PALAdminException e) {
                FacesMessageUtil.addErrorMessage(
                        "failed.to.delete.userattribute",
                        new Object[] { getName() });
                logger.error("Failed to delete a new user attribute: "
                        + getName(), e);
            }
            break;
        default:
            break;
        }
        return UserAttributeListPage.class;
    }

    public boolean isComeFromList() {
        return getCrudType() == CrudType.READ
                || getCrudType() == CrudType.DELETE;

    }

}
