/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.site;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import jp.sf.pal.admin.entity.NodeInfo;
import jp.sf.pal.common.CommonException;
import jp.sf.pal.common.util.FacesMessageUtil;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class PortletInfoEditorPage extends AbstractSiteEditorPage implements
        Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -5933118337604397635L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(LayoutInfoEditorPage.class);

    private String decorator;

    private List<Map<String, String>> decoratorItems;

    private String desktopTheme;

    private List<Map<String, String>> desktopThemeItems;

    private String fragmentId;

    private String portletName;

    private List<Map<String, String>> portletNameItems;

    public String getDecorator() {
        return decorator;
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }

    public List<Map<String, String>> getDecoratorItems() {
        return decoratorItems;
    }

    public void setDecoratorItems(List<Map<String, String>> decoratorItems) {
        this.decoratorItems = decoratorItems;
    }

    public String getDesktopTheme() {
        return desktopTheme;
    }

    public void setDesktopTheme(String desktopTheme) {
        this.desktopTheme = desktopTheme;
    }

    public List<Map<String, String>> getDesktopThemeItems() {
        return desktopThemeItems;
    }

    public void setDesktopThemeItems(List<Map<String, String>> desktopThemeItems) {
        this.desktopThemeItems = desktopThemeItems;
    }

    public String getFragmentId() {
        return fragmentId;
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public String getPortletName() {
        return portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public List<Map<String, String>> getPortletNameItems() {
        return portletNameItems;
    }

    public void setPortletNameItems(List<Map<String, String>> portletNameItems) {
        this.portletNameItems = portletNameItems;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        // parse request parameters
        parseRequestParameters();

        if (getPath() == null) {
            setPath("/");
            return FolderInfoEditorPage.class;
        }

        if (getReturnPath() == null) {
            setReturnPath("/");
        }

        // check node
        int type = getSiteEditorService().getNodeInfoType(getPath());
        if (type == NodeInfo.FOLDER) {
            return FolderInfoEditorPage.class;
        } else if (type == NodeInfo.PAGE) {
            return PageInfoEditorPage.class;
        }
        // TODO
        /*else if (type == NodeInfo.LAYOUT) {
                    return LayoutInfoEditorPage.class;
                }*/

        try {
            getSiteEditorService().loadPage(this);
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0001", new Object[] { this.toString() }, e);
        }

        // render FacesMessages
        FacesMessageUtil.renderMessages();
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doUpdate() {
        try {
            getSiteEditorService().updatePortlet(this);
            FacesMessageUtil.addInfoMessage("updated.layout");
            return PortletInfoEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.update.layout");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }

    @TakeOver(type = TakeOverType.INCLUDE, properties = "path,returnPath")
    public Class<?> doDelete() {
        try {
            getSiteEditorService().deletePortlet(this);
            FacesMessageUtil.addInfoMessage("deleted.layout");
            return PageInfoEditorPage.class;
        } catch (CommonException e) {
            FacesMessageUtil.addErrorMessage(e.getMessageId());
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        } catch (Exception e) {
            FacesMessageUtil.addErrorMessage("could.not.delete.layout");
            logger.log("EPA0002", new Object[] { this.toString() }, e);
        }
        return null;
    }
}
