/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.registration;

import javax.faces.context.FacesContext;

import jp.sf.pal.common.util.FacesMessageUtil;

public class PublicPortalForgottenPasswordPage extends
        AbstractForgottenPasswordPage {

    /**
     * 
     */
    private static final long serialVersionUID = 362540675380114688L;

    public static final String email_TRequiredValidator = null;

    public static final String email_lengthValidator = "minimum=5, maximum=80";

    public Class<?> doNext() {
        //TODO check email
        return PublicPortalSecretAnswerPage.class;
    }

    public Class<?> initialize() {
        return null;
    }

    public Class<?> prerender() {
        setGuid((String) FacesContext.getCurrentInstance().getExternalContext()
                .getRequestParameterMap().get("guid"));
        if (getGuid() != null) {
            return PublicPortalForgottenPasswordCompletedPage.class;
        }

        // render FacesMessage
        FacesMessageUtil.renderMessages();
        return null;
    }

    public String getDoNextValue() {
        return getLabelHelper().getLabelValue("Next");
    }

}
