/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.web.registration;

import java.io.Serializable;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.service.UserRegistrationService;

import org.seasar.teeda.extension.annotation.validator.Required;
import org.seasar.teeda.extension.util.LabelHelper;

public abstract class AbstractForgottenPasswordPage implements Serializable {

    private FacesContext facesContext;

    private LabelHelper labelHelper;

    private UserRegistrationService userRegistrationService;

    //TODO mail validator
    @Required
    private String email;

    private String guid;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * @return the guid
     */
    public String getGuid() {
        return guid;
    }

    /**
     * @param guid the guid to set
     */
    public void setGuid(String guid) {
        this.guid = guid;
    }

    /**
     * @return the facesContext
     */
    public FacesContext getFacesContext() {
        return facesContext;
    }

    /**
     * @param facesContext the facesContext to set
     */
    public void setFacesContext(FacesContext facesContext) {
        this.facesContext = facesContext;
    }

    /**
     * @return the labelHelper
     */
    public LabelHelper getLabelHelper() {
        return labelHelper;
    }

    /**
     * @param labelHelper the labelHelper to set
     */
    public void setLabelHelper(LabelHelper labelHelper) {
        this.labelHelper = labelHelper;
    }

    /**
     * @return the userRegistrationService
     */
    public UserRegistrationService getUserRegistrationService() {
        return userRegistrationService;
    }

    /**
     * @param userRegistrationService the userRegistrationService to set
     */
    public void setUserRegistrationService(
            UserRegistrationService userRegistrationService) {
        this.userRegistrationService = userRegistrationService;
    }

}
