/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.portletmanager;

import java.io.Serializable;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.PortletManagementService;
import jp.sf.pal.admin.web.AbstractCrudPage;

public class PortletActionConfirmPage extends AbstractCrudPage implements
        Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = -9103369009857828750L;

    private String name;

    private String action;

    private PortletManagementService portletManagementService;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the action
     */
    public String getAction()
    {
        return action;
    }

    /**
     * @param action the action to set
     */
    public void setAction(String action)
    {
        this.action = action;
    }

    /**
     * @return the portletManagementService
     */
    public PortletManagementService getPortletManagementService()
    {
        return portletManagementService;
    }

    /**
     * @param portletManagementService the portletManagementService to set
     */
    public void setPortletManagementService(
            PortletManagementService portletManagementService)
    {
        this.portletManagementService = portletManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        return null;
    }

    public Class doFinish()
    {
        if (isStartAction())
        {
            try
            {
                portletManagementService.startPortletApplication(this);
                FacesMessageUtil.addInfoMessage("started.portlet.application");
            }
            catch (PALAdminException e)
            {
                FacesMessageUtil
                        .addErrorMessage("failed.to.start.portlet.application");
            }
        }
        else if (isStopAction())
        {
            try
            {
                portletManagementService.stopPortletApplication(this);
                FacesMessageUtil.addInfoMessage("stopped.portlet.application");
            }
            catch (PALAdminException e)
            {
                FacesMessageUtil
                        .addErrorMessage("failed.to.stop.portlet.application");
            }
        }
        else if (isUndeployAction())
        {
            try
            {
                portletManagementService.undeployPortletApplication(this);
                FacesMessageUtil
                        .addInfoMessage("undeployed.portlet.application");
            }
            catch (PALAdminException e)
            {
                FacesMessageUtil
                        .addErrorMessage("failed.to.undeploy.portlet.application");
            }
        }
        else if (isDeleteAction())
        {
            try
            {
                portletManagementService.deletePortletApplication(this);
                FacesMessageUtil.addInfoMessage("deleted.portlet.application");
            }
            catch (PALAdminException e)
            {
                FacesMessageUtil
                        .addErrorMessage("failed.to.delete.portlet.application");
            }
        }
        else
        {
            FacesMessageUtil
                    .addWarnMessage("invalid.action.for.portlet.application");
        }
        return PortletListPage.class;
    }

    public boolean isStartAction()
    {
        return PALAdminConstants.PORTLET_MANAGEMENT_ACTION_START
                .equals(getAction());
    }

    public boolean isStopAction()
    {
        return PALAdminConstants.PORTLET_MANAGEMENT_ACTION_STOP
                .equals(getAction());
    }

    public boolean isUndeployAction()
    {
        return PALAdminConstants.PORTLET_MANAGEMENT_ACTION_UNDEPLOY
                .equals(getAction());
    }

    public boolean isDeleteAction()
    {
        return PALAdminConstants.PORTLET_MANAGEMENT_ACTION_DELETE
                .equals(getAction());
    }
}
