/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.deployer;

import java.io.Serializable;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.PortletDeploymentService;
import jp.sf.pal.admin.web.AbstractCrudPage;
import jp.sf.pal.admin.web.CrudType;

public class RemotePortletDeployConfirmPage extends AbstractCrudPage implements Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = -2270772566560001373L;

    private String artifactId;

    private String groupId;

    private String packaging;

    private String version;

    private PortletDeploymentService portletDeploymentService;

    public String getArtifactId()
    {
        return artifactId;
    }

    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    }

    public String getGroupId()
    {
        return groupId;
    }

    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    }

    public String getPackaging()
    {
        return packaging;
    }

    public void setPackaging(String packaging)
    {
        this.packaging = packaging;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        this.version = version;
    }

    /**
     * @return the portletDeploymentService
     */
    public PortletDeploymentService getPortletDeploymentService()
    {
        return portletDeploymentService;
    }

    /**
     * @param portletDeploymentService the portletDeploymentService to set
     */
    public void setPortletDeploymentService(
            PortletDeploymentService portletDeploymentService)
    {
        this.portletDeploymentService = portletDeploymentService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        return null;
    }

    public Class doFinish()
    {
        if (getGroupId() == null || getArtifactId() == null
                || getVersion() == null || getPackaging() == null)
        {
            FacesMessageUtil.addWarnMessage("invalid.portlet.parameter");
        }
        else
        {
            try
            {
                portletDeploymentService.deploy(this);
                FacesMessageUtil
                        .addInfoMessage("started.portlet.application.deployment");
            }
            catch (PALAdminException e)
            {
                FacesMessageUtil
                        .addErrorMessage("failed.to.start.portlet.application.deployment");
            }
        }
        return RemotePortletListPage.class;
    }

    public boolean isComeFromList()
    {
        return getCrudType() == CrudType.READ
                || getCrudType() == CrudType.DELETE;
    }

}
