/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.util;

import javax.faces.context.FacesContext;

import jp.sf.pal.admin.PALAdminConstants;

import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.deployment.DeploymentManager;
import org.apache.jetspeed.factory.PortletFactory;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.RoleManager;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.jetspeed.security.SecurityProvider;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.tools.pamanager.servletcontainer.ApplicationServerManager;

public class PortalComponentUtil {
    /**
     * @return the facesContext
     */
    private static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static UserManager getUserManager() {
        return (UserManager) getFacesContext().getExternalContext()
                .getRequestMap().get(PALAdminConstants.USER_MANAGER_COMPONENT);
    }

    public static RoleManager getRoleManager() {
        return (RoleManager) getFacesContext().getExternalContext()
                .getRequestMap().get(PALAdminConstants.ROLE_MANAGER_COMPONENT);
    }

    public static GroupManager getGroupManager() {
        return (GroupManager) getFacesContext().getExternalContext()
                .getRequestMap().get(PALAdminConstants.GROUP_MANAGER_COMPONENT);
    }

    public static Profiler getProfiler() {
        return (Profiler) getFacesContext().getExternalContext()
                .getRequestMap().get(PALAdminConstants.PROFILER_COMPONENT);
    }

    public static PageManager getPageManager() {
        return (PageManager) getFacesContext().getExternalContext()
                .getRequestMap().get(PALAdminConstants.PAGE_MANAGER_COMPONENT);
    }

    public static SecurityProvider getSecurityProvider() {
        return (SecurityProvider) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.SECURITY_PROVIDER_COMPONENT);
    }

    public static ApplicationServerManager getApplicationServerManager() {
        return (ApplicationServerManager) getFacesContext()
                .getExternalContext().getRequestMap().get(
                        PALAdminConstants.APPLICATION_SERVER_MANAGER_COMPONENT);
    }

    public static PortletRegistry getPortletRegistry() {
        return (PortletRegistry) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.PORTLET_REGISTRY_COMPONENT);
    }

    public static PortletFactory getPortletFactory() {
        return (PortletFactory) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.PORTLET_FACTORY_COMPONENT);
    }

    public static DeploymentManager getDeploymentManager() {
        return (DeploymentManager) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.DEPLOYMENT_MANAGER_COMPONENT);
    }

    public static PortalAdministration getPortalAdministration() {
        return (PortalAdministration) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.PORTAL_ADMINISTRATION_COMPONENT);
    }

    public static DecorationFactory getDecorationFactory() {
        return (DecorationFactory) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.DECORATION_FACTORY_COMPONENT);
    }

    public static PermissionManager getPermissionManager() {
        return (PermissionManager) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.PERMISSION_MANAGER_COMPONENT);
    }

    public static PortletEntityAccessComponent getPortletEntityAccessComponent() {
        return (PortletEntityAccessComponent) getFacesContext()
                .getExternalContext().getRequestMap().get(
                        PALAdminConstants.PORTLET_ENTITY_ACCESS_COMPONENT);
    }

    public static PortletWindowAccessor getPortletWindowAccessor() {
        return (PortletWindowAccessor) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.PORTLET_WINDOW_ACCESSOR_COMPONENT);
    }

    public static SecurityAccessController getSecurityAccessController() {
        return (SecurityAccessController) getFacesContext().getExternalContext()
                .getRequestMap().get(
                        PALAdminConstants.SECURITY_ACCESS_CONTROLLER_COMPONENT);
    }
}
