package jp.sf.pal.admin.service;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

import jp.sf.pal.admin.PALAdminConstants;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.util.PortalComponentUtil;
import jp.sf.pal.admin.util.UserRegistrationUtil;
import jp.sf.pal.admin.web.registration.AbstractForgottenPasswordPage;
import jp.sf.pal.admin.web.registration.AbstractPublicPortalRegistrationPage;
import jp.sf.pal.admin.web.registration.PublicPortalRegistrationUpdatePage;
import jp.sf.pal.admin.web.registration.PublicPortalSecretAnswerPage;
import jp.sf.pal.admin.web.registration.AbstractResetPasswordPage;
import jp.sf.pal.admin.web.registration.AbstractUserRegistrationPage;
import jp.sf.pal.common.CommonException;

import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.PortalReservedParameters;
import org.apache.jetspeed.administration.AdministrationEmailException;
import org.apache.jetspeed.administration.RegistrationException;
import org.apache.jetspeed.locator.JetspeedTemplateLocator;
import org.apache.jetspeed.locator.LocatorDescriptor;
import org.apache.jetspeed.locator.TemplateDescriptor;
import org.apache.jetspeed.locator.TemplateLocatorException;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.page.FolderNotUpdatedException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserPrincipal;
import org.seasar.teeda.extension.util.LabelHelper;

public class UserRegistrationService implements Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 2841077517815298990L;

    private static final String PATH_SEPARATOR = "/";

    private static final String EMAIL_SUBJECT_USER_REGISTRATION = "email.subject.registration";

    private static final String EMAIL_SUBJECT_FORGOTTEN_PASSWORD = "email.subject.forgotten.password";

    private static final String CTX_NEW_PASSWORD = "password";

    private static final String CTX_USER_NAME = "username";

    private static final String CTX_RETURN_URL = "returnURL";

    public String getMessageDigest(String str) throws CommonException {
        if (str == null) {
            str = "";
        }
        // TODO move following params to portlet.xml
        String algorithm = "MD5";
        String encoding = "UTF-8";
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(str.getBytes(encoding));
            byte[] digest = md.digest();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < digest.length; i++) {
                int val = digest[i] & 0xFF;
                if (val < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toString(val, 16));
            }
            return buf.toString();
        } catch (NoSuchAlgorithmException e) {
            throw new CommonException("could.not.encode.secret.password",
                    "Could not encode secret password", e);
        } catch (UnsupportedEncodingException e) {
            throw new CommonException("could.not.encode.secret.password",
                    "Could not encode secret password", e);
        }
    }

    public void register(AbstractUserRegistrationPage page)
            throws CommonException {

        if (!UserRegistrationUtil
                .getBoolean(PALAdminConstants.FORCE_GENERATED_PASSWORD)) {
            if (page.getPassword() == null || page.getPassword().equals("")) {
                throw new CommonException("error.lacking.password",
                        "The password is null.");
            }
        }

        if (UserRegistrationUtil
                .getBoolean(PALAdminConstants.FORCE_USE_EMAIL_AS_USERNAME)) {
            // force user.name to be same as email
            page.setUserName(page.getUserBusinessInfoOnlineEmail());
        }

        boolean userIdExistsFlag = true;
        try {
            PortalComponentUtil.getUserManager().getUser(page.getUserName());
        } catch (org.apache.jetspeed.security.SecurityException e) {
            userIdExistsFlag = false;
        }

        if (userIdExistsFlag) {
            throw new CommonException("error.userid_already_exists",
                    "The user id already exists.");
        }

        if (UserRegistrationUtil
                .getBoolean(PALAdminConstants.FORCE_UNIQUE_EMAIL)) {
            boolean emailExistsFlag = true;
            User user = null;
            try {
                user = PortalComponentUtil.getPortalAdministration()
                        .lookupUserFromEmail(
                                page.getUserBusinessInfoOnlineEmail());
            } catch (AdministrationEmailException e) {
                emailExistsFlag = false;
            }
            if ((emailExistsFlag) || (user != null)) {
                throw new CommonException("error.email_already_exists",
                        "The email already exists.");
            }

        }

        if (UserRegistrationUtil
                .getBoolean(PALAdminConstants.FORCE_GENERATED_PASSWORD)) {
            try {
                String password = PortalComponentUtil.getPortalAdministration()
                        .generatePassword();
                page.setPassword(password);
            } catch (Exception e) {
                throw new CommonException("error.failed_to_add",
                        "Could not create password.", e);
            }
        } else {
            if (!page.getPassword().equals(page.getVerifyPassword())) {
                throw new CommonException("error.two_passwords_do_not_match",
                        "Two passwords do not match.");
            }
        }

        // we think we're good to go, let's create the user!
        Map<String, String> userInfo = createUserInfoMap(page);

        try {
            PortalComponentUtil.getPortalAdministration()
                    .registerUser(
                            page.getUserName(),
                            page.getPassword(),
                            UserRegistrationUtil
                                    .getStringList(PALAdminConstants.ROLES),
                            UserRegistrationUtil
                                    .getStringList(PALAdminConstants.GROUPS),
                            userInfo, // note use of only
                            // PLT.D values here.
                            UserRegistrationUtil
                                    .getStringMap(PALAdminConstants.RULES),
                            PALAdminConstants.DEFAULT_USER_TEMPLATE_FOLDER); // TODO default template path
        } catch (RegistrationException e) {
            throw new CommonException("error.failed_to_add",
                    "Could not register a user.", e);
        }

        // set security constraint
        String userhome = Folder.USER_FOLDER + page.getUserName();
        PageManager pageManager = PortalComponentUtil.getPageManager();
        SecurityConstraint sc = pageManager.newPageSecurityConstraint();
        sc.setUsers(PALAdminUtil.parseCSVList(page.getUserName()));
        List<String> permissions = new ArrayList<String>();
        permissions.add(JetspeedActions.VIEW);
        permissions.add(JetspeedActions.EDIT);
        permissions.add(JetspeedActions.HELP);
        sc.setPermissions(permissions);
        Folder userFolder;
        try {
            userFolder = pageManager.getFolder(userhome);
        } catch (FolderNotFoundException e) {
            throw new CommonException("could.not.access.folder",
                    "Could not access a folder: " + userhome, e);
        } catch (InvalidFolderException e) {
            throw new CommonException("could.not.access.folder",
                    "Could not access a folder: " + userhome, e);
        } catch (NodeException e) {
            throw new CommonException("could.not.access.folder",
                    "Could not access a folder: " + userhome, e);
        }
        if (userFolder.getSecurityConstraints() == null) {
            userFolder.setSecurityConstraints(pageManager
                    .newSecurityConstraints());
        }
        userFolder.getSecurityConstraints().getSecurityConstraints().add(sc);
        try {
            pageManager.updateFolder(userFolder);
            pageManager.reset();
        } catch (FolderNotUpdatedException e) {
            //TODO remove user
            throw new CommonException("could.not.update.folder",
                    "Could not update a folder: " + userFolder.getPath(), e);
        } catch (NodeException e) {
            //TODO remove user
            throw new CommonException("could.not.update.folder",
                    "Could not update a folder: " + userFolder.getPath(), e);
        }

        // template
        String templ = getTemplatePath(page.getFacesContext());

        if (templ == null) {
            throw new CommonException(
                    "error.registration_completed_but_could_not_send",
                    "Email template is not available.");
        }

        if (UserRegistrationUtil.getBoolean(PALAdminConstants.SEND_MAIL)) {
            if (page.getPassword() != null) {
                userInfo.put("password", page.getPassword());
            }

            try {
                PortalComponentUtil.getPortalAdministration().sendEmail(
                        (PortletConfig) page.getFacesContext()
                                .getExternalContext().getRequestMap().get(
                                        "javax.portlet.PortletConfig"),
                        page.getUserBusinessInfoOnlineEmail(),
                        getUserRegistrationEmailSubject(page.getLabelHelper()),
                        templ, userInfo);
            } catch (AdministrationEmailException e) {
                throw new CommonException(
                        "error.registration_completed_but_could_not_send",
                        "Could not send a registration mail.", e);
            }
        }

    }

    public void setSecretQuestion(PublicPortalSecretAnswerPage page)
            throws CommonException {
        User user = null;
        try {
            user = PortalComponentUtil.getPortalAdministration()
                    .lookupUserFromEmail(page.getEmail());
        } catch (Exception e) {
            page.setUserSecretQuestion(page.getLabelHelper().getLabelValue(
                    "secretQuestion.1"));
            throw new CommonException("forgotten.email_address_not_found",
                    "The email is not found..", e);
        }

        page.setUserSecretQuestion(user.getUserAttributes().get(
                "user.secret.question", "-"));
    }

    public boolean checkSecretAnswer(PublicPortalSecretAnswerPage page)
            throws CommonException {
        User user = null;
        try {
            user = PortalComponentUtil.getPortalAdministration()
                    .lookupUserFromEmail(page.getEmail());
        } catch (Exception e) {
            throw new CommonException("forgotten.email_address_not_found",
                    "The email is not found..", e);
        }

        String userSecretAnswer = user.getUserAttributes().get(
                "user.secret.answer", "");
        if (userSecretAnswer.equals(page.getUserSecretAnswer())) {
            return true;
        } else if (page.getUserSecretAnswer() == null
                && userSecretAnswer.equals("")) {
            return true;
        }
        return false;
    }

    public void sendNewPassword(AbstractForgottenPasswordPage page)
            throws CommonException {

        User user = null;
        try {
            user = PortalComponentUtil.getPortalAdministration()
                    .lookupUserFromEmail(page.getEmail());
        } catch (Exception e) {
            throw new CommonException("forgotten.email_address_not_found",
                    "The email is not found..", e);
        }

        String userName = getUserName(user);

        String newPassword = PortalComponentUtil.getPortalAdministration()
                .generatePassword();

        Map<String, String> userAttributes = new HashMap<String, String>();
        try {
            Preferences pref = user.getUserAttributes();
            String[] keys = pref.keys();
            if (keys != null) {
                for (int ix = 0; ix < keys.length; ix++) {
                    // TODO: how the hell do i tell the pref type
                    // ASSuming they are all strings (sigh)
                    userAttributes.put(keys[ix], pref.get(keys[ix], ""));
                }
            }
        } catch (BackingStoreException e) {
            throw new CommonException("failed_to_send",
                    "Could not access preferences. ", e);
        }

        String urlGUID = makeGUID(userName, newPassword);

        // special attributes
        userAttributes.put(CTX_RETURN_URL, generateReturnURL(page
                .getFacesContext(), urlGUID));
        userAttributes.put(CTX_NEW_PASSWORD, newPassword);
        userAttributes.put(CTX_USER_NAME, userName);

        String templ = getTemplatePath(page.getFacesContext());

        if (templ == null) {
            throw new CommonException("failed_to_send",
                    "Email template is not available.");
        }

        try {
            PortalComponentUtil.getPortalAdministration()
                    .sendEmail(
                            (PortletConfig) page.getFacesContext()
                                    .getExternalContext().getRequestMap().get(
                                            "javax.portlet.PortletConfig"),
                            page.getEmail(),
                            getForgottenPasswordEmailSubject(page
                                    .getLabelHelper()), templ, userAttributes);
        } catch (AdministrationEmailException e) {
            throw new CommonException("failed_to_send",
                    "Could not send a mail.", e);
        }

        //TODO this is currently hacked with a hash map... needs to move to either a DB table
        // or to some sort of credential
        Map<String, String> map = new HashMap<String, String>();
        map.put("user.name", userName);
        map.put("password", newPassword);
        PortalComponentUtil.getPortalAdministration().putNewLoginInfo(urlGUID,
                map);

    }

    public void updatePassword(AbstractResetPasswordPage page)
            throws CommonException {
        Map map = PortalComponentUtil.getPortalAdministration()
                .getNewLoginInfo(page.getGuid());
        if (map == null) {
            throw new CommonException("forgotten.unable_to_update_pw",
                    "The login info is null. ");
        }
        String userName = (String) map.get("user.name");
        String newPassword = (String) map.get("password");

        // Here's where a break should be.   The following code should be put into the RETURN portlet
        try {
            PortalComponentUtil.getUserManager().setPassword(userName, null,
                    newPassword);
            PortalComponentUtil.getUserManager().setPasswordUpdateRequired(
                    userName, true);
        } catch (SecurityException e) {
            throw new CommonException("forgotten.unable_to_update_pw",
                    "Could not update a password.", e);
        }
        // if we got here stuff is changed... removed the key from the map
        PortalComponentUtil.getPortalAdministration().removeNewLoginInfo(
                page.getGuid());
    }

    protected String getTemplatePath(FacesContext facesContext) {
        JetspeedTemplateLocator templateLocator = UserRegistrationUtil
                .getTemplateLocator();
        String templateLocation = UserRegistrationUtil
                .getString(PALAdminConstants.EMAIL_TEMPLATE_LOCATION);
        String templateName = UserRegistrationUtil
                .getString(PALAdminConstants.EMAIL_TEMPLATE_NAME);
        if (templateLocator == null) {
            return templateLocation + PATH_SEPARATOR + templateName;
        }

        RequestContext requestContext = (RequestContext) facesContext
                .getExternalContext().getRequestMap().get(
                        PortalReservedParameters.REQUEST_CONTEXT_ATTRIBUTE);
        Locale locale = facesContext.getViewRoot().getLocale();

        try {
            LocatorDescriptor locator = templateLocator
                    .createLocatorDescriptor("email");
            locator.setName(templateName);
            locator.setMediaType(requestContext.getMediaType());
            locator.setLanguage(locale.getLanguage());
            locator.setCountry(locale.getCountry());
            TemplateDescriptor template = templateLocator
                    .locateTemplate(locator);

            return template.getAppRelativePath();
        } catch (TemplateLocatorException e) {
            return templateLocation + PATH_SEPARATOR + templateName;
        }
    }

    protected String getUserRegistrationEmailSubject(LabelHelper labelHelper) {
        String emailSubject = labelHelper
                .getLabelValue(EMAIL_SUBJECT_USER_REGISTRATION);
        if (emailSubject == null)
            emailSubject = "Registration Confirmation";
        return emailSubject;
    }

    protected String getForgottenPasswordEmailSubject(LabelHelper labelHelper) {
        String emailSubject = labelHelper
                .getLabelValue(EMAIL_SUBJECT_FORGOTTEN_PASSWORD);
        if (emailSubject == null)
            emailSubject = "Password Notification";
        return emailSubject;

    }

    protected String getUserName(User user) {
        Principal principal = null;
        Iterator principals = user.getSubject().getPrincipals().iterator();
        while (principals.hasNext()) {
            Object o = principals.next();
            if (o instanceof UserPrincipal) {
                principal = (Principal) o;
                return principal.toString();
            }

        }
        return null;
    }

    protected String makeGUID(String user, String newpw) {
        // This is a quicky version
        long num = (long) user.hashCode() + (long) newpw.hashCode(); //  Possible collisions here...
        long d = new Date().getTime();
        long val = num * d;
        String retval = Long.toHexString(val);
        return retval;
    }

    protected String generateReturnURL(FacesContext facesContext, String urlGUID) {
        String fullPath = UserRegistrationUtil
                .getString(PALAdminConstants.RETURN_PATH)
                + "?guid=" + urlGUID;
        // NOTE: getPortalURL will encode the fullPath for us
        String url = PortalComponentUtil.getPortalAdministration()
                .getPortalURL(
                        (PortletRequest) facesContext.getExternalContext()
                                .getRequest(),
                        (PortletResponse) facesContext.getExternalContext()
                                .getResponse(), fullPath);
        return url;
    }

    public void loadPage(PublicPortalRegistrationUpdatePage page)
            throws CommonException {
        Principal userPrincipal = FacesContext.getCurrentInstance()
                .getExternalContext().getUserPrincipal();
        if (userPrincipal == null) {
            throw new CommonException("could.not.find.your.credential",
                    "User principal is null.");
        }

        User user;
        try {
            user = PortalComponentUtil.getUserManager().getUser(
                    userPrincipal.getName());
            if (user == null) {
                throw new CommonException("could.not.find.your.account",
                        "User is null.");
            }
        } catch (SecurityException e) {
            throw new CommonException("could.not.find.your.account",
                    "User is null.", e);
        }

        Preferences userAttributes = user.getUserAttributes();
        updateUserInfo(page, userAttributes);
    }

    public void update(PublicPortalRegistrationUpdatePage page)
            throws CommonException {
        Principal userPrincipal = page.getFacesContext().getExternalContext()
                .getUserPrincipal();
        if (userPrincipal == null) {
            throw new CommonException("could.not.find.your.credential",
                    "User principal is null.");
        }

        if (page.getPassword() != null && !page.getPassword().equals("")) {
            if (page.getPassword().equals(page.getVerifyPassword())) {
                try {
                    PortalComponentUtil.getUserManager().setPassword(
                            userPrincipal.getName(), null, page.getPassword());
                } catch (SecurityException e) {
                    throw new CommonException("could.not.update.password",
                            "Could not update a password.", e);
                }
            } else {
                throw new CommonException("could.not.match.passwords",
                        "Could not match passwords.");
            }
        }

        User user;
        try {
            user = PortalComponentUtil.getUserManager().getUser(
                    userPrincipal.getName());
            if (user == null) {
                throw new CommonException("could.not.find.your.account",
                        "User is null.");
            }
        } catch (SecurityException e) {
            throw new CommonException("could.not.find.your.account",
                    "User is null.", e);
        }

        Preferences userAttributes = user.getUserAttributes();
        Map<String, String> userInfo = createUserInfoMap(page);
        for (Iterator<Map.Entry<String, String>> ite = userInfo.entrySet()
                .iterator(); ite.hasNext();) {
            Map.Entry<String, String> entry = ite.next();
            userAttributes.put(entry.getKey(), entry.getValue());
        }

    }

    protected void updateUserInfo(AbstractUserRegistrationPage page,
            Preferences userAttributes) {
        if (userAttributes.get("user.business-info.online.email", null) != null) {
            page.setUserBusinessInfoOnlineEmail(userAttributes.get(
                    "user.business-info.online.email", ""));
        }
        if (userAttributes.get("user.name", null) != null) {
            page.setUserName(userAttributes.get("user.name", ""));
        }
        if (userAttributes.get("user.bdate", null) != null) {
            page.setUserBdate(userAttributes.get("user.bdate", ""));
        }
        if (userAttributes.get("user.gender", null) != null) {
            page.setUserGender(userAttributes.get("user.gender", ""));
        }
        if (userAttributes.get("user.employer", null) != null) {
            page.setUserEmployer(userAttributes.get("user.employer", ""));
        }
        if (userAttributes.get("user.department", null) != null) {
            page.setUserDepartment(userAttributes.get("user.department", ""));
        }
        if (userAttributes.get("user.jobtitle", null) != null) {
            page.setUserJobtitle(userAttributes.get("user.jobtitle", ""));
        }
        if (userAttributes.get("user.name.prefix", null) != null) {
            page.setUserNamePrefix(userAttributes.get("user.name.prefix", ""));
        }
        if (userAttributes.get("user.name.given", null) != null) {
            page.setUserNameGiven(userAttributes.get("user.name.given", ""));
        }
        if (userAttributes.get("user.name.family", null) != null) {
            page.setUserNameFamily(userAttributes.get("user.name.family", ""));
        }
        if (userAttributes.get("user.name.middle", null) != null) {
            page.setUserNameMiddle(userAttributes.get("user.name.middle", ""));
        }
        if (userAttributes.get("user.name.suffix", null) != null) {
            page.setUserNameSuffix(userAttributes.get("user.name.suffix", ""));
        }
        if (userAttributes.get("user.name.nickName", null) != null) {
            page.setUserNameNickName(userAttributes.get("user.name.nickName",
                    ""));
        }
        if (userAttributes.get("user.home-info.postal.name", null) != null) {
            page.setUserHomeInfoPostalName(userAttributes.get(
                    "user.home-info.postal.name", ""));
        }
        if (userAttributes.get("user.home-info.postal.street", null) != null) {
            page.setUserHomeInfoPostalStreet(userAttributes.get(
                    "user.home-info.postal.street", ""));
        }
        if (userAttributes.get("user.home-info.postal.city", null) != null) {
            page.setUserHomeInfoPostalCity(userAttributes.get(
                    "user.home-info.postal.city", ""));
        }
        if (userAttributes.get("user.home-info.postal.stateprov", null) != null) {
            page.setUserHomeInfoPostalStateprov(userAttributes.get(
                    "user.home-info.postal.stateprov", ""));
        }
        if (userAttributes.get("user.home-info.postal.postalcode", null) != null) {
            page.setUserHomeInfoPostalPostalcode(userAttributes.get(
                    "user.home-info.postal.postalcode", ""));
        }
        if (userAttributes.get("user.home-info.postal.country", null) != null) {
            page.setUserHomeInfoPostalCountry(userAttributes.get(
                    "user.home-info.postal.country", ""));
        }
        if (userAttributes.get("user.home-info.postal.organization", null) != null) {
            page.setUserHomeInfoPostalOrganization(userAttributes.get(
                    "user.home-info.postal.organization", ""));
        }
        if (userAttributes
                .get("user.home-info.telecom.telephone.intcode", null) != null) {
            page.setUserHomeInfoTelecomTelephoneIntcode(userAttributes.get(
                    "user.home-info.telecom.telephone.intcode", ""));
        }
        if (userAttributes
                .get("user.home-info.telecom.telephone.loccode", null) != null) {
            page.setUserHomeInfoTelecomTelephoneLoccode(userAttributes.get(
                    "user.home-info.telecom.telephone.loccode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.telephone.number", null) != null) {
            page.setUserHomeInfoTelecomTelephoneNumber(userAttributes.get(
                    "user.home-info.telecom.telephone.number", ""));
        }
        if (userAttributes.get("user.home-info.telecom.telephone.ext", null) != null) {
            page.setUserHomeInfoTelecomTelephoneExt(userAttributes.get(
                    "user.home-info.telecom.telephone.ext", ""));
        }
        if (userAttributes
                .get("user.home-info.telecom.telephone.comment", null) != null) {
            page.setUserHomeInfoTelecomTelephoneComment(userAttributes.get(
                    "user.home-info.telecom.telephone.comment", ""));
        }
        if (userAttributes.get("user.home-info.telecom.fax.intcode", null) != null) {
            page.setUserHomeInfoTelecomFaxIntcode(userAttributes.get(
                    "user.home-info.telecom.fax.intcode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.fax.loccode", null) != null) {
            page.setUserHomeInfoTelecomFaxLoccode(userAttributes.get(
                    "user.home-info.telecom.fax.loccode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.fax.number", null) != null) {
            page.setUserHomeInfoTelecomFaxNumber(userAttributes.get(
                    "user.home-info.telecom.fax.number", ""));
        }
        if (userAttributes.get("user.home-info.telecom.fax.ext", null) != null) {
            page.setUserHomeInfoTelecomFaxExt(userAttributes.get(
                    "user.home-info.telecom.fax.ext", ""));
        }
        if (userAttributes.get("user.home-info.telecom.fax.comment", null) != null) {
            page.setUserHomeInfoTelecomFaxComment(userAttributes.get(
                    "user.home-info.telecom.fax.comment", ""));
        }
        if (userAttributes.get("user.home-info.telecom.mobile.intcode", null) != null) {
            page.setUserHomeInfoTelecomMobileIntcode(userAttributes.get(
                    "user.home-info.telecom.mobile.intcode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.mobile.loccode", null) != null) {
            page.setUserHomeInfoTelecomMobileLoccode(userAttributes.get(
                    "user.home-info.telecom.mobile.loccode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.mobile.number", null) != null) {
            page.setUserHomeInfoTelecomMobileNumber(userAttributes.get(
                    "user.home-info.telecom.mobile.number", ""));
        }
        if (userAttributes.get("user.home-info.telecom.mobile.ext", null) != null) {
            page.setUserHomeInfoTelecomMobileExt(userAttributes.get(
                    "user.home-info.telecom.mobile.ext", ""));
        }
        if (userAttributes.get("user.home-info.telecom.mobile.comment", null) != null) {
            page.setUserHomeInfoTelecomMobileComment(userAttributes.get(
                    "user.home-info.telecom.mobile.comment", ""));
        }
        if (userAttributes.get("user.home-info.telecom.pager.intcode", null) != null) {
            page.setUserHomeInfoTelecomPagerIntcode(userAttributes.get(
                    "user.home-info.telecom.pager.intcode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.pager.loccode", null) != null) {
            page.setUserHomeInfoTelecomPagerLoccode(userAttributes.get(
                    "user.home-info.telecom.pager.loccode", ""));
        }
        if (userAttributes.get("user.home-info.telecom.pager.number", null) != null) {
            page.setUserHomeInfoTelecomPagerNumber(userAttributes.get(
                    "user.home-info.telecom.pager.number", ""));
        }
        if (userAttributes.get("user.home-info.telecom.pager.ext", null) != null) {
            page.setUserHomeInfoTelecomPagerExt(userAttributes.get(
                    "user.home-info.telecom.pager.ext", ""));
        }
        if (userAttributes.get("user.home-info.telecom.pager.comment", null) != null) {
            page.setUserHomeInfoTelecomPagerComment(userAttributes.get(
                    "user.home-info.telecom.pager.comment", ""));
        }
        if (userAttributes.get("user.home-info.online.email", null) != null) {
            page.setUserHomeInfoOnlineEmail(userAttributes.get(
                    "user.home-info.online.email", ""));
        }
        if (userAttributes.get("user.home-info.online.uri", null) != null) {
            page.setUserHomeInfoOnlineUri(userAttributes.get(
                    "user.home-info.online.uri", ""));
        }
        if (userAttributes.get("user.business-info.postal.name", null) != null) {
            page.setUserBusinessInfoPostalName(userAttributes.get(
                    "user.business-info.postal.name", ""));
        }
        if (userAttributes.get("user.business-info.postal.street", null) != null) {
            page.setUserBusinessInfoPostalStreet(userAttributes.get(
                    "user.business-info.postal.street", ""));
        }
        if (userAttributes.get("user.business-info.postal.city", null) != null) {
            page.setUserBusinessInfoPostalCity(userAttributes.get(
                    "user.business-info.postal.city", ""));
        }
        if (userAttributes.get("user.business-info.postal.stateprov", null) != null) {
            page.setUserBusinessInfoPostalStateprov(userAttributes.get(
                    "user.business-info.postal.stateprov", ""));
        }
        if (userAttributes.get("user.business-info.postal.postalcode", null) != null) {
            page.setUserBusinessInfoPostalPostalcode(userAttributes.get(
                    "user.business-info.postal.postalcode", ""));
        }
        if (userAttributes.get("user.business-info.postal.country", null) != null) {
            page.setUserBusinessInfoPostalCountry(userAttributes.get(
                    "user.business-info.postal.country", ""));
        }
        if (userAttributes.get("user.business-info.postal.organization", null) != null) {
            page.setUserBusinessInfoPostalOrganization(userAttributes.get(
                    "user.business-info.postal.organization", ""));
        }
        if (userAttributes.get("user.business-info.telecom.telephone.intcode",
                null) != null) {
            page.setUserBusinessInfoTelecomTelephoneIntcode(userAttributes.get(
                    "user.business-info.telecom.telephone.intcode", ""));
        }
        if (userAttributes.get("user.business-info.telecom.telephone.loccode",
                null) != null) {
            page.setUserBusinessInfoTelecomTelephoneLoccode(userAttributes.get(
                    "user.business-info.telecom.telephone.loccode", ""));
        }
        if (userAttributes.get("user.business-info.telecom.telephone.number",
                null) != null) {
            page.setUserBusinessInfoTelecomTelephoneNumber(userAttributes.get(
                    "user.business-info.telecom.telephone.number", ""));
        }
        if (userAttributes
                .get("user.business-info.telecom.telephone.ext", null) != null) {
            page.setUserBusinessInfoTelecomTelephoneExt(userAttributes.get(
                    "user.business-info.telecom.telephone.ext", ""));
        }
        if (userAttributes.get("user.business-info.telecom.telephone.comment",
                null) != null) {
            page.setUserBusinessInfoTelecomTelephoneComment(userAttributes.get(
                    "user.business-info.telecom.telephone.comment", ""));
        }
        if (userAttributes.get("user.business-info.telecom.fax.intcode", null) != null) {
            page.setUserBusinessInfoTelecomFaxIntcode(userAttributes.get(
                    "user.business-info.telecom.fax.intcode", ""));
        }
        if (userAttributes.get("user.business-info.telecom.fax.loccode", null) != null) {
            page.setUserBusinessInfoTelecomFaxLoccode(userAttributes.get(
                    "user.business-info.telecom.fax.loccode", ""));
        }
        if (userAttributes.get("user.business-info.telecom.fax.number", null) != null) {
            page.setUserBusinessInfoTelecomFaxNumber(userAttributes.get(
                    "user.business-info.telecom.fax.number", ""));
        }
        if (userAttributes.get("user.business-info.telecom.fax.ext", null) != null) {
            page.setUserBusinessInfoTelecomFaxExt(userAttributes.get(
                    "user.business-info.telecom.fax.ext", ""));
        }
        if (userAttributes.get("user.business-info.telecom.fax.comment", null) != null) {
            page.setUserBusinessInfoTelecomFaxComment(userAttributes.get(
                    "user.business-info.telecom.fax.comment", ""));
        }
        if (userAttributes.get("user.business-info.telecom.mobile.intcode",
                null) != null) {
            page.setUserBusinessInfoTelecomMobileIntcode(userAttributes.get(
                    "user.business-info.telecom.mobile.intcode", ""));
        }
        if (userAttributes.get("user.business-info.telecom.mobile.loccode",
                null) != null) {
            page.setUserBusinessInfoTelecomMobileLoccode(userAttributes.get(
                    "user.business-info.telecom.mobile.loccode", ""));
        }
        if (userAttributes
                .get("user.business-info.telecom.mobile.number", null) != null) {
            page.setUserBusinessInfoTelecomMobileNumber(userAttributes.get(
                    "user.business-info.telecom.mobile.number", ""));
        }
        if (userAttributes.get("user.business-info.telecom.mobile.ext", null) != null) {
            page.setUserBusinessInfoTelecomMobileExt(userAttributes.get(
                    "user.business-info.telecom.mobile.ext", ""));
        }
        if (userAttributes.get("user.business-info.telecom.mobile.comment",
                null) != null) {
            page.setUserBusinessInfoTelecomMobileComment(userAttributes.get(
                    "user.business-info.telecom.mobile.comment", ""));
        }
        if (userAttributes
                .get("user.business-info.telecom.pager.intcode", null) != null) {
            page.setUserBusinessInfoTelecomPagerIntcode(userAttributes.get(
                    "user.business-info.telecom.pager.intcode", ""));
        }
        if (userAttributes
                .get("user.business-info.telecom.pager.loccode", null) != null) {
            page.setUserBusinessInfoTelecomPagerLoccode(userAttributes.get(
                    "user.business-info.telecom.pager.loccode", ""));
        }
        if (userAttributes.get("user.business-info.telecom.pager.number", null) != null) {
            page.setUserBusinessInfoTelecomPagerNumber(userAttributes.get(
                    "user.business-info.telecom.pager.number", ""));
        }
        if (userAttributes.get("user.business-info.telecom.pager.ext", null) != null) {
            page.setUserBusinessInfoTelecomPagerExt(userAttributes.get(
                    "user.business-info.telecom.pager.ext", ""));
        }
        if (userAttributes
                .get("user.business-info.telecom.pager.comment", null) != null) {
            page.setUserBusinessInfoTelecomPagerComment(userAttributes.get(
                    "user.business-info.telecom.pager.comment", ""));
        }
        if (userAttributes.get("user.business-info.online.uri", null) != null) {
            page.setUserBusinessInfoOnlineUri(userAttributes.get(
                    "user.business-info.online.uri", ""));
        }

        if (page instanceof PublicPortalRegistrationUpdatePage) {
            PublicPortalRegistrationUpdatePage p = (PublicPortalRegistrationUpdatePage) page;
            if (userAttributes.get("user.bdate.year", null) != null) {
                p.setUserBdateYear(userAttributes.getInt("user.bdate.year", 0));
            }
            if (userAttributes.get("user.bdate.month", null) != null) {
                p.setUserBdateMonth(userAttributes
                        .getInt("user.bdate.month", 0));
            }
            if (userAttributes.get("user.bdate.date", null) != null) {
                p.setUserBdateDate(userAttributes.getInt("user.bdate.date", 0));
            }
            if (userAttributes.get("user.industry", null) != null) {
                p.setUserIndustry(userAttributes.get("user.industry", ""));
            }
            if (userAttributes.get("user.secret.question", null) != null) {
                p.setUserSecretQuestion(userAttributes.get(
                        "user.secret.question", ""));
            }
            if (userAttributes.get("user.secret.answer", null) != null) {
                p.setUserSecretAnswer(userAttributes.get("user.secret.answer",
                        ""));
            }
            if (userAttributes.get("user.name.given.yomi", null) != null) {
                p.setUserNameGivenYomi(userAttributes.get(
                        "user.name.given.yomi", ""));
            }
            if (userAttributes.get("user.name.family.yomi", null) != null) {
                p.setUserNameFamilyYomi(userAttributes.get(
                        "user.name.family.yomi", ""));
            }
        }
    }

    protected Map<String, String> createUserInfoMap(
            AbstractUserRegistrationPage page) {
        Map<String, String> userInfo = new HashMap<String, String>();

        if (page.getUserBusinessInfoOnlineEmail() != null) {
            userInfo.put("user.business-info.online.email", page
                    .getUserBusinessInfoOnlineEmail());
        }
        if (page.getUserName() != null) {
            userInfo.put("user.name", page.getUserName());
        }
        if (page.getUserBdate() != null) {
            userInfo.put("user.bdate", page.getUserBdate());
        }
        if (page.getUserGender() != null) {
            userInfo.put("user.gender", page.getUserGender());
        }
        if (page.getUserEmployer() != null) {
            userInfo.put("user.employer", page.getUserEmployer());
        }
        if (page.getUserDepartment() != null) {
            userInfo.put("user.department", page.getUserDepartment());
        }
        if (page.getUserJobtitle() != null) {
            userInfo.put("user.jobtitle", page.getUserJobtitle());
        }
        if (page.getUserNamePrefix() != null) {
            userInfo.put("user.name.prefix", page.getUserNamePrefix());
        }
        if (page.getUserNameGiven() != null) {
            userInfo.put("user.name.given", page.getUserNameGiven());
        }
        if (page.getUserNameFamily() != null) {
            userInfo.put("user.name.family", page.getUserNameFamily());
        }
        if (page.getUserNameMiddle() != null) {
            userInfo.put("user.name.middle", page.getUserNameMiddle());
        }
        if (page.getUserNameSuffix() != null) {
            userInfo.put("user.name.suffix", page.getUserNameSuffix());
        }
        if (page.getUserNameNickName() != null) {
            userInfo.put("user.name.nickName", page.getUserNameNickName());
        }
        if (page.getUserHomeInfoPostalName() != null) {
            userInfo.put("user.home-info.postal.name", page
                    .getUserHomeInfoPostalName());
        }
        if (page.getUserHomeInfoPostalStreet() != null) {
            userInfo.put("user.home-info.postal.street", page
                    .getUserHomeInfoPostalStreet());
        }
        if (page.getUserHomeInfoPostalCity() != null) {
            userInfo.put("user.home-info.postal.city", page
                    .getUserHomeInfoPostalCity());
        }
        if (page.getUserHomeInfoPostalStateprov() != null) {
            userInfo.put("user.home-info.postal.stateprov", page
                    .getUserHomeInfoPostalStateprov());
        }
        if (page.getUserHomeInfoPostalPostalcode() != null) {
            userInfo.put("user.home-info.postal.postalcode", page
                    .getUserHomeInfoPostalPostalcode());
        }
        if (page.getUserHomeInfoPostalCountry() != null) {
            userInfo.put("user.home-info.postal.country", page
                    .getUserHomeInfoPostalCountry());
        }
        if (page.getUserHomeInfoPostalOrganization() != null) {
            userInfo.put("user.home-info.postal.organization", page
                    .getUserHomeInfoPostalOrganization());
        }
        if (page.getUserHomeInfoTelecomTelephoneIntcode() != null) {
            userInfo.put("user.home-info.telecom.telephone.intcode", page
                    .getUserHomeInfoTelecomTelephoneIntcode());
        }
        if (page.getUserHomeInfoTelecomTelephoneLoccode() != null) {
            userInfo.put("user.home-info.telecom.telephone.loccode", page
                    .getUserHomeInfoTelecomTelephoneLoccode());
        }
        if (page.getUserHomeInfoTelecomTelephoneNumber() != null) {
            userInfo.put("user.home-info.telecom.telephone.number", page
                    .getUserHomeInfoTelecomTelephoneNumber());
        }
        if (page.getUserHomeInfoTelecomTelephoneExt() != null) {
            userInfo.put("user.home-info.telecom.telephone.ext", page
                    .getUserHomeInfoTelecomTelephoneExt());
        }
        if (page.getUserHomeInfoTelecomTelephoneComment() != null) {
            userInfo.put("user.home-info.telecom.telephone.comment", page
                    .getUserHomeInfoTelecomTelephoneComment());
        }
        if (page.getUserHomeInfoTelecomFaxIntcode() != null) {
            userInfo.put("user.home-info.telecom.fax.intcode", page
                    .getUserHomeInfoTelecomFaxIntcode());
        }
        if (page.getUserHomeInfoTelecomFaxLoccode() != null) {
            userInfo.put("user.home-info.telecom.fax.loccode", page
                    .getUserHomeInfoTelecomFaxLoccode());
        }
        if (page.getUserHomeInfoTelecomFaxNumber() != null) {
            userInfo.put("user.home-info.telecom.fax.number", page
                    .getUserHomeInfoTelecomFaxNumber());
        }
        if (page.getUserHomeInfoTelecomFaxExt() != null) {
            userInfo.put("user.home-info.telecom.fax.ext", page
                    .getUserHomeInfoTelecomFaxExt());
        }
        if (page.getUserHomeInfoTelecomFaxComment() != null) {
            userInfo.put("user.home-info.telecom.fax.comment", page
                    .getUserHomeInfoTelecomFaxComment());
        }
        if (page.getUserHomeInfoTelecomMobileIntcode() != null) {
            userInfo.put("user.home-info.telecom.mobile.intcode", page
                    .getUserHomeInfoTelecomMobileIntcode());
        }
        if (page.getUserHomeInfoTelecomMobileLoccode() != null) {
            userInfo.put("user.home-info.telecom.mobile.loccode", page
                    .getUserHomeInfoTelecomMobileLoccode());
        }
        if (page.getUserHomeInfoTelecomMobileNumber() != null) {
            userInfo.put("user.home-info.telecom.mobile.number", page
                    .getUserHomeInfoTelecomMobileNumber());
        }
        if (page.getUserHomeInfoTelecomMobileExt() != null) {
            userInfo.put("user.home-info.telecom.mobile.ext", page
                    .getUserHomeInfoTelecomMobileExt());
        }
        if (page.getUserHomeInfoTelecomMobileComment() != null) {
            userInfo.put("user.home-info.telecom.mobile.comment", page
                    .getUserHomeInfoTelecomMobileComment());
        }
        if (page.getUserHomeInfoTelecomPagerIntcode() != null) {
            userInfo.put("user.home-info.telecom.pager.intcode", page
                    .getUserHomeInfoTelecomPagerIntcode());
        }
        if (page.getUserHomeInfoTelecomPagerLoccode() != null) {
            userInfo.put("user.home-info.telecom.pager.loccode", page
                    .getUserHomeInfoTelecomPagerLoccode());
        }
        if (page.getUserHomeInfoTelecomPagerNumber() != null) {
            userInfo.put("user.home-info.telecom.pager.number", page
                    .getUserHomeInfoTelecomPagerNumber());
        }
        if (page.getUserHomeInfoTelecomPagerExt() != null) {
            userInfo.put("user.home-info.telecom.pager.ext", page
                    .getUserHomeInfoTelecomPagerExt());
        }
        if (page.getUserHomeInfoTelecomPagerComment() != null) {
            userInfo.put("user.home-info.telecom.pager.comment", page
                    .getUserHomeInfoTelecomPagerComment());
        }
        if (page.getUserHomeInfoOnlineEmail() != null) {
            userInfo.put("user.home-info.online.email", page
                    .getUserHomeInfoOnlineEmail());
        }
        if (page.getUserHomeInfoOnlineUri() != null) {
            userInfo.put("user.home-info.online.uri", page
                    .getUserHomeInfoOnlineUri());
        }
        if (page.getUserBusinessInfoPostalName() != null) {
            userInfo.put("user.business-info.postal.name", page
                    .getUserBusinessInfoPostalName());
        }
        if (page.getUserBusinessInfoPostalStreet() != null) {
            userInfo.put("user.business-info.postal.street", page
                    .getUserBusinessInfoPostalStreet());
        }
        if (page.getUserBusinessInfoPostalCity() != null) {
            userInfo.put("user.business-info.postal.city", page
                    .getUserBusinessInfoPostalCity());
        }
        if (page.getUserBusinessInfoPostalStateprov() != null) {
            userInfo.put("user.business-info.postal.stateprov", page
                    .getUserBusinessInfoPostalStateprov());
        }
        if (page.getUserBusinessInfoPostalPostalcode() != null) {
            userInfo.put("user.business-info.postal.postalcode", page
                    .getUserBusinessInfoPostalPostalcode());
        }
        if (page.getUserBusinessInfoPostalCountry() != null) {
            userInfo.put("user.business-info.postal.country", page
                    .getUserBusinessInfoPostalCountry());
        }
        if (page.getUserBusinessInfoPostalOrganization() != null) {
            userInfo.put("user.business-info.postal.organization", page
                    .getUserBusinessInfoPostalOrganization());
        }
        if (page.getUserBusinessInfoTelecomTelephoneIntcode() != null) {
            userInfo.put("user.business-info.telecom.telephone.intcode", page
                    .getUserBusinessInfoTelecomTelephoneIntcode());
        }
        if (page.getUserBusinessInfoTelecomTelephoneLoccode() != null) {
            userInfo.put("user.business-info.telecom.telephone.loccode", page
                    .getUserBusinessInfoTelecomTelephoneLoccode());
        }
        if (page.getUserBusinessInfoTelecomTelephoneNumber() != null) {
            userInfo.put("user.business-info.telecom.telephone.number", page
                    .getUserBusinessInfoTelecomTelephoneNumber());
        }
        if (page.getUserBusinessInfoTelecomTelephoneExt() != null) {
            userInfo.put("user.business-info.telecom.telephone.ext", page
                    .getUserBusinessInfoTelecomTelephoneExt());
        }
        if (page.getUserBusinessInfoTelecomTelephoneComment() != null) {
            userInfo.put("user.business-info.telecom.telephone.comment", page
                    .getUserBusinessInfoTelecomTelephoneComment());
        }
        if (page.getUserBusinessInfoTelecomFaxIntcode() != null) {
            userInfo.put("user.business-info.telecom.fax.intcode", page
                    .getUserBusinessInfoTelecomFaxIntcode());
        }
        if (page.getUserBusinessInfoTelecomFaxLoccode() != null) {
            userInfo.put("user.business-info.telecom.fax.loccode", page
                    .getUserBusinessInfoTelecomFaxLoccode());
        }
        if (page.getUserBusinessInfoTelecomFaxNumber() != null) {
            userInfo.put("user.business-info.telecom.fax.number", page
                    .getUserBusinessInfoTelecomFaxNumber());
        }
        if (page.getUserBusinessInfoTelecomFaxExt() != null) {
            userInfo.put("user.business-info.telecom.fax.ext", page
                    .getUserBusinessInfoTelecomFaxExt());
        }
        if (page.getUserBusinessInfoTelecomFaxComment() != null) {
            userInfo.put("user.business-info.telecom.fax.comment", page
                    .getUserBusinessInfoTelecomFaxComment());
        }
        if (page.getUserBusinessInfoTelecomMobileIntcode() != null) {
            userInfo.put("user.business-info.telecom.mobile.intcode", page
                    .getUserBusinessInfoTelecomMobileIntcode());
        }
        if (page.getUserBusinessInfoTelecomMobileLoccode() != null) {
            userInfo.put("user.business-info.telecom.mobile.loccode", page
                    .getUserBusinessInfoTelecomMobileLoccode());
        }
        if (page.getUserBusinessInfoTelecomMobileNumber() != null) {
            userInfo.put("user.business-info.telecom.mobile.number", page
                    .getUserBusinessInfoTelecomMobileNumber());
        }
        if (page.getUserBusinessInfoTelecomMobileExt() != null) {
            userInfo.put("user.business-info.telecom.mobile.ext", page
                    .getUserBusinessInfoTelecomMobileExt());
        }
        if (page.getUserBusinessInfoTelecomMobileComment() != null) {
            userInfo.put("user.business-info.telecom.mobile.comment", page
                    .getUserBusinessInfoTelecomMobileComment());
        }
        if (page.getUserBusinessInfoTelecomPagerIntcode() != null) {
            userInfo.put("user.business-info.telecom.pager.intcode", page
                    .getUserBusinessInfoTelecomPagerIntcode());
        }
        if (page.getUserBusinessInfoTelecomPagerLoccode() != null) {
            userInfo.put("user.business-info.telecom.pager.loccode", page
                    .getUserBusinessInfoTelecomPagerLoccode());
        }
        if (page.getUserBusinessInfoTelecomPagerNumber() != null) {
            userInfo.put("user.business-info.telecom.pager.number", page
                    .getUserBusinessInfoTelecomPagerNumber());
        }
        if (page.getUserBusinessInfoTelecomPagerExt() != null) {
            userInfo.put("user.business-info.telecom.pager.ext", page
                    .getUserBusinessInfoTelecomPagerExt());
        }
        if (page.getUserBusinessInfoTelecomPagerComment() != null) {
            userInfo.put("user.business-info.telecom.pager.comment", page
                    .getUserBusinessInfoTelecomPagerComment());
        }
        if (page.getUserBusinessInfoOnlineUri() != null) {
            userInfo.put("user.business-info.online.uri", page
                    .getUserBusinessInfoOnlineUri());
        }

        if (page instanceof AbstractPublicPortalRegistrationPage) {
            AbstractPublicPortalRegistrationPage p = (AbstractPublicPortalRegistrationPage) page;
            if (p.getUserBdateYear() != null) {
                userInfo
                        .put("user.bdate.year", p.getUserBdateYear().toString());
            }
            if (p.getUserBdateMonth() != null) {
                userInfo.put("user.bdate.month", p.getUserBdateMonth()
                        .toString());
            }
            if (p.getUserBdateDate() != null) {
                userInfo
                        .put("user.bdate.date", p.getUserBdateDate().toString());
            }
            if (p.getUserIndustry() != null) {
                userInfo.put("user.industry", p.getUserIndustry());
            }
            if (p.getUserSecretQuestion() != null) {
                userInfo.put("user.secret.question", p.getUserSecretQuestion());
            }
            if (p.getUserSecretAnswer() != null) {
                if (!PALAdminConstants.SECRET_ANSWER_DISPLAY.equals(p
                        .getUserSecretAnswer())) {
                    userInfo.put("user.secret.answer", p.getUserSecretAnswer());
                }
            }
            if (p.getUserNameGivenYomi() != null) {
                userInfo.put("user.name.given.yomi", p.getUserNameGivenYomi());
            }
            if (p.getUserNameFamilyYomi() != null) {
                userInfo
                        .put("user.name.family.yomi", p.getUserNameFamilyYomi());
            }

        }
        return userInfo;
    }
}
