/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletConfig;
import javax.portlet.PortletException;

import jp.sf.pal.admin.PALAdminConstants;

import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class UserRegistrationFilter extends DefaultUserRegistrationFilter
        implements PortletFilter
{
    public UserRegistrationFilter()
    {
        super();
    }

    public void init(PortletFilterConfig filterConfig) throws PortletException
    {
        super.init(filterConfig);

        PortletConfig portletConfig = filterConfig.getPortletConfig();

        // roles
        List<String> roles = getInitParameterList(portletConfig,
                PALAdminConstants.ROLES);
        getUserRegistrationParams().put(PALAdminConstants.ROLES, roles);

        // groups
        List<String> groups = getInitParameterList(portletConfig,
                PALAdminConstants.GROUPS);
        getUserRegistrationParams().put(PALAdminConstants.GROUPS, groups);

        // rules (name,value pairs)
        List<String> names = getInitParameterList(portletConfig,
                PALAdminConstants.RULE_NAMES);
        List<String> values = getInitParameterList(portletConfig,
                PALAdminConstants.RULE_VALUES);
        Map<String, String> rules = new HashMap<String, String>();
        for (int ix = 0; ix < ((names.size() < values.size()) ? names.size()
                : values.size()); ix++)
        {
            rules.put(names.get(ix), values.get(ix));
        }
        getUserRegistrationParams().put(PALAdminConstants.RULES, rules);

        // user attributes ?

        Boolean forceGeneratedPasswords = Boolean
                .valueOf(
                        portletConfig
                                .getInitParameter(PALAdminConstants.FORCE_GENERATED_PASSWORD))
                .booleanValue();
        getUserRegistrationParams().put(
                PALAdminConstants.FORCE_GENERATED_PASSWORD,
                forceGeneratedPasswords);

        Boolean forceEmailAsUsername = Boolean
                .valueOf(
                        portletConfig
                                .getInitParameter(PALAdminConstants.FORCE_USE_EMAIL_AS_USERNAME))
                .booleanValue();
        getUserRegistrationParams().put(
                PALAdminConstants.FORCE_USE_EMAIL_AS_USERNAME,
                forceEmailAsUsername);

        Boolean forceEmailsToBeSystemUnique = Boolean
                .valueOf(
                        portletConfig
                                .getInitParameter(PALAdminConstants.FORCE_UNIQUE_EMAIL))
                .booleanValue();
        if (forceEmailAsUsername)
        {
            // just to be sure
            forceEmailsToBeSystemUnique = Boolean.TRUE;
        }
        getUserRegistrationParams().put(PALAdminConstants.FORCE_UNIQUE_EMAIL,
                forceEmailsToBeSystemUnique);

        Boolean sendMail = Boolean.valueOf(portletConfig
                .getInitParameter(PALAdminConstants.SEND_MAIL));
        getUserRegistrationParams().put(PALAdminConstants.SEND_MAIL, sendMail);
    }
}
