/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.filter;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.admin.PALAdminConstants;

import org.apache.jetspeed.CommonPortletServices;
import org.apache.jetspeed.components.portletentity.PortletEntityAccessComponent;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.container.window.PortletWindowAccessor;
import org.apache.jetspeed.decoration.DecorationFactory;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.profiler.Profiler;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.SecurityAccessController;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class SiteEditorFilter implements PortletFilter {
    private PageManager pageManager;

    private Profiler profiler;

    private DecorationFactory decorationFactory;

    private PortletRegistry portletRegistry;

    private PermissionManager permissionManager;

    private PortletEntityAccessComponent portletEntityAccessComponent;

    private PortletWindowAccessor portletWindowAccessor;

    private SecurityAccessController securityAccessController;

    public void destroy() {
        pageManager = null;
        profiler = null;
        decorationFactory = null;
        portletRegistry = null;
        permissionManager = null;
        portletEntityAccessComponent = null;
        portletWindowAccessor = null;
        securityAccessController = null;
    }

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        PortletConfig portletConfig = filterConfig.getPortletConfig();
        PortletContext portletContext = portletConfig.getPortletContext();

        // pageManager
        pageManager = (PageManager) portletContext
                .getAttribute(CommonPortletServices.CPS_PAGE_MANAGER_COMPONENT);
        if (null == pageManager) {
            throw new PortletException(
                    "Failed to find the Page Manager on portlet initialization");
        }

        // profiler
        profiler = (Profiler) portletContext
                .getAttribute(CommonPortletServices.CPS_PROFILER_COMPONENT);
        if (null == profiler) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }

        // decorationFactory
        decorationFactory = (DecorationFactory) portletContext
                .getAttribute(CommonPortletServices.CPS_DECORATION_FACTORY);
        if (null == decorationFactory) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }

        // portletRegistry
        portletRegistry = (PortletRegistry) portletContext
                .getAttribute(CommonPortletServices.CPS_REGISTRY_COMPONENT);
        if (null == portletRegistry) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }

        // permissionManager
        permissionManager = (PermissionManager) portletContext
                .getAttribute(CommonPortletServices.CPS_PERMISSION_MANAGER);
        if (null == permissionManager) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }

        // portletEntityAccessComponent
        portletEntityAccessComponent = (PortletEntityAccessComponent) portletContext
                .getAttribute(CommonPortletServices.CPS_ENTITY_ACCESS_COMPONENT);
        if (null == portletEntityAccessComponent) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }

        // portletWindowAccessor
        portletWindowAccessor = (PortletWindowAccessor) portletContext
                .getAttribute(CommonPortletServices.CPS_WINDOW_ACCESS_COMPONENT);
        if (null == portletWindowAccessor) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }

        // securityAccessController
        securityAccessController = (SecurityAccessController) portletContext
                .getAttribute(CommonPortletServices.CPS_SECURITY_ACCESS_CONTROLLER);
        if (null == securityAccessController) {
            throw new PortletException(
                    "Failed to find the Profiler on portlet initialization");
        }
    }

    public void processActionFilter(ActionRequest request,
            ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException {
        request.setAttribute(PALAdminConstants.PAGE_MANAGER_COMPONENT,
                pageManager);
        request.setAttribute(PALAdminConstants.PROFILER_COMPONENT, profiler);
        request.setAttribute(PALAdminConstants.DECORATION_FACTORY_COMPONENT,
                decorationFactory);
        request.setAttribute(PALAdminConstants.PORTLET_REGISTRY_COMPONENT,
                portletRegistry);
        request.setAttribute(PALAdminConstants.PERMISSION_MANAGER_COMPONENT,
                permissionManager);
        request.setAttribute(PALAdminConstants.PORTLET_ENTITY_ACCESS_COMPONENT,
                portletEntityAccessComponent);
        request.setAttribute(
                PALAdminConstants.PORTLET_WINDOW_ACCESSOR_COMPONENT,
                portletWindowAccessor);
        request.setAttribute(
                PALAdminConstants.SECURITY_ACCESS_CONTROLLER_COMPONENT,
                securityAccessController);

        chain.processActionFilter(request, response);
    }

    public void renderFilter(RenderRequest request, RenderResponse response,
            PortletFilterChain chain) throws PortletException, IOException {
        request.setAttribute(PALAdminConstants.PAGE_MANAGER_COMPONENT,
                pageManager);
        request.setAttribute(PALAdminConstants.PROFILER_COMPONENT, profiler);
        request.setAttribute(PALAdminConstants.DECORATION_FACTORY_COMPONENT,
                decorationFactory);
        request.setAttribute(PALAdminConstants.PORTLET_REGISTRY_COMPONENT,
                portletRegistry);
        request.setAttribute(PALAdminConstants.PERMISSION_MANAGER_COMPONENT,
                permissionManager);
        request.setAttribute(PALAdminConstants.PORTLET_ENTITY_ACCESS_COMPONENT,
                portletEntityAccessComponent);
        request.setAttribute(
                PALAdminConstants.PORTLET_WINDOW_ACCESSOR_COMPONENT,
                portletWindowAccessor);
        request.setAttribute(
                PALAdminConstants.SECURITY_ACCESS_CONTROLLER_COMPONENT,
                securityAccessController);

        chain.renderFilter(request, response);

    }

}
