/*
 * Copyright 2005-2007 Portal Application Laboratory and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.admin.filter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.admin.PALAdminConstants;

import org.apache.jetspeed.CommonPortletServices;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.locator.JetspeedTemplateLocator;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.security.UserManager;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class DefaultUserRegistrationFilter implements PortletFilter {
    private PageManager pageManager;

    private PortalAdministration portalAdministration;

    private UserManager userManager;

    private Map<String, Object> userRegistrationParams;

    public void destroy() {
        pageManager = null;
        portalAdministration = null;
        userManager = null;
        userRegistrationParams = null;
    }

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        PortletConfig portletConfig = filterConfig.getPortletConfig();
        PortletContext portletContext = portletConfig.getPortletContext();

        // pageManager
        pageManager = (PageManager) portletContext
                .getAttribute(CommonPortletServices.CPS_PAGE_MANAGER_COMPONENT);
        if (null == pageManager) {
            throw new PortletException(
                    "Failed to find the Page Manager on portlet initialization");
        }

        // portalAdministration
        portalAdministration = (PortalAdministration) portletContext
                .getAttribute(CommonPortletServices.CPS_PORTAL_ADMINISTRATION);
        if (portalAdministration == null) {
            throw new PortletException(
                    "Failed to find the `prtaon portlet initialization");
        }

        // userManager
        userManager = (UserManager) portletContext
                .getAttribute(CommonPortletServices.CPS_USER_MANAGER_COMPONENT);
        if (userManager == null) {
            throw new PortletException(
                    "Failed to find the User Manager on portlet initialization");
        }

        userRegistrationParams = new HashMap<String, Object>();

        String templateLocation = portletConfig
                .getInitParameter(PALAdminConstants.EMAIL_TEMPLATE_LOCATION);
        if (templateLocation == null) {
            templateLocation = PALAdminConstants.DEFAULT_TEMPLATE_LOCATION;
        }
        templateLocation = portletContext.getRealPath(templateLocation);
        userRegistrationParams.put(PALAdminConstants.EMAIL_TEMPLATE_LOCATION,
                templateLocation);

        String templateName = portletConfig
                .getInitParameter(PALAdminConstants.EMAIL_TEMPLATE_NAME);
        if (templateName == null) {
            templateName = PALAdminConstants.DEFAULT_TEMPLATE_NAME;
        }
        userRegistrationParams.put(PALAdminConstants.EMAIL_TEMPLATE_NAME,
                templateName);

        ArrayList<String> roots = new ArrayList<String>(1);
        roots.add(templateLocation);

        try {
            JetspeedTemplateLocator templateLocator = new JetspeedTemplateLocator(
                    roots, "email", portletContext.getRealPath("/"));
            templateLocator.start();
            userRegistrationParams.put(PALAdminConstants.TEMPLATE_LOCATOR,
                    templateLocator);
        } catch (FileNotFoundException e) {
            throw new PortletException("Could not start the template locator.",
                    e);
        }
    }

    public void processActionFilter(ActionRequest request,
            ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException {
        request.setAttribute(PALAdminConstants.PAGE_MANAGER_COMPONENT,
                pageManager);
        request.setAttribute(PALAdminConstants.PORTAL_ADMINISTRATION_COMPONENT,
                portalAdministration);
        request.setAttribute(PALAdminConstants.USER_MANAGER_COMPONENT,
                userManager);
        request.setAttribute(PALAdminConstants.USER_REGISTRATION_PARAMS,
                userRegistrationParams);

        chain.processActionFilter(request, response);
    }

    public void renderFilter(RenderRequest request, RenderResponse response,
            PortletFilterChain chain) throws PortletException, IOException {
        request.setAttribute(PALAdminConstants.PAGE_MANAGER_COMPONENT,
                pageManager);
        request.setAttribute(PALAdminConstants.PORTAL_ADMINISTRATION_COMPONENT,
                portalAdministration);
        request.setAttribute(PALAdminConstants.USER_MANAGER_COMPONENT,
                userManager);
        request.setAttribute(PALAdminConstants.USER_REGISTRATION_PARAMS,
                userRegistrationParams);

        chain.renderFilter(request, response);
    }

    protected List<String> getInitParameterList(PortletConfig portletConfig,
            String ipName) {
        String temp = portletConfig.getInitParameter(ipName);
        if (temp == null) {
            return new ArrayList<String>();
        }

        String[] temps = temp.split("\\,");
        for (int ix = 0; ix < temps.length; ix++) {
            temps[ix] = temps[ix].trim();
        }

        return Arrays.asList(temps);
    }

    /**
     * @return the portalAdministration
     */
    public PortalAdministration getPortalAdministration() {
        return portalAdministration;
    }

    /**
     * @param portalAdministration the portalAdministration to set
     */
    public void setPortalAdministration(
            PortalAdministration portalAdministration) {
        this.portalAdministration = portalAdministration;
    }

    /**
     * @return the userManager
     */
    public UserManager getUserManager() {
        return userManager;
    }

    /**
     * @param userManager the userManager to set
     */
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    /**
     * @return the userRegistrationParams
     */
    public Map<String, Object> getUserRegistrationParams() {
        return userRegistrationParams;
    }

    /**
     * @param userRegistrationParams the userRegistrationParams to set
     */
    public void setUserRegistrationParams(
            Map<String, Object> userRegistrationParams) {
        this.userRegistrationParams = userRegistrationParams;
    }

}