/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.jsf.filter;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import jp.sf.pal.jsf.multipart.MultipartPortletRequestWrapper;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class FileUploadPortletFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)FileUploadPortletFilter.class);
    private static final String UPLOAD_REPOSITORY_PATH = "uploadRepositoryPath";
    private static final String UPLOAD_THRESHOLD_SIZE = "uploadThresholdSize";
    private static final String UPLOAD_MAX_FILE_SIZE = "uploadMaxFileSize";
    private static final String MULTIPART_ENCODING = "multipartEncoding";
    private int uploadMaxFileSize = 0x6400000;
    private int uploadThresholdSize = 0x100000;
    private String uploadRepositoryPath = null;
    private String multipartEncoding = null;
    private PortletConfig portletConfig;

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing ExtensionsPortletFilter.");
        }
        this.setPortletConfig(filterConfig.getPortletConfig());
        String param = filterConfig.getInitParameter(UPLOAD_MAX_FILE_SIZE);
        this.uploadMaxFileSize = this.resolveSize(param, this.uploadMaxFileSize);
        param = filterConfig.getInitParameter(UPLOAD_THRESHOLD_SIZE);
        this.uploadThresholdSize = this.resolveSize(param, this.uploadThresholdSize);
        this.uploadRepositoryPath = filterConfig.getInitParameter(UPLOAD_REPOSITORY_PATH);
        this.multipartEncoding = filterConfig.getInitParameter(MULTIPART_ENCODING);
        if (log.isDebugEnabled()) {
            log.debug((Object)("uploadMaxFileSize=" + this.uploadMaxFileSize));
            log.debug((Object)("uploadThresholdSize=" + this.uploadThresholdSize));
            log.debug((Object)("uploadRepositoryPath=" + this.uploadRepositoryPath));
            log.debug((Object)("multipartEncoding=" + this.multipartEncoding));
        }
    }

    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called renderFilter.");
        }
        chain.renderFilter(request, response);
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called processActionFilter.");
        }
        if (PortletFileUpload.isMultipartContent((ActionRequest)request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ActionRequest is multipart content.");
            }
            if (this.multipartEncoding != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Mutlipart encoding is " + this.multipartEncoding));
                }
                request.setCharacterEncoding(this.multipartEncoding);
            }
            request = new MultipartPortletRequestWrapper(request, this.uploadMaxFileSize, this.uploadThresholdSize, this.uploadRepositoryPath);
        }
        chain.processActionFilter(request, response);
    }

    public void destroy() {
        this.uploadRepositoryPath = null;
        this.multipartEncoding = null;
        this.portletConfig = null;
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public boolean isValidContentType(String contentType) {
        return contentType.startsWith("text/html") || contentType.startsWith("text/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/xml");
    }
}

