/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.jsf.custom.fileupload;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.IgnoreAttribute;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jp.sf.pal.jsf.custom.fileupload.HtmlInputFileUpload;
import jp.sf.pal.jsf.custom.fileupload.UploadedFile;
import jp.sf.pal.jsf.custom.fileupload.UploadedFileDefaultFileImpl;
import jp.sf.pal.jsf.custom.fileupload.UploadedFileDefaultImplBase;
import jp.sf.pal.jsf.custom.fileupload.UploadedFileDefaultMemoryImpl;
import jp.sf.pal.jsf.multipart.MultipartRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlFileUploadRenderer
extends AbstractInputRenderer {
    private static final Log log = LogFactory.getLog((Class)HtmlFileUploadRenderer.class);
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlFileUploadRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("name");
        this.ignoreComponent.addAttributeName("type");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("styleClass");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlInputFileUploadEnd(context, (HtmlInputFileUpload)component);
    }

    protected void encodeHtmlInputFileUploadEnd(FacesContext context, HtmlInputFileUpload htmlInputFileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)htmlInputFileUpload);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"type", (Object)"file");
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)htmlInputFileUpload, (String)this.getIdForRender(context, (UIComponent)htmlInputFileUpload));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"name", (Object)htmlInputFileUpload.getClientId(context));
        UploadedFile value = (UploadedFile)ValueHolderUtil.getValue((UIComponent)htmlInputFileUpload);
        if (value != null && value.getName() != null) {
            writer.writeAttribute("value", (Object)value.getName(), null);
        }
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"autocomplete", (Object)htmlInputFileUpload.getAutocomplete());
        this.renderStyleClass(context, htmlInputFileUpload, writer);
        this.renderRemainAttributes((UIComponent)htmlInputFileUpload, writer, this.ignoreComponent);
        writer.endElement("input");
    }

    protected void renderStyleClass(FacesContext context, HtmlInputFileUpload htmlInputFileUpload, ResponseWriter writer) throws IOException {
        String styleClass = htmlInputFileUpload.getStyleClass();
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"styleClass", (Object)styleClass);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        Object request = context.getExternalContext().getRequest();
        if (!(request instanceof ServletRequest)) {
            ExternalContext externalContext = context.getExternalContext();
            Map fileItems = (Map)externalContext.getRequestMap().get("jp.sf.pal.jsf.uploadedFiles");
            FileItem fileItem = null;
            if (fileItems != null) {
                String paramName = component.getClientId(context);
                fileItem = (FileItem)fileItems.get(paramName);
            }
            if (fileItem != null) {
                try {
                    String implementation = ((HtmlInputFileUpload)component).getStorage();
                    UploadedFileDefaultImplBase upFile = implementation == null || "memory".equals(implementation) ? new UploadedFileDefaultMemoryImpl(fileItem) : new UploadedFileDefaultFileImpl(fileItem);
                    ((HtmlInputFileUpload)component).setSubmittedValue(upFile);
                    ((HtmlInputFileUpload)component).setValid(true);
                }
                catch (IOException ioe) {
                    log.error((Object)ioe);
                }
            }
            return;
        }
        if (context.getExternalContext().getRequest() instanceof ServletRequest) {
            String paramName;
            MultipartRequestWrapper mpReq;
            FileItem fileItem;
            ServletRequest multipartRequest = (ServletRequest)context.getExternalContext().getRequest();
            while (multipartRequest != null && !(multipartRequest instanceof MultipartRequestWrapper)) {
                if (multipartRequest instanceof HttpServletRequestWrapper) {
                    multipartRequest = ((HttpServletRequestWrapper)multipartRequest).getRequest();
                    continue;
                }
                multipartRequest = null;
            }
            if (multipartRequest != null && (fileItem = (mpReq = (MultipartRequestWrapper)multipartRequest).getFileItem(paramName = component.getClientId(context))) != null) {
                try {
                    String implementation = ((HtmlInputFileUpload)component).getStorage();
                    UploadedFileDefaultImplBase upFile = implementation == null || "memory".equals(implementation) ? new UploadedFileDefaultMemoryImpl(fileItem) : new UploadedFileDefaultFileImpl(fileItem);
                    ((HtmlInputFileUpload)component).setSubmittedValue(upFile);
                    ((HtmlInputFileUpload)component).setValid(true);
                }
                catch (IOException ioe) {
                    log.error((Object)ioe);
                }
            }
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UploadedFile file;
        if (submittedValue instanceof UploadedFile && (file = (UploadedFile)submittedValue).getName() != null && file.getName().length() > 0) {
            return file;
        }
        return null;
    }
}

