/*
 * Copyright 2004-2006 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wcm.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.common.util.DownloadUtil;
import jp.sf.pal.wcm.PALWcmConstants;
import jp.sf.pal.wcm.util.PALWcmUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author shinsuke
 *
 */
public class FileviewServlet extends HttpServlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(FileviewServlet.class);

    /**
     * Serial Version UID
     */
    private static final long serialVersionUID = -3615197107588820314L;

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        String namespace = req
                .getParameter(PALWcmConstants.NAMESPACE_SERVLET_PARAM);
        String type = req.getParameter(PALWcmConstants.TYPE_SERVLET_PARAM);
        String name = req.getParameter(PALWcmConstants.NAME_SERVLET_PARAM);
        if (namespace == null || type == null || name == null)
        {
            resp.sendError(HttpServletResponse.SC_NOT_FOUND,
                    "namespace or path are null.");
            return;
        }

        String targetPath = PALWcmUtil.getBaseUploadDir(getServletContext())
                + "/" + namespace + "/" + type + "/" + name;
        File targetFile = new File(targetPath.replaceAll("\\.\\.", "")
                .replaceAll("/+", "/"));

        if (targetFile.exists())
        {
            // mime type
            String mimeType = DownloadUtil.getMimeType(getServletContext(),
                    name);
            if (mimeType == null)
            {
                mimeType = DownloadUtil.OCTET_STREAM;
            }
            // store
            InputStream is = null;
            try
            {
                is = new FileInputStream(targetFile);
                DownloadUtil.writeResponse(req, resp, mimeType, name, is);
            }
            catch (IOException e)
            {
                throw e;
            }
            finally
            {
                if (is != null)
                {
                    is.close();
                }
            }
        }
        else
        {
            resp.sendError(HttpServletResponse.SC_NOT_FOUND, targetPath
                    + " was not found.");
        }
    }

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        doGet(req, resp);
    }

}
