/*
 * Copyright 2004-2006 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wcm.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.wcm.PALWcmConstants;
import jp.sf.pal.wcm.util.PALWcmUtil;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author shinsuke
 *
 */
public class FileconnectorServlet extends HttpServlet
{

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(FileconnectorServlet.class);

    /**
     * Serial Version UID
     */
    private static final long serialVersionUID = -5882968603803293563L;

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        // check login
        //        if (req.getRemoteUser() == null)
        if (req.getSession().getAttribute(PALWcmConstants.LOGIN_USER_NAME) == null)
        {
            resp.sendError(HttpServletResponse.SC_FORBIDDEN,
                    "Please login to Portal.");
            return;
        }

        String command = req
                .getParameter(PALWcmConstants.COMMAND_FCKEDITOR_PARAM);
        if (PALWcmConstants.GET_FOLDERS_FCKEDITOR_ACTION.equals(command))
        {
            doGetFolders(req, resp);
        }
        else if (PALWcmConstants.GET_FOLDERS_AND_FILES_FCKEDITOR_ACTION
                .equals(command))
        {
            doGetFoldersAndFiles(req, resp);
        }
        else if (PALWcmConstants.CREATE_FOLDER_FCKEDITOR_ACTION.equals(command))
        {
            doCreateFolder(req, resp);
        }
        else
        {
            resp.sendError(HttpServletResponse.SC_BAD_REQUEST,
                    "Unknown action command. The command is " + command + ".");
            return;
        }
        resp.getWriter().flush();
    }

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        // check login
        //        if (req.getRemoteUser() == null)
        if (req.getSession().getAttribute(PALWcmConstants.LOGIN_USER_NAME) == null)
        {
            resp.sendError(HttpServletResponse.SC_FORBIDDEN,
                    "Please login to Portal.");
            return;
        }

        String command = req
                .getParameter(PALWcmConstants.COMMAND_FCKEDITOR_PARAM);
        if (PALWcmConstants.FILE_UPLOAD_FCKEDITOR_ACTION.equals(command))
        {
            // Fileupload
            doFileUpload(req, resp);
        }
        else
        {
            doGet(req, resp);
            return;
        }
        resp.getWriter().flush();
    }

    protected void doFileUpload(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        //      setHeader(resp);

        // check login
        //        if (req.getRemoteUser() == null)
        if (req.getSession().getAttribute(PALWcmConstants.LOGIN_USER_NAME) == null)
        {
            printFileUploadResponse(resp.getWriter(),
                    HttpServletResponse.SC_FORBIDDEN, "", "",
                    "Please login to Portal.");
            return;
        }

        // check namespace
        String namespace = req
                .getParameter(PALWcmConstants.NAMESPACE_SERVLET_PARAM);
        if (namespace == null)
        {
            printFileUploadResponse(resp.getWriter(),
                    HttpServletResponse.SC_BAD_REQUEST, "", "",
                    "Invalid parameters. You needs to specify a namespace.");
            return;
        }

        String type = req.getParameter(PALWcmConstants.TYPE_FCKEDITOR_PARAM);
        if (type == null)
        {
            printFileUploadResponse(resp.getWriter(),
                    HttpServletResponse.SC_BAD_REQUEST, "", "",
                    "Invalid parameters. You needs to specify a Type.");
            return;
        }

        String currentFolder = req
                .getParameter(PALWcmConstants.CURRENT_FOLDER_FCKEDITOR_PARAM);
        if (currentFolder == null)
        {
            printFileUploadResponse(resp.getWriter(),
                    HttpServletResponse.SC_BAD_REQUEST, "", "",
                    "Invalid parameters. You needs to specify a CurrentFolder.");
            return;
        }

        try
        {
            //          Create a factory for disk-based file items
            FileItemFactory factory = new DiskFileItemFactory();

            //             Create a new file upload handler
            ServletFileUpload upload = new ServletFileUpload(factory);

            //             Parse the request
            List /* FileItem */items = upload.parseRequest(req);

            Iterator ite = items.iterator();
            while (ite.hasNext())
            {
                FileItem item = (FileItem) ite.next();
                if (!item.isFormField())
                {
                    String clientFullFileName = item.getName();
                    clientFullFileName = clientFullFileName.replace('\\', '/');
                    String[] pathParts = clientFullFileName.split("/");
                    String fileName = pathParts[pathParts.length - 1];

                    String baseUploadDir = PALWcmUtil
                            .getBaseUploadDir(getServletContext());
                    PALWcmUtil.checkUploadDir(baseUploadDir, namespace, type);

                    String storeFileName = baseUploadDir + "/" + namespace
                            + "/" + type + "/" + currentFolder + "/" + fileName;
                    item.write(new File(storeFileName));

                    String fileUrl = req.getContextPath() + "/fileview?"
                            + PALWcmConstants.NAMESPACE_SERVLET_PARAM + "="
                            + namespace + "&"
                            + PALWcmConstants.TYPE_SERVLET_PARAM + "=" + type
                            + "&" + PALWcmConstants.NAME_SERVLET_PARAM + "="
                            + currentFolder + "/" + fileName;

                    printFileUploadResponse(resp.getWriter(), /*HttpServletResponse.SC_OK*/
                    0, fileUrl, fileName, "");
                    return;
                }
            }
        }
        catch (Exception e)
        {
            printFileUploadResponse(resp.getWriter(),
                    HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "", "",
                    "Internal server error. ");
            log.error("Internal server error.", e);
            return;
        }

        printFileUploadResponse(resp.getWriter(),
                HttpServletResponse.SC_SERVICE_UNAVAILABLE, "", "",
                "Could not find an upload file.");

    }

    protected void printFileUploadResponse(PrintWriter writer, int retVal,
            String fileUrl, String fileName, String errorMessage)
    {
        writer.print("<script type=\"text/javascript\">\n"
                + //
                "window.parent.frames['frmUpload'].OnUploadCompleted( "
                + retVal + ", '" + fileName + "') ;\n" + //
                "</script>\n");
        //        writer.print("<script type=\"text/javascript\">\n"
        //                + //
        //                "window.parent.frames['frmUpload'].OnUploadCompleted( "
        //                + retVal + ", '" + fileUrl + "', '" + fileName + "','"
        //                + errorMessage + "') ;\n" + //
        //                "</script>\n");
    }

    protected void doGetFolders(HttpServletRequest req, HttpServletResponse resp)
            throws ServletException, IOException
    {
        setHeader(resp);

        String command = req
                .getParameter(PALWcmConstants.COMMAND_FCKEDITOR_PARAM);
        String resourceType = req
                .getParameter(PALWcmConstants.TYPE_FCKEDITOR_PARAM);
        String currentFolder = req
                .getParameter(PALWcmConstants.CURRENT_FOLDER_FCKEDITOR_PARAM);
        String namespace = req
                .getParameter(PALWcmConstants.NAMESPACE_SERVLET_PARAM);
        if (resourceType == null || currentFolder == null || namespace == null)
        {
            printError(resp, HttpServletResponse.SC_BAD_REQUEST,
                    "Type, CurrentFolder or namespace are null.");
            return;
        }

        String folderUrl = req.getContextPath() + "/fileview?"
                + PALWcmConstants.NAMESPACE_SERVLET_PARAM + "=" + namespace
                + "&" + PALWcmConstants.TYPE_SERVLET_PARAM + "=" + resourceType
                + "&" + PALWcmConstants.NAME_SERVLET_PARAM + "="
                + currentFolder;

        printXMLHeader(resp, command, resourceType, currentFolder, folderUrl);

        String targetDir = PALWcmUtil.getBaseUploadDir(getServletContext())
                + "/" + namespace + "/" + resourceType + "/" + currentFolder;
        PrintWriter writer = resp.getWriter();
        writer.print("<Folders>");
        File dir = new File(targetDir.replaceAll("\\.\\.", "").replaceAll("/+",
                "/"));
        if (dir.exists())
        {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; i++)
            {
                if (files[i].isDirectory())
                {
                    writer.print("<Folder name=\""
                            + StringEscapeUtils.escapeXml(files[i].getName())
                            + "\" />");
                }
            }
        }
        writer.print("</Folders>");

        printXMLFooter(resp);
    }

    protected void doGetFoldersAndFiles(HttpServletRequest req,
            HttpServletResponse resp) throws ServletException, IOException
    {
        setHeader(resp);

        String command = req
                .getParameter(PALWcmConstants.COMMAND_FCKEDITOR_PARAM);
        String resourceType = req
                .getParameter(PALWcmConstants.TYPE_FCKEDITOR_PARAM);
        String currentFolder = req
                .getParameter(PALWcmConstants.CURRENT_FOLDER_FCKEDITOR_PARAM);
        String namespace = req
                .getParameter(PALWcmConstants.NAMESPACE_SERVLET_PARAM);
        if (resourceType == null || currentFolder == null || namespace == null)
        {
            printError(resp, HttpServletResponse.SC_BAD_REQUEST,
                    "Type, CurrentFolder or namespace are null.");
            return;
        }

        String folderUrl = req.getContextPath() + "/fileview?"
                + PALWcmConstants.NAMESPACE_SERVLET_PARAM + "=" + namespace
                + "&" + PALWcmConstants.TYPE_SERVLET_PARAM + "=" + resourceType
                + "&" + PALWcmConstants.NAME_SERVLET_PARAM + "="
                + currentFolder;

        printXMLHeader(resp, command, resourceType, currentFolder, folderUrl);

        String targetDir = PALWcmUtil.getBaseUploadDir(getServletContext())
                + "/" + namespace + "/" + resourceType + "/" + currentFolder;
        PrintWriter writer = resp.getWriter();
        writer.print("<Folders>");
        File dir = new File(targetDir.replaceAll("\\.\\.", "").replaceAll("/+",
                "/"));
        if (dir.exists())
        {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; i++)
            {
                if (files[i].isDirectory())
                {
                    writer.print("<Folder name=\""
                            + StringEscapeUtils.escapeXml(files[i].getName())
                            + "\" />");
                }
            }
        }
        writer.print("</Folders>");

        //TODO refactor
        writer.print("<Files>");
        if (dir.exists())
        {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; i++)
            {
                if (files[i].isFile())
                {
                    writer.print("<File name=\""
                            + StringEscapeUtils.escapeXml(files[i].getName())
                            + "\" size=\"" + files[i].length() + "\"/>");
                }
            }
        }
        writer.print("</Files>");

        printXMLFooter(resp);

    }

    protected void doCreateFolder(HttpServletRequest req,
            HttpServletResponse resp) throws ServletException, IOException
    {
        setHeader(resp);

        String command = req
                .getParameter(PALWcmConstants.COMMAND_FCKEDITOR_PARAM);
        String resourceType = req
                .getParameter(PALWcmConstants.TYPE_FCKEDITOR_PARAM);
        String currentFolder = req
                .getParameter(PALWcmConstants.CURRENT_FOLDER_FCKEDITOR_PARAM);
        String namespace = req
                .getParameter(PALWcmConstants.NAMESPACE_SERVLET_PARAM);
        String newFolderName = req
                .getParameter(PALWcmConstants.NEW_FOLDER_NAME_FCKEDITOR_PARAM);
        if (resourceType == null || currentFolder == null || namespace == null
                || newFolderName == null)
        {
            printError(resp, HttpServletResponse.SC_BAD_REQUEST,
                    "Type, CurrentFolder, namespace or NewFolderName are null.");
            return;
        }

        String baseUploadDir = PALWcmUtil.getBaseUploadDir(getServletContext());
        PALWcmUtil.checkUploadDir(baseUploadDir, namespace, resourceType);
        String targetDir = baseUploadDir + "/" + namespace + "/" + resourceType
                + "/" + currentFolder;
        File dir = new File(targetDir.replaceAll("\\.\\.", "").replaceAll("/+",
                "/"));
        if (dir.exists())
        {
            File newFolder = new File(dir, newFolderName);
            if (!newFolder.exists())
            {
                if (newFolder.mkdir())
                {
                    String folderUrl = req.getContextPath() + "/fileview?"
                            + PALWcmConstants.NAMESPACE_SERVLET_PARAM + "="
                            + namespace + "&"
                            + PALWcmConstants.TYPE_SERVLET_PARAM + "="
                            + resourceType + "&"
                            + PALWcmConstants.NAME_SERVLET_PARAM + "="
                            + currentFolder;

                    printXMLHeader(resp, command, resourceType, currentFolder,
                            folderUrl);
                    printXMLFooter(resp);
                }
                else
                {
                    printError(resp,
                            HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
                            "Could not create " + targetDir + ".");
                }
            }
            else
            {
                printError(resp, HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
                        targetDir + " exists.");
            }
        }

    }

    protected void setHeader(HttpServletResponse resp) throws ServletException,
            IOException
    {
        resp.setContentType("text/xml;charset=UTF-8");
        resp.setHeader("progma", "no-cache");
    }

    protected void printXMLHeader(HttpServletResponse resp, String command,
            String resourceType, String currentFolder, String folderUrl)
            throws ServletException, IOException
    {
        PrintWriter writer = resp.getWriter();
        writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        writer.print("<Connector command=\"" + command + "\" resourceType=\""
                + resourceType + "\">");
        writer.print("<CurrentFolder path=\"" + currentFolder + "\" url=\""
                + StringEscapeUtils.escapeXml(folderUrl) + "\"/>");
    }

    protected void printXMLFooter(HttpServletResponse resp)
            throws ServletException, IOException
    {
        PrintWriter writer = resp.getWriter();
        writer.print("</Connector>");
    }

    protected void printError(HttpServletResponse resp, int number, String text)
            throws ServletException, IOException
    {
        PrintWriter writer = resp.getWriter();
        writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        writer.print("<Connector><Error number=\"" + number + "\" text\""
                + StringEscapeUtils.escapeXml(text) + "\" /></Connector>");
    }

}
