/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.entity.PrincipalRule;
import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.web.AbstractCrudPage;

import org.seasar.framework.log.Logger;

public class UserProfilingRuleEditPage extends AbstractCrudPage implements
        Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = -863022117977960622L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserProfilingRuleEditPage.class);

    private String name;

    private List<Map<String, String>> newProfilingRuleNameItems;

    private int newProfilingRuleNameIndex;

    private String newProfilingRuleName;

    private List<Map<String, String>> newLocatorNameItems;

    private int newLocatorNameIndex;

    private String newLocatorName;

    private List<PrincipalRule> principalRulesItems;

    private String[] principalRules;

    private UserManagementService userManagementService;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public List<Map<String, String>> getNewProfilingRuleNameItems()
    {
        return newProfilingRuleNameItems;
    }

    public void setNewProfilingRuleNameItems(
            List<Map<String, String>> newProfilingRuleItems)
    {
        this.newProfilingRuleNameItems = newProfilingRuleItems;
    }

    public List<Map<String, String>> getNewLocatorNameItems()
    {
        return newLocatorNameItems;
    }

    public void setNewLocatorNameItems(
            List<Map<String, String>> newProfilingRuleTypeItems)
    {
        this.newLocatorNameItems = newProfilingRuleTypeItems;
    }

    public List<PrincipalRule> getPrincipalRulesItems()
    {
        return principalRulesItems;
    }

    public void setPrincipalRulesItems(List<PrincipalRule> profilingRulesItems)
    {
        this.principalRulesItems = profilingRulesItems;
    }

    /**
     * @return the newProfilingRuleName
     */
    public String getNewProfilingRuleName()
    {
        return newProfilingRuleName;
    }

    /**
     * @param newProfilingRuleName the newProfilingRuleName to set
     */
    public void setNewProfilingRuleName(String newProfilingRule)
    {
        this.newProfilingRuleName = newProfilingRule;
    }

    /**
     * @return the newProfilingRuleNameIndex
     */
    public int getNewProfilingRuleNameIndex()
    {
        return newProfilingRuleNameIndex;
    }

    /**
     * @param newProfilingRuleNameIndex the newProfilingRuleNameIndex to set
     */
    public void setNewProfilingRuleNameIndex(int newProfilingRuleIndex)
    {
        this.newProfilingRuleNameIndex = newProfilingRuleIndex;
    }

    /**
     * @return the newLocatorName
     */
    public String getNewLocatorName()
    {
        return newLocatorName;
    }

    /**
     * @param newLocatorName the newLocatorName to set
     */
    public void setNewLocatorName(String newProfilingRuleType)
    {
        this.newLocatorName = newProfilingRuleType;
    }

    /**
     * @return the newLocatorNameIndex
     */
    public int getNewLocatorNameIndex()
    {
        return newLocatorNameIndex;
    }

    /**
     * @param newLocatorNameIndex the newLocatorNameIndex to set
     */
    public void setNewLocatorNameIndex(int newProfilingRuleTypeIndex)
    {
        this.newLocatorNameIndex = newProfilingRuleTypeIndex;
    }

    /**
     * @return the profilingRules
     */
    public String[] getPrincipalRules()
    {
        return principalRules;
    }

    /**
     * @param profilingRules the profilingRules to set
     */
    public void setPrincipalRules(String[] profilingRules)
    {
        this.principalRules = profilingRules;
    }

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService()
    {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService)
    {
        this.userManagementService = userManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        // load page
        getUserManagementService().loadPage(this);

        return null;
    }

    public String doAddProfilingRule()
    {
        if (getName() == null || getNewLocatorName() == null
                || getNewProfilingRuleName() == null)
        {
            FacesMessageUtil
                    .addWarnMessage("invalid.profilingRule.or.user.name");
            return null;
        }

        try
        {
            getUserManagementService().addPrincipalRuleToUser(this);
            FacesMessageUtil.addInfoMessage("added.principalRule.to.user",
                    new Object[] { getName(), getNewLocatorName(),
                            getNewProfilingRuleName() });

            // clear
            setNewLocatorName(null);
            setNewProfilingRuleName(null);
        }
        catch (PALAdminException e)
        {
            FacesMessageUtil.addErrorMessage(
                    "failed.to.add.principalRule.to.user", new Object[] {
                            getName(), getNewLocatorName(),
                            getNewProfilingRuleName() });
            logger.error("Failed to add principalRule to user. user="
                    + getName() + ", principalRule=" + getNewLocatorName()
                    + "/" + getNewProfilingRuleName(), e);
        }
        return null;
    }

    public String doRemoveProfilingRule()
    {
        try
        {
            getUserManagementService().removePrincipalRulesFromUser(this);
            FacesMessageUtil
                    .addInfoMessage(
                            "removed.principalRules.from.user",
                            new Object[] {
                                    getName(),
                                    PALAdminUtil
                                            .toStringFromArray(parsePrincipalRules(getPrincipalRules())) });

            // clear
            setPrincipalRules(null);
        }
        catch (PALAdminException e)
        {
            FacesMessageUtil
                    .addErrorMessage(
                            "failed.to.remove.principalRules.from.user",
                            new Object[] {
                                    getName(),
                                    PALAdminUtil
                                            .toStringFromArray(parsePrincipalRules(getPrincipalRules())) });
            logger.error("Failed to remove principalRules from user. user="
                    + getName() + ", principalRules=" + getPrincipalRules(), e);
        }
        return null;
    }

    private Object[] parsePrincipalRules(String[] rules)
    {
        List<PrincipalRule> list = new ArrayList<PrincipalRule>();
        for (int i = 0; i < rules.length; i++)
        {
            list.add(PrincipalRule.getInstance(rules[i]));
        }
        return list.toArray();
    }

    public boolean isProfilingRulesForUser()
    {
        return getPrincipalRulesItems().size() > 0;
    }

}
