/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.util.PALAdminUtil;
import jp.sf.pal.admin.web.AbstractCrudPage;

import org.seasar.framework.log.Logger;

public class UserGroupEditPage extends AbstractCrudPage implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 1292537289932760208L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(UserGroupEditPage.class);

    private String name;

    private List<Map<String, String>> newGroupItems;

    private int newGroupIndex;

    private String newGroup;

    private List<Map<String, String>> groupsItems;

    private String[] groups;

    private UserManagementService userManagementService;

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    public List<Map<String, String>> getNewGroupItems()
    {
        return newGroupItems;
    }

    public void setNewGroupItems(List<Map<String, String>> newGroupItems)
    {
        this.newGroupItems = newGroupItems;
    }

    public List<Map<String, String>> getGroupsItems()
    {
        return groupsItems;
    }

    public void setGroupsItems(List<Map<String, String>> usersGroupItems)
    {
        this.groupsItems = usersGroupItems;
    }

    /**
     * @return the newGroup
     */
    public String getNewGroup()
    {
        return newGroup;
    }

    /**
     * @param newGroup the newGroup to set
     */
    public void setNewGroup(String newGroup)
    {
        this.newGroup = newGroup;
    }

    /**
     * @return the newGroupIndex
     */
    public int getNewGroupIndex()
    {
        return newGroupIndex;
    }

    /**
     * @param newGroupIndex the newGroupIndex to set
     */
    public void setNewGroupIndex(int newGroupIndex)
    {
        this.newGroupIndex = newGroupIndex;
    }

    /**
     * @return the usersGroup
     */
    public String[] getGroups()
    {
        if (groups == null)
        {
            groups = new String[0];
        }
        return groups;
    }

    /**
     * @param usersGroup the usersGroup to set
     */
    public void setGroups(String[] groups)
    {
        this.groups = groups;
    }

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService()
    {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService)
    {
        this.userManagementService = userManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        // load page
        getUserManagementService().loadPage(this);

        return null;
    }

    public String doAddGroup()
    {
        if (getName() == null || getNewGroup() == null)
        {
            FacesMessageUtil.addWarnMessage("invalid.group.or.user.name");
            return null;
        }

        // check if group exists
        if (getUserManagementService().isGroupExistsInUser(getName(),
                getNewGroup()))
        {
            FacesMessageUtil.addWarnMessage("group.exists.in.user",
                    new Object[] { getName(), getNewGroup() });
            return null;
        }

        try
        {
            getUserManagementService().addGroupToUser(this);
            FacesMessageUtil.addInfoMessage("added.group.to.user",
                    new Object[] { getName(), getNewGroup() });

            // clear
            setNewGroup(null);
        }
        catch (PALAdminException e)
        {
            FacesMessageUtil.addErrorMessage("failed.to.add.group.to.user",
                    new Object[] { getName(), getNewGroup() });
            logger.error("Failed to add group to user. user=" + getName()
                    + ", group=" + getNewGroup(), e);
        }
        return null;
    }

    public String doRemoveGroup()
    {
        try
        {
            getUserManagementService().removeGroupsFromUser(this);
            FacesMessageUtil.addInfoMessage("removed.groups.from.user",
                    new Object[] { getName(),
                            PALAdminUtil.toStringFromArray(getGroups()) });

            // clear
            setGroups(null);
        }
        catch (PALAdminException e)
        {
            FacesMessageUtil.addErrorMessage(
                    "failed.to.remove.groups.from.user", new Object[] {
                            getName(), getGroups() });
            logger.error("Failed to remove groups from user. user=" + getName()
                    + ", groups=" + getGroups(), e);
        }
        return null;
    }

    public boolean isGroupsForUser()
    {
        return getGroupsItems().size() > 0;
    }
}
